
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2012.  All rights reserved.
 */


/* ========================================================================== */
/*
/* CSIo : eXg y TvEvO
/*
/*  `oŃbZ[W\zAP SECS bZ[W̑MsB
/*
/*  () {Tv́AMSVCRT gpB
/*
/*
/* N@
/*
/*   CSIo {h|e}
/*   ~~~~~~~~~~
/*   h    : Sample.ini  [HOST]  ZNVQƂ肷
/*   e    : Sample.ini  [EQUIP]      :              :
/*
/*
/*   ʏACSIo h y CSIo e ̗A}VA͈قȂ}V
/*   삳āAݒʐMsBʐḾABasicIo.exeACallbackio.exe ł
/*   悢B
/*
/*   NAj\QƂAvR[h͂A@\sB
/* 
/*   zXg͋NƁAu̐ڑ҂BuNƁAI
/*   ɃzXgɐڑvASelect v𔭍sBzXgł́A1:Recv 
/*   JԂsA\uSTATUS=951 : No datavƂȂ̂mFB̌A
/*   Cӂ̃bZ[ŴƂsBMł́AMf[^̊u
/*   STATUS=951vɂȂ܂ōsƂYʂƁB
/*
/*   QbZ[W𑗐Mۂ̃gUNVhćAOɎMP
/*   bZ[Ŵ̂gpB
/*
/*   {Tv́Aُ펞ȗĂB
/*   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
/*   ɂĕ\ SECS bZ[W̏o͌`ύXłB
/*   ܂ "MSSG_USE_NEXTL" ̒lύXƁAbZ[We͂ۂɁA
/*   lf[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
/*   l "USE_CALLBACK"  =1 ƂƁAMs Callback ֐gp
/*   AMbZ[W̕\AQbZ[W̏o͂ōsB
/*   Callback ֐gpꍇA͑ipbZ[Wɗꂪ鎖ɗ
/*   邱ƁB
/*
/* ========================================================================== */

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Threading;

using TDCSL;


namespace TDCSSTest{

unsafe class CSIo{
[DllImport( "msvcrt", CallingConvention=CallingConvention.Cdecl)]
extern static int printf(string form);
[DllImport( "msvcrt", CallingConvention=CallingConvention.Cdecl)]
extern static int printf(string form, __arglist);
[DllImport( "msvcrt", CallingConvention=CallingConvention.Cdecl)]
extern static int sprintf(byte[] str, string form, __arglist);
[DllImport( "msvcrt", CallingConvention=CallingConvention.Cdecl)]
extern static int scanf(string form, __arglist);


/* -------------------------------------------------------------------------- */

private const int	EBADF		=9;
private const int	EBUSY		=16;
private const int	ENOMEM		=12;
private const int	ENODEV		=19;
private const int	E2BIG		=7;

private const int	E_NOTCONNECT	=999;
private const int	E_DESELECT	=998;
private const int	E_REJECT	=997;
private const int	E_SELECT	=992;
private const int	E_CONNECT	=991;
private const int	E_RETRYOVER	=989;
private const int	E_T8TIMEDOUT	=988;
private const int	E_T7TIMEDOUT	=987;
private const int	E_T6TIMEDOUT	=986;
private const int	E_T5TIMEDOUT	=985;
private const int	E_T4TIMEDOUT	=984;
private const int	E_T3TIMEDOUT	=983;
private const int	E_T2TIMEDOUT	=982;
private const int	E_T1TIMEDOUT	=981;
private const int	E_ILLBLOCK	=980;
private const int	E_NODATA	=951;


/* -------------------------------------------------------------------------- */

private static int	MSSG_USE_FILE	=0x80;	// bZ[W`t@C
						// 0x00 : gpȂ
						// 0x80 : gpčږ\
private static int	MSSG_DISP_TYPE	=0x20;	// SECS bZ[W\`
						// 0x00 : ʏ`
						// 0x10 : ????`
						// 0x20 : SML `
						// 0x40 : NSG/TS300 `
private static int	MSSG_USE_NEXTL	=1;	// MssgNextL gp邩ۂ
						// 0    : gpȂ
						// 1    : gp

private static int	USE_CALLBACK	=1;	// Callback ֐gp̗L
						// 0    : gpȂ
						// 1    : gp

private static string	PARAMFILE	="Sample.ini";


/* -------------------------------------------------------------------------- */

private static int	Fd=0;		// ʐMpʎq
private static int	Md=0;		// bZ[W͗pʎq
private static int	Break=0;	// XbhIw
private static int	OType=0;	// ^Cv (0:Host 1:Equip)
private static int	Status=0;	// 
					// (0:ڑ 1:Select 2:Select)

private static int	cnt249=0;
private static int	cnt250=0;
private static int	cnt611=0;


/* ========================================================================== */
/* ʊ֐ ================================================================= */


/* -------------------------------------------------------------------------- */
/* SECS bZ[WWo͂ɕ\B ------------------------------------ */

private static void
DispSECSMssg(			//
int		tp,		// i  : bZ[W
				//	=0 : M
				//	 1 : MbZ[W
				//	 2 : MbZ[W
byte[]		hd,		// i  : SECS bZ[WEwb_
int		did,		// i  : SECS bZ[W̃foCXhc
int		sf,		// i  : SECS bZ[ŴreR[h
uint		xid,		// i  : SECS bZ[W̃gUNVhc
byte[]		msg,		// i  : SECS bZ[Wi[̈iwb_܂܂j
int		len)		// i  : SECS bZ[W̃oCg
{
  string[]	ctp={"SRES","RECV","SEND"};
  string	mname,sitem;
  byte[]	itm=new byte[64];
  short[]	vi2=new short[1];
  ushort[]	vu2=new ushort[1];
  int[]		vi4=new int[1];
  uint[]	vu4=new uint[1];
  long[]	vi8=new long[1];
  ulong[]	vu8=new ulong[1];
  float[]	vf4=new float[1];
  double[]	vf8=new double[1];
  string	str,rbit,wbit;
  byte[]	sfcode=new byte[16];
  int		rtn,md=0,dp=MSSG_USE_FILE|MSSG_DISP_TYPE,fm,form,sz,noi,la,i;

  rbit=" ";	if((did&0x8000)!=0)	rbit="R";
  wbit=" ";	if((sf &0x8000)!=0)	wbit="W";
  sprintf(sfcode,"S%dF%d",__arglist((sf&0x7f00)/0x0100,sf&0xff));
  printf("[%s]  Dev=0x%04x  %-8s  %s%s  XId=0x%04x  Len=%4d\n"
		,__arglist(ctp[tp],did&0x7fff,sfcode,rbit,wbit,xid,len));

  if((MSSG_USE_FILE&0x80)!=0)	fm =0x8000;		// bZ[W`gp
  else				fm =0x0000;		// gp

  if(len>0){
    if(tp==1){	dp|=0x3000;	fm|=0x3000;}		// M̏ꍇ
    else{	dp|=0x2000;	fm|=0x2000;}		// M̏ꍇ

    if((md=TDS._MssgFind(fm,msg,len,Fd,hd,out mname))	> 0){
      if(mname!="") printf("[%s]\n",__arglist(mname));	// bZ[W

      for(la=0;;){
	if(MSSG_USE_NEXTL==0){				// ڒl擾
	  fixed(byte* pm=itm){
	    rtn=TDS._MssgNext(md,0,msg,out form,out sz,out noi,pm,64,out sitem);
	    if(rtn					< 0)	break;
	    printf("%03o:%d*%2d:",__arglist(form,sz,noi));
	    switch(form){				// ڒl̕\
							// l̂QԖڈȍ~͏ȗ
	      case 0x00: Console.WriteLine("L[{0}]"	    ,noi);	   break;
	      case 0x08: Console.WriteLine("B[{0}]={1,0:x2}",noi,itm[0]);  break;
	      case 0x09: Console.WriteLine("T[{0}]={1,0}"   ,noi,itm[0]);  break;
	      case 0x10: Console.WriteLine("A[{0}]={1}"	    ,noi,sitem);   break;
	      case 0x11: Console.WriteLine("J[{0}]={1}"	    ,noi,sitem);   break;
	      case 0x12: Console.WriteLine("K[{0}]={1}"	    ,noi,sitem);   break;
	      case 0x18: Buffer.BlockCopy(itm,0,vi8,0,sz);
			 Console.WriteLine("I8[{0}]={1}"    ,noi,vi8[0]);  break;
	      case 0x19: Console.WriteLine("I1[{0}]={1}"    ,noi,itm[0]);  break;
	      case 0x1a: Buffer.BlockCopy(itm,0,vi2,0,sz);
			 Console.WriteLine("I2[{0}]={1}"    ,noi,vi2[0]);  break;
	      case 0x1c: Buffer.BlockCopy(itm,0,vi4,0,sz);
			 Console.WriteLine("I4[{0}]={1}"    ,noi,vi4[0]);  break;
	      case 0x20: Buffer.BlockCopy(itm,0,vf8,0,sz);
			 Console.WriteLine("F8[{0}]={1}"    ,noi,vf8[0]);  break;
	      case 0x24: Buffer.BlockCopy(itm,0,vf4,0,sz);
			 Console.WriteLine("F4[{0}]={1}"    ,noi,vf4[0]);  break;
	      case 0x28: Buffer.BlockCopy(itm,0,vu8,0,sz);
			 Console.WriteLine("U8[{0}]={1}"    ,noi,vu8[0]);  break;
	      case 0x29: Console.WriteLine("U1[{0}]={1}"    ,noi,itm[0]);  break;
	      case 0x2a: Buffer.BlockCopy(itm,0,vu2,0,sz);
			 Console.WriteLine("U2[{0}]={1}"    ,noi,vu2[0]);  break;
	      case 0x2c: Buffer.BlockCopy(itm,0,vu4,0,sz);
			 Console.WriteLine("U4[{0}]={1}"    ,noi,vu4[0]);  break;
	      default:	 Console.WriteLine("");				   break;
	  } }

	}else{						// Xg\`Ŏ擾
	  rtn=TDS._MssgNextL(md,dp,msg,out form,out noi,out str);
	  if(rtn					< 0)	break;
	  if((dp&0x70)>0x10){				// SMLANSG/TS300 ̏ꍇ
	    for(i=la;i>rtn;i--){
	      printf("%*s>\n"	,__arglist(i*2,""));	// '>' \
	  } }
	  la=rtn;					// ݂̊Kwۑ
	  printf("  %s\n",__arglist(str));		// 擾ڒl\
	  if((dp&0x70)>0x10 && form==000 && noi==0){
	    printf("%*s>\n"	,__arglist((la+1)*2,""));// L0 ̏ꍇ '>' 
      } } }
      if(MSSG_USE_NEXTL!=0){
	if((dp&0x70)>0x10){
	   for(i=la;i>0;i--){
	     printf("%*s>\n"	,__arglist(i*2,""));	// c '>' \
      } } }
      TDS._MssgExit(md,0,msg);
  } }
}



/* -------------------------------------------------------------------------- */
/* Mf[^\B-------------------------------------------------- */

private static int
DispData(
int		tp,		// i  : bZ[W
				//	=0 : M
				//	 1 : MbZ[W
				//	 2 : MbZ[W
byte[]		hd,		// i  : SECS bZ[WEwb_
int		did,		// i  : SECS bZ[W̃foCXhc
int		sf,		// i  : SECS bZ[ŴreR[h
uint		xid,		// i  : SECS bZ[W̃gUNVhc
byte[]		msg,		// i  : SECS bZ[W{
int		len,		// i  : msg ̒
int		rtn)		// i  : I/O ̖߂l
{
  int		ok=0;

  if(rtn<0){							 ok=1;
    if((rtn<(-E_NOTCONNECT) || (-E_ILLBLOCK)<rtn) && rtn!=(-E_NODATA)){
      printf("ERROR  [%d]"			,__arglist(rtn));
      if      (rtn==(-ENODEV)){
	printf(" : No such device ID\n");	len=ok=0;
      }else if(rtn==(-E2BIG )){
	printf(" : Data size to large\n");	len=ok=0;
      }else			printf("\n");
    }else{
      printf("STATUS = %d,%d : "		,__arglist(-rtn,Status));
      switch(-rtn){
	case E_NODATA:		printf("No data\n");			break;
	case E_ILLBLOCK:	printf("Illegal block#\n");		break;
	case E_T1TIMEDOUT:	printf("T1 Timeout occur\n");		break;
	case E_T2TIMEDOUT:	printf("T2 Timeout occur\n");		break;
	case E_T3TIMEDOUT:	printf("T3 Timeout occur\n");		break;
	case E_T4TIMEDOUT:	printf("T4 Timeout occur\n");		break;
	case E_T5TIMEDOUT:	printf("T5 Timeout occur\n");		break;
	case E_T6TIMEDOUT:	printf("T6 Timeout occur\n");		break;
	case E_T7TIMEDOUT:	printf("T7 Timeout occur\n");		break;
	case E_T8TIMEDOUT:	printf("T8 Timeout occur\n");		break;
	case E_RETRYOVER:	printf("Retry over\n");			break;
	case E_CONNECT:		printf("Connected\n");			break;
	case E_SELECT:		printf("Selected\n");			break;
	case E_REJECT:		printf("Rejected XId=0x%04x\n"
						,__arglist(xid));	break;
	case E_DESELECT:	printf("Deselected\n");			break;
	case E_NOTCONNECT:	printf("Not connected\n");		break;
	default:		printf("\n");				break;
  } } }

  if(ok==0) DispSECSMssg(tp,hd,did,sf,xid,msg,len);

  return(0);
}



/* ========================================================================== */
/* S1F1 bZ[W\zyёM ---------------------------------------------- */

private static int
SendS1F1()
{
  byte[]	hd=new byte[12],msg=new byte[16];
  int		rtn,sf=0x8101,len=0;

  rtn=TDS._CommSend(Fd,0x0000,0,sf,0,msg,len,ref hd);
  DispData(2,hd,0x00,sf,(uint)rtn,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Host) \zyёM -------------------------------------- */

private static int
SendS1F2H(
int		did,
uint		xid)
{
  byte[]	hd=new byte[12],msg=new byte[256];
  byte[]	vb=new byte[32];
  int		rtn,md,sf=0x0102,len;
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		TDS._MssgInit   (   0,ref msg, 256,Fd);		// S1F2
		TDS._MssgBuild  (md,0,ref msg,0x00,  0,vb);	// L0
    len=	TDS._MssgEnd    (md,0,ref msg);

  }else{					// bZ[W`gp
		TDS._MDMssgInit (Md,0,ref msg, 256,"S1F2_H");
    len=	TDS._MDMssgEnd  (Md,0,ref msg);
  }

  if(len<0)	rtn=len;
  else		rtn=TDS._CommSend (Fd,0x0000,0,sf,xid,msg,len,ref hd);
  DispData(2,hd,did,sf,(uint)rtn,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Equip) \zyёM ------------------------------------- */

private static int
SendS1F2E(
int		did,
uint		xid)
{
  byte[]	hd=new byte[12],msg=new byte[256];
  byte[]	vb=new byte[32];
  int		rtn,md,sf=0x0102,len;
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		TDS._MssgInit   (   0,ref msg, 256,Fd);		// S1F2
		TDS._MssgBuild  (md,0,ref msg,0x00, 2,vb);	// L2
		TDS._MssgBuild  (md,0,ref msg,0x10, 6,"EQUIP1");//  MDLN
		TDS._MssgBuild  (md,0,ref msg,0x10, 6,"01.000");//  SOFTREV
    len=	TDS._MssgEnd    (md,0,ref msg);

  }else{					// bZ[W`gp
		TDS._MDMssgInit (Md,0,ref msg, 256,"S1F2_E");
    len=	TDS._MDMssgEnd  (Md,0,ref msg);
  }

  if(len<0)	rtn=len;
  else		rtn=TDS._CommSend (Fd,0x0000,0,sf,xid,msg,len,ref hd);
  DispData(2,hd,did,sf,(uint)rtn,msg,len,rtn);

  return(rtn);
}


/* ========================================================================== */
/* S2F49 bZ[W\zyёM --------------------------------------------- */

private static int
SendS2F49()
{
  byte[]	hd=new byte[12],msg=new byte[1024];
  byte[]	vb=new byte[32];
  int[]		vi=new int[4];
  string	str,itm;
  int		rtn,md,sf=0x8200+49,no1,no2,len,i,j;

  cnt249++;	no1=(cnt249%2)+1;	no2=(cnt249%10)+1;
  str=string.Format("LOTID ({0,0:d4})",cnt249);
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		TDS._MssgInit   (   0,ref msg,1024,Fd);		// S2F49
  		TDS._MssgBuild  (md,0,ref msg,0x00,  3,vb);	// L3
    vb[0]=0;	TDS._MssgBuild  (md,0,ref msg,0x08,  1,vb);	//  DATAIDB
  		TDS._MssgBuild  (md,0,ref msg,0x10,  0,"LOAD");	//  RCMD
  		TDS._MssgBuild  (md,0,ref msg,0x00,  4,vb);	//  L4
    vb[0]=1;	TDS._MssgBuild  (md,0,ref msg,0x08,  1,vb);	//   STID
    vb[0]=0;	TDS._MssgBuild  (md,0,ref msg,0x08,  1,vb);	//   MTKD
  		TDS._MssgBuild  (md,0,ref msg,0x10, 20,str);	//   LOTID
		TDS._MssgBuild  (md,0,ref msg,0x00,no1,vb);	//   L[no1]
    for(i=0;i<no1;i++){
		TDS._MssgBuild  (md,0,ref msg,0x00,no2,vb);	//    L[no2]
      for(j=0;j<no2;j++){
		TDS._MssgBuild  (md,0,ref msg,0x00,  2,vb);	//     L[2]
	str=string.Format("WAFER({0,0:d4}-{1,0:d1}-{2,0:d2})",cnt249,i+1,i+2);
  		TDS._MssgBuild  (md,0,ref msg,0x10, 20,str);	//      WAFERID
	str=string.Format("PPID ({0,0:d4}-{1,0:d1}-{2,0:d2})",cnt249,i+1,i+2);
  		TDS._MssgBuild  (md,0,ref msg,0x10, 16,str);	//      PPID
    } }
    len=	TDS._MssgEnd    (md,0,ref msg);

  }else{					// bZ[W`gp
		TDS._MDMssgInit (Md,0,ref msg,1024,"S2F49");
  		TDS._MDMssgBuild(Md,0,ref msg,"LOTID",0,str);	//   LOTID
    vi[0]=no1;	TDS._MDMssgBuild(Md,0,ref msg,"NOI1" ,1,vi);	//   L[no1]
    for(i=0;i<no1;i++){
      itm  =string.Format("NOI2:{0,0:d1}"		,i+1);
      vi[0]=no2;TDS._MDMssgBuild(Md,0,ref msg,itm   ,1,vi);	//    L[no2]
      for(j=0;j<no2;j++){
	itm=string.Format("WAFERID:{0,0:d1}:{1,0:d1}"	,i+1,j+1);
	str=string.Format("WAFERID[{0,0:d4}-{1,0:d1}-{1,0:d2}]"
						,cnt249	,i+1,j+1);
  		TDS._MDMssgBuild(Md,0,ref msg,itm    ,0,str);	//     WAFERID
	itm=string.Format("PPID:{0,0:d1}:{1,0:d1}"	,i+1,j+1);
	str=string.Format("PPID [{0,0:d4}-{1,0:d1}-{1,0:d2}]"
						,cnt249	,i+1,j+1);
  		TDS._MDMssgBuild(Md,0,ref msg,itm    ,0,str);	//     PPID
    } }
    len=	TDS._MDMssgEnd  (Md,0,ref msg);
  }

  if(len<0)	rtn=len;
  else		rtn=TDS._CommSend (Fd,0x0000,0,sf,0,msg,len,ref hd);
  DispData(2,hd,0x00,sf,(uint)rtn,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S2F50 bZ[W\zyёM --------------------------------------------- */

private static int
SendS2F50(
int		did,
uint		xid)
{
  byte[]	hd=new byte[12],msg=new byte[256];
  byte[]	vb=new byte[32];
  string	str;
  int		rtn,md,sf=0x0200+50,len;
  
  str=string.Format("LOTID ({0,0:d4})"	,++cnt250);

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		TDS._MssgInit   (   0,ref msg, 256,Fd);		// S2F50
		TDS._MssgBuild  (md,0,ref msg,0x00,  2,vb);	// L2
    vb[0]=0;	TDS._MssgBuild  (md,0,ref msg,0x08,  1,vb);	//  HCACK
		TDS._MssgBuild  (md,0,ref msg,0x00,  2,vb);	//  L2
  		TDS._MssgBuild  (md,0,ref msg,0x10,  5,"PODID");//   PODID
  		TDS._MssgBuild  (md,0,ref msg,0x10, 20,str);	//   LOTID
    len=	TDS._MssgEnd    (md,0,ref msg);

  }else{					// bZ[W`gp
		TDS._MDMssgInit (Md,0,ref msg, 256,"S2F50");
		TDS._MDMssgBuild(Md,0,ref msg,"LOTID",  0,str);	//   LOTID
    len=	TDS._MDMssgEnd  (Md,0,ref msg);
  }

  if(len<0)	rtn=len;
  else		rtn=TDS._CommSend (Fd,0x0000,0,sf,xid,msg,len,ref hd);
  DispData(2,hd,did,sf,(uint)rtn,msg,len,rtn);

  return(rtn);
}


/* ========================================================================== */
/* S6F11 bZ[W\zyёM --------------------------------------------- */

private static int
SendS6F11()
{
  byte[]	hd=new byte[12],msg=new byte[256];
  ushort[]	vs=new ushort[4];
  int		rtn,md,sf=0x8600+11,len;

  if((++cnt611)==65536) cnt611=0;

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		TDS._MssgInit   (   0,ref msg, 256,Fd);		// S6F11
  		TDS._MssgBuild  (md,0,ref msg,0x00,  3,vs);	// L3
    vs[0]=(ushort)cnt611;
		TDS._MssgBuild	(md,0,ref msg,0x2a,  1,vs);	//  DATAID
    vs[0]=8;	TDS._MssgBuild  (md,0,ref msg,0x2a,  1,vs);	//  CEID
  		TDS._MssgBuild  (md,0,ref msg,0x00,  3,vs);	//  L3
  		TDS._MssgBuild  (md,0,ref msg,0x10, 16,"DATA1");//   DATA1
  		TDS._MssgBuild  (md,0,ref msg,0x10, 16,"DATA2");//   DATA2
  		TDS._MssgBuild  (md,0,ref msg,0x10, 14,"YYYYMMDDhhmmss");
						// @TIME ({͌ݎݒ
						// ̂AȗB
    len=	TDS._MssgEnd    (md,0,ref msg);

  }else{					// bZ[W`gp
		TDS._MDMssgInit (Md,0,ref msg, 256,"S6F11");
    vs[0]=(ushort)cnt611;
		TDS._MDMssgBuild(Md,0,ref msg,"DATAID",1,vs);	//  DATAID
    len=	TDS._MDMssgEnd  (Md,0,ref msg);
  }

  if(len<0)	rtn=len;
  else		rtn=TDS._CommSend (Fd,0x0000,0,sf,0,msg,len,ref hd);
  DispData(2,hd,0x00,sf,(uint)rtn,msg,len,rtn);

  return(rtn);
}



/* ---------------------------------------------------------------------------*/
/* S6F12 bZ[W\zyёM --------------------------------------------- */

private static int
SendS6F12(
int		did,
uint		xid)
{
  byte[]	hd=new byte[12],msg=new byte[256];
  byte[]	vb=new byte[32];
  int		rtn,md,sf=0x0600+12,len;

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		TDS._MssgInit	(   0,ref msg, 256,Fd);		// S6F12
    vb[0]=0;	TDS._MssgBuild	(md,0,ref msg,0x08,  1,vb);	// ACKC
    len=	TDS._MssgEnd 	(md,0,ref msg);

  }else{					// bZ[W`gp
		TDS._MDMssgInit (Md,0,ref msg, 256,"S6F12");
    len=	TDS._MDMssgEnd  (Md,0,ref msg);
  }

  if(len<0)	rtn=len;
  else		rtn=TDS._CommSend (Fd,0x0000,0,sf,xid,msg,len,ref hd);
  DispData(2,hd,did,sf,(uint)rtn,msg,len,rtn);

  return(rtn);
}



/* ========================================================================== */
/* Callback ֐ ============================================================ */

private static int
CBRecvProc(
int		req,		// i  : Cuւ̗vR[h
int		rtn,		// i  : Cu̖߂l
int		did,		// i  : SECS bZ[W̃foCXhc
int		xsf,		// i  : SECS bZ[ŴreR[h
uint		xid,		// i  : SECS bZ[W̃gUNVhc
byte[]		xhd,		// i  : SECS bZ[WEwb_
byte[]		xmsg)		// i  : SECS bZ[W
{
  byte[]	hd=new byte[12],msg=new byte[1024];
  string	rname,sname;
  int		len,sf;

  DispData(1,xhd,did,xsf,xid,xmsg,rtn,rtn);
  switch(rtn){
    case -E_CONNECT:	Status=1;	break;		// Connected
    case -E_SELECT:	Status=2;	break;		// Selected
    case -E_DESELECT:	Status=1;	break;		// Deselected
    case -E_NOTCONNECT:	Status=0;	break;		// Not connected
  }

  if      (req== 0 && rtn>=0){
    if((MSSG_USE_FILE&0x80)==0){	// bZ[W`t@CgpȂ
					// ꍇ́A͂ SF-Code 𒲂ׁAQ
					// bZ[W̑o̕Kv𔻒fA
					// Kvȏꍇ́AoB
      if     (xsf==(0x8100+ 1)&&OType==0)	SendS1F2H (did,xid);
      else if(xsf==(0x8100+ 1)&&OType==1)	SendS1F2E (did,xid);
      else if(xsf==(0x8200+49))			SendS2F50 (did,xid);
      else if(xsf==(0x8600+11))			SendS6F12 (did,xid);

    }else if((xsf&0x8000)!=0){		// bZ[W`t@Cgp
					// ꍇ́A{Tvł́AԐM@\
					// gpB
      msg=xmsg;
      if((len=TDS._MDMssgAutoRes(Md,0,xhd
		,ref msg,rtn,1024,out rname,out sname,out sf))	>=0){
	printf("RECV %s ..  Auto respond %s [S%dF%d]\n"
		,__arglist(rname,sname,sf/0x100,sf&0xff));
	rtn=TDS._CommSend(Fd,0x0000,0,sf,xid,msg,len,ref hd);
	DispData(2,hd,did,sf,xid,msg,len,rtn);
      }else{
	if(len!=(-930) && len!=(-931)){
	  printf("RECV Auto response error (%d)\n",__arglist(len));
  } } } }

  return(0);
}



/* -------------------------------------------------------------------------- */

private static void
RecvProcThread(
object		param)
{
  byte[]	msg=new byte[1024],hd=new byte[12];
  uint		xid;
  int		rtn,req,devid,sf;

  for(;Break==0;){
    req=0;
    rtn=TDS._CommRecv(Fd,0,out devid,out sf,out xid,ref msg,1024,ref hd);
    if(rtn==(-951)){
      Thread.Sleep(100);
    }else{
      if((-1000)<rtn && rtn<(-979))	req=(-rtn)-900;
      CBRecvProc(req,rtn,devid,sf,xid,hd,msg);
  } }
}



/* ========================================================================== */
/* Main  ---------------------------------------------------------------- */

static int
Main(
string[]		argv)
{
  if(argv.Length<1 || (argv[0]!="h" && argv[0]!="e")){
    printf("CSIo {h|e}\n");

  }else{
    if(argv[0]=="h")	Host ();
    else		Equip();
  }

  return(0);
}



/* ========================================================================== */
/* zXg ------------------------------------------------------------- */

private static void
Host()
{
  Thread		th;
  byte[]		hd=new byte[12],msg=new byte[1024];
  uint			xid,xids=0;
  int			req,rtn,mno,did=0,sf=0;

  OType=0;	Break=0;
  if((Fd=TDS._CommOpen(0x02,PARAMFILE,"HOST"))			< 0) goto Exit;
  printf("(H) Opened (%d)\n",__arglist(Fd));
  if((MSSG_USE_FILE&0x80)!=0) Md=TDS._MDMssgInitialize(0x4000,Fd,"");

  if(USE_CALLBACK!=0){
    th=new Thread(new ParameterizedThreadStart(RecvProcThread));
    th.Start("");
  }

  for(;;){		rtn=0;
    if(USE_CALLBACK==0)	printf("Req (0:Exit 1:Recv 2:Send) : ");
    else		printf("Req (0:Exit 2:Send) : ");
    scanf ("%d",__arglist(out req));
    if      (req==0){						break;

    }else if(req==1){
      if((rtn=TDS._CommRecv(Fd,0,out did,out sf,out xid
					,ref msg,1024,ref hd))	>=0) xids=xid;
      DispData(1,hd,did,sf,xid,msg,rtn,rtn);

    }else if(req==2){
      if(USE_CALLBACK==0) printf("Message(1:S1F1 2:S2F49  6:S1F2 7:S6F12) : ");
      else		  printf("Message(1:S1F1 2:S2F49) : ");
      scanf("%d",__arglist(out mno));
      switch(mno){
	case 1: rtn=SendS1F1 ();		break;
	case 2: rtn=SendS2F49();		break;
	case 6: rtn=SendS1F2H(did,xids);	break;
	case 7: rtn=SendS6F12(did,xids);	break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      printf("(H) I/O Error (%d)\n"	,__arglist(rtn));
  } }

Exit:
  Break=1;
  if(Md>0) TDS._MDMssgTerminate(Md,0);
  if(Fd>0) TDS._CommClose(Fd,0);
  else	   printf("(H) Error (%d)\n"	,__arglist(Fd));
}



/* ========================================================================== */
/* u --------------------------------------------------------------- */

private static void
Equip()
{
  Thread		th;
  byte[]		hd=new byte[12],msg=new byte[1024];
  uint			xid,xids=0;
  int			req,rtn,mno,did=0,sf=0;

  OType=1;	Break=0;
  if((Fd=TDS._CommOpen(0x02,PARAMFILE,"EQUIP"))			< 0) goto Exit;
  printf("(E) Opened (%d)\n",__arglist(Fd));
  if((MSSG_USE_FILE&0x80)!=0) Md=TDS._MDMssgInitialize(0x4000,Fd,"");

  if(USE_CALLBACK!=0){
    th=new Thread(new ParameterizedThreadStart(RecvProcThread));
    th.Start("");
  }

  if(TDS._CommSend(Fd,0x0100,0,0,0,msg,0,ref hd)		< 0) goto Exit;
  printf("(E) Connected\n");
  if(TDS._CommSend(Fd,0x0200,0,0,0,msg,0,ref hd)		< 0) goto Exit;
  printf("(E) Selected\n");

  for(;;){		rtn=0;
    if(USE_CALLBACK==0)	printf("Req (0:Exit 1:Recv 2:Send) : ");
    else		printf("Req (0:Exit 2:Send) : ");
    scanf ("%d",__arglist(out req));
    if      (req==0){						 break;

    }else if(req==1){
      if((rtn=TDS._CommRecv(Fd,0,out did,out sf,out xid
					,ref msg,1024,ref hd))	>=0) xids=xid;
      DispData(1,hd,did,sf,xid,msg,rtn,rtn);

    }else if(req==2){
      if(USE_CALLBACK==0) printf("Message(1:S1F1 2:S6F11  6:S1F2 7:S2F50) : ");
      else		  printf("Message(1:S1F1 2:S6F11) : ");
      scanf("%d",__arglist(out mno));
      switch(mno){
	case 1: rtn=SendS1F1 ();		break;
	case 2: rtn=SendS6F11();		break;
	case 6: rtn=SendS1F2E(did,xids);	break;
	case 7: rtn=SendS2F50(did,xids);	break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      printf("(E) I/O Error (%d)\n"	,__arglist(rtn));
  } }

// Deselect request ͍sȂBiSEMI ł HSMS-SS ɂāADeselect request
// ͍sĂ͂ȂȂAƂĂBj
//if(TDS._CommSend(Fd,0x0800,0,0,0,msg,0,ref hd)		< 0) goto Exit;
//printf("(E) Deselected\n");
  if(TDS._CommSend(Fd,0x0900,0,0,0,msg,0,ref hd)		< 0) goto Exit;
  printf("(E) Separate\n");

Exit:
  Break=1;
  if(Md>0) TDS._MDMssgTerminate(Md,0);
  if(Fd>0) TDS._CommClose(Fd,0);
  else	   printf("(E) Error (%d)\n"	,__arglist(Fd));
}

}
}
