
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2015.  All rights reserved.
 */


/* ========================================================================== */
/*
 * BasicIo : eXg y TvEvO
 *
 *  `oŃbZ[W\zAP SECS bZ[W̑MsB
 * 
 *  () HSMS B SECS-1 ɂ͖ΉB
 *
 *
 * N@
 *
 *   BasicIo {h|e}
 *   ~~~~~~~~~~~~~
 *   h    : Sample.ini  [HOST]  ZNVQƂ肷
 *   e    : Sample.ini  [EQUIP]      :              :
 *
 *
 *   ʏABasicIo h y BasicIo e ̗A}VA͈قȂ
 *   }Vœ삳āAݒʐMsB
 *
 *   NAj\QƂAvR[h͂A@\sB
 *   zXgAu Callback ֐gpAReceive vR[h
 *   ɉčsB
 *   bZ[W`t@Cgpꍇ́AbZ[W`t@Cɒ`
 *   Cӂ̃bZ[Ŵw肷邱ƂɂÃbZ[W𑗏oB
 * 
 *   zXg͋NƁAu̐ڑ҂BuNƁAI
 *   ɃzXgɐڑvASelect v𔭍sBzXgł́A1:Recv 
 *   JԂsA\uSTATUS=951 : No datavƂȂ̂mFB̌A
 *   Cӂ̃bZ[ŴƂsBMł́AMf[^̊u
 *   STATUS=951vɂȂ܂ōsƂYʂƁB
 *
 *   QbZ[W𑗐Mۂ̃gUNVhćAOɎMP
 *   bZ[Ŵ̂gpB
 *
 *   {Tv́Aُ펞ȗĂB
 *   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
 *   ɂĕ\ SECS bZ[W̏o͌`ύXłB
 *   ܂ MSSG_USE_NEXTL ̒lύXƁAbZ[We͂ۂɁA
 *   lf[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
 */
/* ========================================================================== */

#include	"TDS.h"


#define		PO		fprintf(stdout
#define		PE		fprintf(stderr

#define		SECS_MODE	0x01		// SECS/HSMS [h
						// 0x00 : SECS-1
						// 0x01 : HSMS
#define		MSSG_USE_FILE	0x80		// bZ[W`t@C
						// 0x00 : gpȂ
						// 0x80 : gpčږ\
#define		MSSG_DISP_TYPE	0x20		// SECS bZ[W\`
						// 0x00 : ʏ`
						// 0x10 : ????`
						// 0x20 : SML `
						// 0x40 : NSG/TS300 `
#define		MSSG_USE_NEXTL	1		// MssgNextL gp邩ۂ
						// 0    : gpȂ
						// 1    : gp

#define		PARAMFILE	"Sample.ini"


static void	Host();
static void	Equip();



/* ========================================================================== */
/* ʊ֐ ================================================================= */

#include	"SubFunctions.h"



/* ========================================================================== */
/* Main  ---------------------------------------------------------------- */

int
main(
int			argc,
char			*argv[])
{
  if(argc<2 || (argv[1][0]!='h' && argv[1][0]!='e')){
    PE,"%s {host|equip}\n"	,argv[0]);			exit(1);
  }
//InitializeCriticalSection(&Cs0);
  InitializeCriticalSection(&Cs1);

  if(argv[1][0]=='h')	Host ();
  else			Equip();

//DeleteCriticalSection(&Cs0);
  DeleteCriticalSection(&Cs1);
  exit(0);
}



/* ========================================================================== */
/* zXg ------------------------------------------------------------- */

static void
Host()
{
  TDSECSHead		hd;
  char			msg[1024],mname[64];
  unsigned int		xid,xids=0;
  int			req,rtn,msz,mno;

  msz=sizeof(msg);
  if((Fd=_TDSCommOpen(0x02,PARAMFILE,"HOST",0,0,0,0,0,0))	< 0) goto Exit;
  PO,"(H) Opened (%d)\n",Fd);
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);

  for(;;){
    PE,"Req (0:Exit 1:Recv 2:Send) : "); scanf("%d",&req);
    if      (req==0){						break;

    }else if(req==1){
      if((rtn=_TDSCommRecv(Fd,0,0,0,&xid,msg,msz,&hd))	>=0) xids=xid;
      DispData(1,&hd,msg,rtn,rtn);

    }else if(req==2){
      PE,"Message(1:S1F1 2:S2F49   6:S1F2 7:S6F12   9:Any) : ");
      scanf("%d",&mno);
      switch(mno){
	case 1: rtn=SendS1F1 ();			break;
	case 2: rtn=SendS2F49();			break;
	case 6: rtn=SendS1F2H(xids);			break;
	case 7: rtn=SendS6F12(xids);			break;
	case 9: if((MSSG_USE_FILE&0x80)!=0){
		  PE,"Message Name : ");	scanf("%s",mname);
		  rtn=SendNamedMssg(xids,mname);
		}					break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      PE,"(H) I/O Error (%d)\n",	rtn);
  } }

Exit:
  if(Md>0) _TDSMDMssgTerminate(Md,0);
  if(Fd>0) _TDSCommClose(Fd,0);
  else	   PE,"(H) Error (%d)\n",Fd);
}



/* ========================================================================== */
/* u --------------------------------------------------------------- */

static void
Equip()
{
  TDSECSHead		hd;
  char			msg[1024],mname[64];
  unsigned int		xid,xids=0;
  int			req,rtn,msz,mno;

  msz=sizeof(msg);
  if((Fd=_TDSCommOpen(0x02,PARAMFILE,"EQUIP",0,0,0,0,0,0))	< 0) goto Exit;
  PO,"(E) Opened (%d)\n",Fd);
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);
  if((SECS_MODE&0x01)!=0){			// HSMS ̏ꍇAڑ
    if(_TDSCommSend(Fd,0x0100,0,0,0,0,0,0)			< 0) goto Exit;
    PO,"(E) Connected\n");
    if(_TDSCommSend(Fd,0x0200,0,0,0,0,0,0)			< 0) goto Exit;
    PO,"(E) Selected\n");
  }

  for(;;){		rtn=0;
    PE,"Req (0:Exit 1:Recv 2:Send) : "); scanf("%d",&req);
    if      (req==0){						 break;

    }else if(req==1){
      if((rtn=_TDSCommRecv(Fd,0,0,0,&xid,msg,msz,&hd))	>=0) xids=xid;
      DispData(1,&hd,msg,rtn,rtn);

    }else if(req==2){
      PE,"Message(1:S1F1 2:S6F11   6:S1F2 7:S2F50   9:Any) : ");
      scanf("%d",&mno);
      switch(mno){
	case 1: rtn=SendS1F1 ();			break;
	case 2: rtn=SendS6F11();			break;
	case 6: rtn=SendS1F2E(xids);			break;
	case 7: rtn=SendS2F50(xids);			break;
	case 9: if((MSSG_USE_FILE&0x80)!=0){
		  PE,"Message Name : "); scanf("%s",mname);
		  rtn=SendNamedMssg(xids,mname);
		}					break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      PE,"(E) I/O Error (%d)\n",	rtn);
  } }

  if((SECS_MODE&0x01)!=0){			// HSMS ̏ꍇAؒf
  // Deselect request ͍sȂBiSEMI ł HSMS-SS ɂāADeselect request
  // ͍sĂ͂ȂȂAƂĂBj
  //if(_TDSCommSend(Fd,0x0800,0,0,0,0,0,0)			< 0) goto Exit;
  //PO,"(E) Deselected\n");
    if(_TDSCommSend(Fd,0x0900,0,0,0,0,0,0)			< 0) goto Exit;
    PO,"(E) Separate\n");
  }

Exit:
  if(Md>0) _TDSMDMssgTerminate(Md,0);
  if(Fd>0) _TDSCommClose(Fd,0);
  else	   PE,"(E) Error (%d)\n",Fd);
}
