
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2015.  All rights reserved.
 */


/* ========================================================================== */
/*
 * CallbackIo : eXg y TvEvO
 *
 *  Callback ֐gpĎMbZ[Wɑ΂鉞sB܂A[U
 *  `g[Xo͊֐gpAg[Xo͂͂ōsB
 *
 *
 * N@
 *
 *   CallbackIo {h|e}
 *   ~~~~~~~~~~~~~~~~
 *   h    : Sample.ini  [HOST]  ZNVQƂ肷
 *   e    : Sample.ini  [EQUIP]      :              :
 *
 *
 *   ʏACallbackIo h y CallbackIo e ̗A}VA͈قȂ
 *   }Vœ삳āAݒʐMsB
 *
 *   N̑ƂẮA^C ̓͂ɂ胁j\sAvR[h
 *   āA葤ɃbZ[W𑗏oB
 *   MbZ[WAyъeCxg Callback ֐̒ŏ
 *   BL "MSSG_USE_FILE"  0x80 ɐݒ肷ƁACallbackIo.ini Őݒ
 *   bZ[W`t@C Sample.sml ̓eɂAMPbZ[W
 *   ɑΉQbZ[WoB
 *   MSSG_USE_FILE=0x80ibZ[W`t@Cgpjꍇ́AbZ[W
 *   `t@Cɒ`Cӂ̃bZ[Ŵ̖w肷邱ƂɂA
 *   bZ[W𑗏oB
 * 
 *   ܂AvR[hɂAԊuiSEND_WAIT ɂĎwjł̘AMs
 *   BAḾA^C ̓͂ɂIB
 *   ̏ꍇAPbZ[W̑MƁAQbZ[W̑Mɔ
 *   \BbZ[W`t@CgpđMbZ[W쐬ꍇA
 *   {Tvł́AbZ[W͗p̃fXNv^͂PpӂĂȂ
 *   ŁAMAԐMł̃bZ[W\zobeBOȂ悤ɃbN
 *   KvBڍׂ SunFunctions.h ̐擪QƂ邱ƁB
 * 
 *   {Tv́Aُ펞ȗĂB
 *   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
 *   ɂĕ\ SECS bZ[W̏o͌`ύXłB
 *   ܂ MSSG_USE_NEXTL ̒lύXƁAbZ[We͂ۂɁA
 *   lf[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
 *   l USE_USER_TRACE ̒lύXƁAUser Trace o͗p Callback ̎gp
 *   ̗LύXłB
 */
/* ========================================================================== */

#include	"TDS.h"


#define		PO		fprintf(stdout
#define		PE		fprintf(stderr

#define		SECS_MODE	0x01		// SECS/HSMS [h
						// 0x00 : SECS-1
						// 0x01 : HSMS
#define		MSSG_USE_FILE	0x80		// bZ[W`t@C
						// 0x00 : gpȂ
						// 0x80 : gpčږ\
#define		MSSG_DISP_TYPE	0x20		// SECS bZ[W\`
						// 0x00 : ʏ`
						// 0x10 : ????`
						// 0x20 : SML `
						// 0x40 : NSG/TS300 `
#define		MSSG_USE_NEXTL	1		// MssgNextL gp邩ۂ
						// 0    : gpȂ
						// 1    : gp
#define		USE_USER_TRACE	0		// UserTracepCB gp邩ۂ
						// 0    : gpȂ
						// 1    : gp

#define		SEND_WAIT	2000		// bZ[WMԊu      (mb)
#define		SEND_NO		10		// bZ[WMx݂܂ł̉
#define		SEND_SLEEP	10000		// xݎ              (mb)
#define		ERROR_SLEEP	10000		// G[xݎ  (mb)

#define		PARAMFILE	"Sample.ini"


static void	Host();
static void	Equip();



/* ========================================================================== */
/* ʊ֐ ================================================================= */

#include	"SubFunctions.h"



/* ========================================================================== */
/* Main  ---------------------------------------------------------------- */

int
main(
int			argc,
char			*argv[])
{
  if(argc<2 || (argv[1][0]!='h' && argv[1][0]!='e')){
    PE,"%s {host|equip}\n"	,argv[0]);			exit(1);
  }

  signal(SIGINT,CBSignal);
//InitializeCriticalSection(&Cs0);
  InitializeCriticalSection(&Cs1);

  if(argv[1][0]=='h')	Host ();
  else			Equip();

//DeleteCriticalSection(&Cs0);
  DeleteCriticalSection(&Cs1);
  exit(0);
}



/* ========================================================================== */
/* zXg ------------------------------------------------------------- */

static void
Host()
{
  int			(*cbtrace)(void*,TDSTRData*)=0;
  char			mname[64];
  int			req,rtn,mno,i;

  if(USE_USER_TRACE!=0)	cbtrace=CBTrace;
  if((Fd=_TDSCommOpen(0x02,PARAMFILE,"HOST"
				,CBRecv,0,CBSend,0,cbtrace,0))	< 0) goto Exit;
  PO,"(H) Opened (%d)\n",Fd);	OType=0;
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);
  if((SECS_MODE&0x01)==0)	Status=2;	// SECS-1 ̏ꍇAڑ

  for(Break=0;;){
    Sleep(500);
    if(Break!=0){	Break=rtn=0;	req=99;
      PE,"Req (0:Exit 2:Send 3:Continuous) : "); scanf("%d",&req);
      if      (req==0){						break;
      }else if(req==2){
	PE,"Message(1:S1F1 2:S2F49   9:Any) : ");
	scanf("%d",&mno);
	switch(mno){
	  case 1: rtn=SendS1F1 ();			break;
	  case 2: rtn=SendS2F49();			break;
	  case 9: if((MSSG_USE_FILE&0x80)!=0){
		    PE,"Message Name : ");	scanf("%s",mname);
		    rtn=SendNamedMssg(0,mname);
		  }					break;
	}
      }else if(req==3){
	for(i=0;Break==0;i++){
	  Sleep(SEND_WAIT);
	  if(Status==2){
	    if((rtn=SendS2F49())	< 0){
	      PE,"(H) Send error (%d)\n",rtn);	Sleep(ERROR_SLEEP);
	    }
	    if((i%SEND_NO)		==0)	Sleep(SEND_SLEEP);
	} }
	rtn=0;
      }
      if(rtn<(-999) || ((-900)<rtn && rtn<0) ){
	PE,"(H) Send error (%d)\n"	,rtn);
  } } }

Exit:
  if(Md>0) _TDSMDMssgTerminate(Md,0);
  if(Fd>0) _TDSCommClose(Fd,0);
  else	   PE,"(H) Error (%d)\n",Fd);
}



/* ========================================================================== */
/* u --------------------------------------------------------------- */

static void
Equip()
{
  int			(*cbtrace)(void*,TDSTRData*)=0;
  char			mname[64];
  int			req,rtn,mno,cnt,i;

  if(USE_USER_TRACE!=0)	cbtrace=CBTrace;
  if((Fd=_TDSCommOpen(0x02,PARAMFILE,"EQUIP"
				,CBRecv,0,CBSend,0,cbtrace,0))	< 0) goto Exit;
  PO,"(E) Opened (%d)\n",Fd);	OType=1;
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);
  if((SECS_MODE&0x01)==0)	Status=2;	// SECS-1 ̏ꍇAڑ
  else{						// HSMS   ̏ꍇAڑ
    if(_TDSCommSend(Fd,0x0100,0,0,0,0,0,0)			< 0) goto Exit;
    for(;Status!=1;) Sleep(100);		// Connected ܂ő҂
    if(_TDSCommSend(Fd,0x0200,0,0,0,0,0,0)			< 0) goto Exit;
    for(;Status!=2;) Sleep(100);		// Selected ܂ő҂
  }

  for(Break=0;;){
    Sleep(500);
    if(Break!=0){	Break=rtn=0;	req=99;
      PE,"Req (0:Exit 2:Send 3:Continuous) : "); scanf("%d",&req);
      if      (req==0){						 break;
      }else if(req==2){
	PE,"Message(1:S1F1 2:S6F11   9:Any) : ");
	scanf("%d",&mno);
	switch(mno){
	  case 1: rtn=SendS1F1 ();			break;
	  case 2: rtn=SendS6F11();			break;
	  case 9: if((MSSG_USE_FILE&0x80)!=0){
		    PE,"Message Name : ");	scanf("%s",mname);
		    rtn=SendNamedMssg(0,mname);
		  }					break;
	}
      }else if(req==3){
	for(i=0;Break==0;i++){
	  Sleep(SEND_WAIT);
	  if(Status==2){
	    if((rtn=SendS6F11())	< 0){
	      PE,"(H) Send error (%d)\n",rtn);	Sleep(ERROR_SLEEP);
	    }
	    if((i%SEND_NO)		==0)	Sleep(SEND_SLEEP);
        } }
	rtn=0;
      }
      if(rtn<(-999) || ((-900)<rtn && rtn<0)){
	PE,"(E) Send error (%d)\n"	,rtn);
  } } }

  if((SECS_MODE&0x01)!=0){			// HSMS ̏ꍇAؒf
  // Deselect request ͍sȂBiSEMI ł HSMS-SS ɂāADeselect request
  // ͍sĂ͂ȂȂAƂĂBj
  //if(_TDSCommSend(Fd,0x0800,0,0,0,0,0,0)			< 0) goto Exit;
  //for(cnt=0;Status!=1 && cnt<50;cnt++) Sleep(100);// Deselected ܂ő҂
    if(_TDSCommSend(Fd,0x0900,0,0,0,0,0,0)			< 0) goto Exit;
    for(cnt=0;Status!=0 && cnt<50;cnt++) Sleep(100);// Not Connected ܂ŁA
  }						    // ͂Tbo߂܂ő҂

Exit:
  if(Md>0) _TDSMDMssgTerminate(Md,0);
  if(Fd>0) _TDSCommClose(Fd,0);
  else	   PE,"(E) Error (%d)\n",Fd);
}
