
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2015.  All rights reserved.
 */


/* ========================================================================== */
/*
 * SimpleIo : eXg y TvEvO
 *
 *  `oŃbZ[W\zAP SECS bZ[W̑MJԂAł
 *  PȎgpB
 *
 *  ȉ̗sB
 *
 *   zXgiSimple hj |          | ݔiSimple ej
 *   --------------------------------------------------------
 *            ڑ ҂ |          |
 *                        |          |
 *       ڑ󂯕t |<---------| Connect
 *    Select 󂯕t |<---------| Select v
 *                        |          |
 *                        |          |
 *         +--> S1F1 M | <------- | S1F1 M <--+
 *         |    S1F2 M | -------> | S1F2 M    | JԂ
 *         |    Qb҂  |          |              | CTRL-C ŏI
 *         |    S1F1 M | -------> | S1F1 M    | MԊu WAIT1 }N
 *         +--- S1F2 M | <------- | S1F2 M    | 萔Ō߂
 *                        |          | Qb҂  ---+
 *                        |          |
 *   Deselect󂯕t |<---------| Deselect v  <ȗ>
 *   Separate󂯕t |<---------| Separate v  <ȗ>
 *                        |          |
 *                   ؒf |          | ؒf                                 
 *                        |          |
 *
 *
 *
 * N@
 *
 *   SimpleIo {h|e}
 *   ~~~~~~~~~~~~~~
 *   h    : Sample.ini  [HOST]  ZNVQƂ肷
 *   e    : Sample.ini  [EQUIP]      :              :
 *
 *
 *   ʏASimple h y Simple e ̗A}VA͈قȂ
 *   }Vœ삳āAݒʐMsB
 *   CTRL-C ͂ƎɃANV_ŏIB
 *
 *   {Tv́Aُ펞ȗĂB
 */
/* ========================================================================== */

#include	"TDS.h"
#include	<time.h>
#include	<string.h>
#include	<signal.h>


#define		PO		fprintf(stdout
#define		PE		fprintf(stderr

#define		PARAMFILE	"Sample.ini"

#define		WAIT0		100		// ĎԊu (ms)
#define		WAIT1		2000		// MԊu (ms)


static int	Fd=0;				// ʐMpʎq
static int	Break=0;			// VOiM

static void	Host();				// zXg֐
static void	Equip();			// ݔ֐



/* ========================================================================== */
/* UNIX  Sleep ------------------------------------------------------------ */

#if !defined (WINDOWS)
static void
Sleep		(
int		msec)
{
  struct timespec	itimer,otimer;

  itimer.tv_sec =(msec/1000);
  itimer.tv_nsec=(msec%1000)*1000*1000;
  nanosleep(&itimer,&otimer);
}
#endif



/* ========================================================================== */
/* Signal handler =========================================================== */

static void
CBSignal(
int		vec)
{
  signal(SIGINT,CBSignal);
  Break=1;
}



/* ========================================================================== */
/* bZ[W\ =========================================================== */

static void
DispData(
int		tp,		// i  : bZ[W
				//	=1 : MbZ[W
				//	 2 : MbZ[W
TDSECSHead	*hd,		// i  : SECS bZ[WEwb_
void		*msg,		// i  : SECS bZ[W{
int		len,		// i  : msg ̒
int		rtn)		// i  : I/O ̖߂l
{
  static char	*ctp[]={"SRES","RECV","SEND"};
  char		sfcode[12],rbit,wbit;

  if(rtn<0){
    switch(-rtn){
      case ENODEV:		PO," : No such device ID\n");	break;
      case E2BIG:		PO," : Data size to large\n");	break;
				// "NODATA" ͕\Ȃ
      case E_NODATA:		/*PO,"No data\n");*/		break;
      case E_ILLBLOCK:		PO,"Illegal block#\n");		break;
      case E_T1TIMEDOUT:	PO,"T1 Timeout occur\n");	break;
      case E_T2TIMEDOUT:	PO,"T2 Timeout occur\n");	break;
      case E_T3TIMEDOUT:	PO,"T3 Timeout occur\n");	break;
      case E_T4TIMEDOUT:	PO,"T4 Timeout occur\n");	break;
      case E_T5TIMEDOUT:	PO,"T5 Timeout occur\n");	break;
      case E_T6TIMEDOUT:	PO,"T6 Timeout occur\n");	break;
      case E_T7TIMEDOUT:	PO,"T7 Timeout occur\n");	break;
      case E_T8TIMEDOUT:	PO,"T8 Timeout occur\n");	break;
      case E_RETRYOVER:		PO,"Retry over\n");		break;
      case E_CONNECT:		PO,"Connected\n");		break;
      case E_SELECT:		PO,"Selected\n");		break;
      case E_REJECT:		PO,"Rejected XId=0x%04x.0x%04x\n"
				,hd->sid,hd->xid);		break;
      case E_DESELECT:		PO,"Deselected\n");		break;
      case E_NOTCONNECT:	PO,"Not connected\n");		break;
      default:			PO,"Error [%d]\n",rtn);		break;
    }

  }else{
    rbit=' ';	if((hd->did&0x8000)!=0)	rbit='R';
    wbit=' ';	if((hd->scd&  0x80)!=0)	wbit='W';
    sprintf(sfcode,"S%dF%d",hd->scd&0x7f,hd->fcd);
    PO,"[%s]  Dev=0x%04x  %-8s  %c%c  XId=0x%04x.0x%04x  Len=%4d\n"
		,ctp[tp],hd->did&0x7fff,sfcode,rbit,wbit,hd->sid,hd->xid,len);
  }
}



/* ========================================================================== */
/* bZ[W\z =========================================================== */

/* ---------------------------------------------------------------------------*/
/* S1F1 bZ[W\zyёM ---------------------------------------------- */

static int
SendS1F1()
{
  TDSECSHead	hd;
  char		msg[16];
  int		rtn,sf=0x8101,len=0;

  		// SubFunction.h  SendS1F1()  () QƂ邱ƁB
  rtn=_TDSCommSend(Fd,0x0000,0,sf,0,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Host) \zyёM -------------------------------------- */

static int
SendS1F2H(
unsigned int	xid)
{
  TDSECSHead	hd;
  char		msg[256];
  int		rtn,md,sf=0x0102,len;
  
  md =_TDSMssgInit   (   0,msg,sizeof(msg),Fd);			// S1F2
      _TDSMssgBuild  (md,0,msg,000,  0,  0);			// L0
  len=_TDSMssgEnd    (md,0,msg);

  if(len<0)	rtn=len;
  else		rtn=_TDSCommSend (Fd,0x0000,0,sf,xid,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Equip) \zyёM ------------------------------------- */

static int
SendS1F2E(
unsigned int	xid)
{
  TDSECSHead	hd;
  char		msg[256];
  int		rtn,md,sf=0x0102,len;
  
  md= _TDSMssgInit   (   0,msg,sizeof(msg),Fd);			// S1F2
      _TDSMssgBuild  (md,0,msg,000,  2,  0);			// L2
      _TDSMssgBuild  (md,0,msg,020,  6,"EQUIP1");		//  MDLN
      _TDSMssgBuild  (md,0,msg,020,  6,"01.000");		//  SOFTREV
  len=_TDSMssgEnd    (md,0,msg);

  if(len<0)	rtn=len;
  else		rtn=_TDSCommSend (Fd,0x0000,0,sf,xid,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}




/* ========================================================================== */
/* Main  ---------------------------------------------------------------- */

int
main(
int			argc,
char			*argv[])
{
  if(argc<2 || (argv[1][0]!='h' && argv[1][0]!='e')){
    PE,"%s {host|equip}\n"	,argv[0]);			exit(1);
  }

  signal(SIGINT,CBSignal);
  if(argv[1][0]=='h')	Host ();
  else			Equip();

  exit(0);
}



/* ========================================================================== */
/* zXg ------------------------------------------------------------- */

static void
Host()
{
  TDSECSHead		hd;
  char			msg[1024];
  unsigned int		xid;
  int			rtn,msz;

  msz=sizeof(msg);
  if((Fd=_TDSCommOpen(0x02,PARAMFILE,"HOST",0,0,0,0,0,0))	< 0) goto Exit;
  PO,"(H) Opened (%d)\n",Fd);

  for(Break=0;Break==0;){
    rtn=_TDSCommRecv(Fd,0,0,0,&xid,msg,msz,&hd);
    DispData(1,&hd,msg,rtn,rtn);
    if(rtn	< 0){
      Sleep(WAIT0);	// NODATA ܂߃f[^MłȂȂ`bg҂
    }else{
      if(hd.scd==0x81 && hd.fcd==0x01){		// S1F1 MEE
	SendS1F2H(xid);
	Sleep(WAIT1);
	SendS1F1();
  } } }

Exit:
  if(Fd>0) _TDSCommClose(Fd,0);
  else	   PE,"(H) Error (%d)\n",Fd);
}



/* ========================================================================== */
/* u --------------------------------------------------------------- */

static void
Equip()
{
  TDSECSHead		hd;
  char			msg[1024];
  unsigned int		xid;
  int			rtn,msz;

  msz=sizeof(msg);
  if((Fd=_TDSCommOpen(0x02,PARAMFILE,"EQUIP",0,0,0,0,0,0))	< 0) goto Exit;
  PO,"(E) Opened (%d)\n",Fd);
  if(_TDSCommSend(Fd,0x0100,0,0,0,0,0,0)			< 0) goto Exit;
  PO,"(E) Connected\n");
  if(_TDSCommSend(Fd,0x0200,0,0,0,0,0,0)			< 0) goto Exit;
  PO,"(E) Selected\n");

  Sleep(WAIT1);
  SendS1F1();
  for(Break=0;Break==0;){
    rtn=_TDSCommRecv(Fd,0,0,0,&xid,msg,msz,&hd);
    DispData(1,&hd,msg,rtn,rtn);
    if(rtn	< 0){
      Sleep(WAIT0);	// NODATA ܂߃f[^MłȂȂ`bg҂
    }else{
      if(hd.scd==0x81 && hd.fcd==0x01){		// S1F1 MEE
	SendS1F2E(xid);
	Sleep(WAIT1);
	SendS1F1();
  } } }

// ȗBisĂ悢BA SEMI ł Deselect v͍sĂ͂
// ȂAƂĂBj
//if(_TDSCommSend(Fd,0x0800,0,0,0,0,0,0)			< 0) goto Exit;
//PO,"(E) Deselected\n");
//if(_TDSCommSend(Fd,0x0900,0,0,0,0,0,0)			< 0) goto Exit;
//PO,"(E) Separate\n");

Exit:
  if(Fd>0) _TDSCommClose(Fd,0);
  else	   PE,"(E) Error (%d)\n",Fd);
}
