
/*
 * Trust Design LLC : Basic libraries.
 *
 * (c) Copyright Trust Design LLC.  2010-2015.  All rights reserved.
 */

#if !defined	__TDL__
#define		__TDL__


/* -------------------------------------------------------------------------- */
/* Debug output ------------------------------------------------------------- */

#define		TDLPO		fprintf(stdout
#define		TDLPE		fprintf(stderr


/* -------------------------------------------------------------------------- */
/* Header contents ---------------------------------------------------------- */

#if  defined	__WIN32		|| defined _WIN32	|| \
     defined	__WIN64		|| defined _WIN64
#define		TDL_WINDOWS
#define		_WINSOCKAPI_
#include	<windows.h>
#include	<winbase.h>
#endif

#if  defined	__hpux__	|| defined __hpux	|| \
     defined	__sparc__	|| defined __sparc	|| \
     defined	__linux__	|| defined __linux	|| \
     defined	__FreeBSD__	|| defined __FreeBSD	|| \
     defined	__APPLE__	|| defined __APPLE	|| \
     defined	__CYGWIN__	|| defined __CYGWIN
#define		TDL_UNIX
#endif

#include	<stdio.h>
#include	<stdlib.h>
#include	<errno.h>


/* -------------------------------------------------------------------------- */
/* TDL error code definition ------------------------------------------------ */

#if !defined	ENODEV
#define		ENODEV		19
#endif
#if !defined	EILSEQ
#define		EILSEQ		47
#endif
#if !defined	ENODATA
#define		ENODATA		51
#endif
#if !defined	ECOMM
#define		ECOMM		60
#endif
#if !defined	EPROTO
#define		EPROTO		61
#endif
#if !defined	EADDRINUSE
#define		EADDRINUSE	226
#endif
#if !defined	ENETDOWN
#define		ENETDOWN	228
#endif
#if !defined	ECONNRESET
#define		ECONNRESET	232
#endif
#if !defined	ETIMEDOUT
#define		ETIMEDOUT	238
#endif
#if !defined	ECONNREFUSED
#define		ECONNREFUSED	239
#endif
#if !defined	ENOSYS
#define		ENOSYS		251
#endif


/* -------------------------------------------------------------------------- */
/* TDL variable type -------------------------------------------------------- */

#define		TDLI08		char
#define		TDLI16		short
#define		TDLI32		int
#define		TDLU08		unsigned char
#define		TDLU16		unsigned short
#define		TDLU32		unsigned int
#define		TDLF32		float
#define		TDLF64		double

#if defined	TDL_WINDOWS  &&  _MSC_VER<1400
#define		TDLI64		long
#define		TDLU64		unsigned long
#define		TDLF96		double
#define		TDLF128		double
#else
#define		TDLI64		long long
#define		TDLU64		unsigned long long
#define		TDLF96		long double
#define		TDLF128		long double
#endif

#if defined	TDL_WINDOWS
#define		TDLThreadFunc	void
#else
#define		TDLThreadFunc	void*
#endif


/* -------------------------------------------------------------------------- */
/* Function prototype ------------------------------------------------------- */

#if defined	__cplusplus
extern "C" {
#endif


#if  defined	TDL_WINDOWS
#define		TDLCALL			__stdcall
#define		TDLDLLX			__declspec(dllexport)
#define		TDLDLLW		extern	__declspec(dllexport)
#endif

#if !defined	TDLCALL
#define		TDLCALL
#endif
#if !defined	TDLDLLX
#define		TDLDLLX
#endif
#if !defined	TDLDLLW
#define		TDLDLLW
#endif

#define TDLVoidX	TDLDLLX void		TDLCALL
#define TDLVoidPX	TDLDLLX void*		TDLCALL
#define TDLCharPX	TDLDLLX char*		TDLCALL
#define TDLShortX	TDLDLLX short		TDLCALL
#define TDLUShortX	TDLDLLX unsigned short	TDLCALL
#define TDLIntX		TDLDLLX int		TDLCALL
#define TDLUIntX	TDLDLLX unsigned int	TDLCALL
#define TDLLongX	TDLDLLX long		TDLCALL
#define TDLULongX	TDLDLLX unsigned long	TDLCALL
#define TDLLLongX	TDLDLLX TDLI64		TDLCALL
#define TDLULLongX	TDLDLLX TDLU64		TDLCALL
#define TDLInt08X	TDLDLLX TDLI08		TDLCALL
#define TDLInt16X	TDLDLLX TDLI16		TDLCALL
#define TDLInt32X	TDLDLLX TDLI32		TDLCALL
#define TDLInt64X	TDLDLLX TDLI64		TDLCALL
#define TDLFloatX	TDLDLLX float		TDLCALL
#define TDLDoubleX	TDLDLLX double		TDLCALL
#define TDLFilePX	TDLDLLX FILE*		TDLCALL

#define TDLVoid		TDLDLLW void		TDLCALL
#define TDLVoidP	TDLDLLW void*		TDLCALL
#define TDLCharP	TDLDLLW char*		TDLCALL
#define TDLShort	TDLDLLW short		TDLCALL
#define TDLUShort	TDLDLLW unsigned short	TDLCALL
#define TDLInt		TDLDLLW int		TDLCALL
#define TDLUInt		TDLDLLW unsigned int	TDLCALL
#define TDLLong		TDLDLLW long		TDLCALL
#define TDLULong	TDLDLLW unsigned long	TDLCALL
#define TDLLLong	TDLDLLW TDLI64		TDLCALL
#define TDLULLong	TDLDLLW TDLU64		TDLCALL
#define TDLInt08	TDLDLLW TDLI08		TDLCALL
#define TDLInt16	TDLDLLW TDLI16		TDLCALL
#define TDLInt32	TDLDLLW TDLI32		TDLCALL
#define TDLInt64	TDLDLLW TDLI64		TDLCALL
#define TDLFloat	TDLDLLW float		TDLCALL
#define TDLDouble	TDLDLLW double		TDLCALL
#define TDLFileP	TDLDLLW FILE*		TDLCALL

#if defined	__cplusplus
}
#endif
#endif
