
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2016.  All rights reserved.
 */

#include	"TDS.h"
#include	<string.h>
#include	<signal.h>


#if !defined	PO
#define		PO		fprintf(stdout
#endif
#if !defined	PE
#define		PE		fprintf(stderr
#endif

#if defined	WINDOWS
#include	<process.h>
#else
#include	<pthread.h>
#define		CRITICAL_SECTION	pthread_mutex_t
#endif

				// ȉ̃}N萔ɊւẮABasicIo.cA
				// CallbackIo.c ̐擪̃RgQƂ鎖B

#if !defined	MSSG_USE_FILE
#define		MSSG_USE_FILE	0x00	// bZ[W`t@Cgp̗L
					// 0x00 : gpȂ
					// 0x80 : gpčږ\
#endif

#if !defined	MSSG_DISP_TYPE
#define		MSSG_DISP_TYPE	0x00	// SECS bZ[W\`̃ftHg
					// 0x00 : ʏ`
					// 0x10 : ????`
					// 0x20 : SML `
					// 0x40 : NSG/TS300 `
#endif

#if !defined	MSSG_USE_NEXTL
#define		MSSG_USE_NEXTL	0	// MssgNextL gp邩ۂ
					// 0    : gpȂ
					// 1    : gp
#endif


static int	Fd=0;		// ʐMpʎq
static int	Md=0;		// bZ[W͗pʎq
static int	OType=0;	// ^Cv (0:Host 1:Equip)
static int	Break=0;	// VOiM

static CRITICAL_SECTION	Cs0;	// bZ[W\zbNp	
				// AMbZ[W`t@C gp
				// čsꍇAL Md Ŏʂ郁bZ[W\
				// zɂāAPbZ[W̍\zƁA
				// Receive ɑ΂QbZ[W̍\zƂob
				// eBO\̂ŁA邽
				// ߂ɃbN䂷B
				// AMpƎMpƂŕʂ Md pӂ
				// ꍇɂ́AbN̕Kv͂ȂB
				// ܂AV12.030 ȍ~AbZ[W`̏
				//  Calli_TDSMDMssgInitialize()jɂāA
				// (mode&0x4000)!=0 w肷ƃbNC
				// uōŝŁA`obNs
				// Kv͂ȂB{Tvł́ÃbN
				// Cuōs悤ݒ肵ŁA]
				// bN̕RgĎcB

static CRITICAL_SECTION	Cs1;	// bZ[W\bNp	
				// ȉ DispData() őMbZ[W\\
				// ꍇACallbackIo.exe ł́AMƎM
				// قȂXbhŎs邽߁AɃbZ[
				// W\sꍇA\\
				// B邽߁AbNsB


/* ========================================================================== */
/* ʊ֐ ================================================================= */

#if !defined	WINDOWS
static void		
InitializeCriticalSection(
CRITICAL_SECTION	*cs)
{
  pthread_mutex_init(cs,0);
}

static void
DeleteCriticalSection(
CRITICAL_SECTION	*cs)
{
  pthread_mutex_destroy(cs);
}

static void
EnterCriticalSection(
CRITICAL_SECTION	*cs)
{
  pthread_mutex_lock(cs);
}

static void
LeaveCriticalSection(
CRITICAL_SECTION	*cs)
{
  pthread_mutex_unlock(cs);
}


static void*
_beginthread(
void*			(*func)(void*),
int			stacksz,
void			*par)
{
  pthread_t		th;
  pthread_attr_t	ta;

  if(pthread_attr_init(&ta)				==0){
    pthread_attr_setdetachstate(&ta,PTHREAD_CREATE_DETACHED);
    if(stacksz>0) pthread_attr_setstacksize(&ta,stacksz);
    pthread_attr_destroy(&ta);
  }
  return((void*)pthread_create(&th,&ta,func,par));
}


static void
Sleep(
int			msec)
{
  struct timespec	itimer,otimer;

  itimer.tv_sec =(msec/1000);
  itimer.tv_nsec=(msec%1000)*1000*1000;
  nanosleep(&itimer,&otimer);
}
#endif



/* -------------------------------------------------------------------------- */


static void
DispSECSMssg(			//
int		tp,		// i  : bZ[W
				//	=0 : M
				//	 1 : MbZ[W
				//	 2 : MbZ[W
TDSECSHead	*hd,		// i  : SECS bZ[WEwb_
void		*msg,		// i  : SECS bZ[Wi[̈iwb_܂܂j
int		len)		// i  : SECS bZ[W̃oCg
{
  static char	*ctp[]={"SRES","RECV","SEND"};
  TDSAllType	*itm;
  char		item[64],str[512],sfcode[12],rbit,wbit;
  int		rtn,md=0,dp=MSSG_USE_FILE|MSSG_DISP_TYPE,fm,form,sz,noi,la,i;
	// [] CallbackIo ɂẮAMXbhƁAM Callback 삷
	// Xbh̗瓯 DispData()  Call B
	//  DispData() ɂāAbNi{ Sample ł́AEnterCritical
	// Section()ALeaveCriticalSection() ɂčsĂj{ȂꍇA
	// _TDSMssgFind()  (mode&0x8000)!=0A_TDSMssgNextL()  (mode&0x0080)
	// !=0 ƂāAbZ[ẂAbZ[Wږ̂AbZ[W`t@
	// CQƂĕ\悤Ɏw肵ꍇAM̊eXbh瓯
	//  DispData()  Call 邱ƂɂA_TDSMssgFind()A_TDSMssgNextL()
	// ɂċA\ʌʂƂȂ\B̏ꍇ mode
	// ̐ݒύXAbZ[W`t@CQƂȂݒƂ邱ƁB
	//  _TDSMssgNextL()  mode ݒlł dp Ɋւ TDS.pdf 
	// 3.3 (2)(c) ̒LQƂ邱ƁB

  itm =(TDSAllType*)item;
  rbit=' ';	if((hd->did&0x8000)!=0)	rbit='R';
  wbit=' ';	if((hd->scd&  0x80)!=0)	wbit='W';
  sprintf(sfcode,"S%dF%d",hd->scd&0x7f,hd->fcd);
  PO,"[%s]  Dev=0x%04x  %-8s  %c%c  XId=0x%04x.0x%04x  Len=%4d\n"
		,ctp[tp],hd->did&0x7fff,sfcode,rbit,wbit,hd->sid,hd->xid,len);

  if((MSSG_USE_FILE&0x80)!=0)	fm =0x8000;		// bZ[W`gp
  else				fm =0x0000;		// gp
  	// fm ̐ݒl (_TDSMssgFind() ɂ mode l̐ݒl) ɊւāAq
	//  [] QƂ邱ƁB

  if(msg!=0){
    if(tp==1){	dp|=0x3000;	fm|=0x3000;}		// M̏ꍇ
    else{	dp|=0x2000;	fm|=0x2000;}		// M̏ꍇ

    if((md=_TDSMssgFind(fm,msg,len,Fd,hd,str))	> 0){
      if(str[0]!='\0')	PO,"[%s]\n",str);		// bZ[W

      for(la=0;;){
	if(MSSG_USE_NEXTL==0){				// ڒl擾
	  rtn=_TDSMssgNext (md,0,msg,&form,&sz,&noi,item,sizeof(item));
	  if(rtn					< 0)	break;
	  printf("%03o:%d*%2d:"		,form,sz,noi);
	  switch(form){					// ڒl̕\
							// l̂QԖڈȍ~͏ȗ
	    case 000: PO,"L[%d]\n"	,noi);			break;
	    case 010: PO,"B[%d]=%d\n"	,noi,itm->uc[0]);	break;
	    case 011: PO,"T[%d]=%d\n"	,noi,itm->uc[0]);	break;
	    case 020: PO,"A[%d]=%s\n"	,noi,itm->sc);		break;
	    case 021: PO,"J[%d]=%s\n"	,noi,itm->sc);		break;
	    case 022: PO,"K[%d]=%s\n"	,noi,itm->sc);		break;
	    case 030: PO,"I8[%d]=%lld\n",noi,itm->sl[0]);	break;
	    case 031: PO,"I1[%d]=%d\n"	,noi,itm->sc[0]);	break;
	    case 032: PO,"I2[%d]=%d\n"	,noi,itm->ss[0]);	break;
	    case 034: PO,"I4[%d]=%d\n"	,noi,itm->si[0]);	break;
	    case 040: PO,"F8[%d]=%le\n"	,noi,itm->fl[0]);	break;
	    case 044: PO,"F4[%d]=%e\n"	,noi,itm->fs[0]);	break;
	    case 050: PO,"U8[%d]=%llu\n",noi,itm->ul[0]);	break;
	    case 051: PO,"U1[%d]=%u\n"	,noi,itm->uc[0]);	break;
	    case 052: PO,"U2[%d]=%u\n"	,noi,itm->us[0]);	break;
	    case 054: PO,"U4[%d]=%u\n"	,noi,itm->ui[0]);	break;
	    default:  PO,"\n");					break;

	  }

	}else{						// Xg\`Ŏ擾
	  rtn=_TDSMssgNextL(md,dp,msg,&form,&noi,str,sizeof(str));
	  if(rtn					< 0)	break;
	  if((dp&0x70)>0x10){				// SMLANSG/TS300 ̏ꍇ
	    for(i=la;i>rtn;i--) PO,"%*s>\n",i*2,"");	// '>' o
	  }
	  la=rtn;					// ݂̊Kwۑ
	  PO,"  %s\n",str);				// 擾ڒl\
	  if((dp&0x70)>0x10 && form==000 && noi==0) PO,"%*s>\n",(la+1)*2,"");
							// L0 ̏ꍇ '>' 
      } }
      if(MSSG_USE_NEXTL!=0){
        if((dp&0x70)>0x10){
	   for(i=la;i>0;i--) PO,"%*s>\n",i*2,"");	// c '>' \
      } }
      _TDSMssgExit(md,0,msg);
  } }
}



/* -------------------------------------------------------------------------- */
/* Mf[^\B-------------------------------------------------- */

static int
DispData(
int		tp,		// i  : bZ[W
				//	=0 : M
				//	 1 : MbZ[W
				//	 2 : MbZ[W
TDSECSHead	*hd,		// i  : SECS bZ[WEwb_
void		*msg,		// i  : SECS bZ[W{
int		len,		// i  : msg ̒
int		rtn)		// i  : I/O ̖߂l
{
  int		err,pos,ok=0;

  EnterCriticalSection(&Cs1);	// ̃bN͏dvI ڍׂ DispSECSMssg() Q
  if(rtn<0){					ok=1;
    if((rtn<(-E_NOTCONNECT) || (-E_ILLBLOCK)<rtn) && rtn!=(-E_NODATA)){
      _TDSErrorStatus(Fd,&err,&pos);
      PO,"ERROR  [%d.%d.%d]",rtn,err,pos);
      if      (rtn==(-ENODEV)){
	PO," : No such device ID\n");	len=ok=0;
      }else if(rtn==(-E2BIG )){
	PO," : Data size to large\n");	len=ok=0;
      }else			PO,"\n");
    }else{
      PO,"STATUS = %d : ",-rtn);
      switch(-rtn){
	case E_NODATA:		PO,"No data\n");		break;
	case E_ILLBLOCK:	PO,"Illegal block#\n");		break;
	case E_T1TIMEDOUT:	PO,"T1 Timeout occur\n");	break;
	case E_T2TIMEDOUT:	PO,"T2 Timeout occur\n");	break;
	case E_T3TIMEDOUT:	PO,"T3 Timeout occur\n");	break;
	case E_T4TIMEDOUT:	PO,"T4 Timeout occur\n");	break;
	case E_T5TIMEDOUT:	PO,"T5 Timeout occur\n");	break;
	case E_T6TIMEDOUT:	PO,"T6 Timeout occur\n");	break;
	case E_T7TIMEDOUT:	PO,"T7 Timeout occur\n");	break;
	case E_T8TIMEDOUT:	PO,"T8 Timeout occur\n");	break;
	case E_RETRYOVER:	PO,"Retry over\n");		break;
	case E_CONNECT:		PO,"Connected\n");		break;
	case E_SELECT:		PO,"Selected   (0x%04x)\n"
					,hd->did);		break;
	case E_REJECT:		PO,"Rejected XId=0x%04x.0x%04x\n"
					,hd->sid,hd->xid);	break;
	case E_DESELECT:	PO,"Deselected (0x%04x)\n"
					,hd->did);		break;
	case E_NOTCONNECT:	PO,"Not connected\n");		break;
	default:		PO,"\n");			break;
  } } }

  if(ok==0) DispSECSMssg(tp,hd,msg,len);
  LeaveCriticalSection(&Cs1);

  return(0);
}



/* ========================================================================== */
/* S1F1 bZ[W\zyёM ---------------------------------------------- */

static int
SendS1F1()
{
  TDSECSHead	hd;
  char		msg[16];
  int		rtn,sf=0x8101,len=0;

  		// () PbZ[W̃g[Xo͂ _TDSCommSend() ̌Ɏs
		// ꍇAMPbZ[Wɑ΂鑊肩̂QbZ[W
		// ̎擾iႦ Callback gpājʃXbhōsƁA
		// ̂QbZ[W̃g[Xo͂̕Ał̂PbZ[W
		// ̃g[Xo͂ɏo͂P[X\
		// B̌ۂ邽߂ɂ́APbZ[W̃g[Xo
		// A_TDSCommSend() ̑Oɍs΂̂ȀꍇAM
		// TransactionID ̎_ł͂킩Ȃ (TransactionID ́A
		// _TDSCommSend()  Call ɂAhd ɖ߂ė) ̂ŁAP
		// bZ|W TransactionID ̕\͂łȂƂɂȂB
		// ȏlāA[Uł̃g[Xo͈ʒuAe肷
		// KvB
  if(FUNC_TYPE==0)	rtn=_TDSCommSend(Fd,0x0000,0,sf,  0,msg,len,&hd);
  else			rtn=_TDSUDrvSend(Fd,0x0000,0,sf,  0,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Host) \zyёM -------------------------------------- */

static int
SendS1F2H(
unsigned int	did,
unsigned int	xid)
{
  TDSECSHead	hd;
  char		msg[256];
  int		rtn,md,sf=0x0102,len;
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md =_TDSMssgInit   (   0,msg,sizeof(msg),Fd);		// S1F2
	_TDSMssgBuild  (md,0,msg,000,  0,  0);			// L0
    len=_TDSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
    //EnterCriticalSection(&Cs0);
	_TDSMDMssgInit (Md,0,msg,sizeof(msg),"S1F2_H");
    len=_TDSMDMssgEnd  (Md,0,msg);
    //LeaveCriticalSection(&Cs0);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDSCommSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
    else		rtn=_TDSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
  }
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Equip) \zyёM ------------------------------------- */

static int
SendS1F2E(
int		did,
unsigned int	xid)
{
  TDSECSHead	hd;
  char		msg[256];
  int		rtn,md,sf=0x0102,len;
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md= _TDSMssgInit   (   0,msg,sizeof(msg),Fd);		// S1F2
	_TDSMssgBuild  (md,0,msg,000,  2,  0);			// L2
	_TDSMssgBuild  (md,0,msg,020,  6,"EQUIP1");		//  MDLN
	_TDSMssgBuild  (md,0,msg,020,  6,"01.000");		//  SOFTREV
    len=_TDSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
    //EnterCriticalSection(&Cs0);
	_TDSMDMssgInit (Md,0,msg,sizeof(msg),"S1F2_E");
    len=_TDSMDMssgEnd  (Md,0,msg);
    //LeaveCriticalSection(&Cs0);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDSCommSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
    else		rtn=_TDSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
  }
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


/* ========================================================================== */
/* S2F49 bZ[W\zyёM --------------------------------------------- */

static int
SendS2F49()
{
  static int	cnt=0;
  TDSECSHead	hd;
  char		msg[1024];
  char		vb[4],str[128],itm[32];
  int		rtn,md,sf=0x8200+49,no1,no2,len,i,j;

  sprintf(str,"LOTID (%4d)",++cnt);	no1=(cnt%2)+1;	no2=(cnt%10)+1;
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDSMssgInit   (   0,msg,sizeof(msg),Fd);	// S2F49
  		_TDSMssgBuild  (md,0,msg,000,  3, 0);		// L3
    vb[0]=0;	_TDSMssgBuild  (md,0,msg,010,  1,vb);		//  DATAIDB
  		_TDSMssgBuild  (md,0,msg,020,  0,"LOAD");	//  RCMD
  		_TDSMssgBuild  (md,0,msg,000,  4, 0);		//  L4
    vb[0]=1;	_TDSMssgBuild  (md,0,msg,010,  1,vb);		//   STID
    vb[0]=0;	_TDSMssgBuild  (md,0,msg,010,  1,vb);		//   MTKD
  		_TDSMssgBuild  (md,0,msg,020, 20,str);		//   LOTID
    		_TDSMssgBuild  (md,0,msg,000,no1, 0);		//   L[no1]
    for(i=0;i<no1;i++){
    		_TDSMssgBuild  (md,0,msg,000,no2, 0);		//    L[no2]
      for(j=0;j<no2;j++){
    		_TDSMssgBuild  (md,0,msg,000,  2, 0);		//     L[2]
	sprintf(str,"WAFER(%04d-%d-%02d)",cnt,i+1,j+1);
  		_TDSMssgBuild  (md,0,msg,020, 20,str);		//      WAFERID
	sprintf(str,"PPID (%04d-%d-%02d)",cnt,i+1,j+1);
  		_TDSMssgBuild  (md,0,msg,020, 16,str);		//      PPID
    } }
    len=	_TDSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
    //EnterCriticalSection(&Cs0);
		_TDSMDMssgInit (Md,0,msg,sizeof(msg),"S2F49");
  		_TDSMDMssgBuild(Md,0,msg,"LOTID",0,str);	//   LOTID
  		_TDSMDMssgBuild(Md,0,msg,"NOI1"	,1,&no1);	//   L[no1]
    for(i=0;i<no1;i++){
      sprintf(itm,"NOI2:%d"			,i+1);
  		_TDSMDMssgBuild(Md,0,msg,itm	,1,&no2);	//    L[no2]
      for(j=0;j<no2;j++){
	sprintf(itm,"WAFERID:%d:%d"		,i+1,j+1);
	sprintf(str,"WAFER[%04d-%d-%02d]",cnt	,i+1,j+1);
  		_TDSMDMssgBuild(Md,0,msg,itm	,0,str);	//      WAFERID
	sprintf(itm,"PPID:%d:%d"		,i+1,j+1);
	sprintf(str,"PPID [%04d-%d-%02d]",cnt	,i+1,j+1);
  		_TDSMDMssgBuild(Md,0,msg,itm	,0,str);	//      PPID
    } }
    len=	_TDSMDMssgEnd  (Md,0,msg);
    //LeaveCriticalSection(&Cs0);
  }

  if(len<0)		rtn=len;	// SendS1F1()  () QƂ邱ƁB
  else{
    if(FUNC_TYPE==0)	rtn=_TDSCommSend (Fd,0x0000,0,sf,  0,msg,len,&hd);
    else		rtn=_TDSUDrvSend (Fd,0x0000,0,sf,  0,msg,len,&hd);
  }
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S2F50 bZ[W\zyёM --------------------------------------------- */

static int
SendS2F50(
int		did,
unsigned int	xid)
{
  static int	cnt=0;
  TDSECSHead	hd;
  char		msg[256];
  char		vb[4],str[128];
  int		rtn,md,sf=0x0200+50,len;
  
  sprintf(str,"LOTID (%4d)",++cnt);
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDSMssgInit   (   0,msg,sizeof(msg),Fd);	// S2F50
		_TDSMssgBuild  (md,0,msg,000,  2, 0);		// L2
    vb[0]=0;	_TDSMssgBuild  (md,0,msg,010,  1,vb);		//  HCACK
		_TDSMssgBuild  (md,0,msg,000,  2, 0);		//  L2
  		_TDSMssgBuild  (md,0,msg,020, 16,"PPID");	//   PPID
  		_TDSMssgBuild  (md,0,msg,020, 20,str);		//   LOTID
    len=	_TDSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
    //EnterCriticalSection(&Cs0);
		_TDSMDMssgInit (Md,0,msg,sizeof(msg),"S2F50");
  		_TDSMDMssgBuild(Md,0,msg,"LOTID",  0,str);	//   LOTID
    len=	_TDSMDMssgEnd  (Md,0,msg);
    //LeaveCriticalSection(&Cs0);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDSCommSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
    else		rtn=_TDSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
  }
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


/* ========================================================================== */
/* S6F11 bZ[W\zyёM --------------------------------------------- */

static int
SendS6F11()
{
  static int	cnt=0;
  TDSECSHead	hd;
  char		msg[256];
  unsigned short vs[4];
  int		rtn,md,sf=0x8600+11,len;

  if((++cnt)==65536) cnt=0;

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDSMssgInit   (   0,msg,sizeof(msg),Fd);	// S6F11
  		_TDSMssgBuild  (md,0,msg,000,  3, 0);		// L3
    vs[0]=cnt;	_TDSMssgBuild  (md,0,msg,052,  1,vs);		//  DATAID
    vs[0]=8;	_TDSMssgBuild  (md,0,msg,052,  1,vs);		//  CEID
  		_TDSMssgBuild  (md,0,msg,000,  3, 0);		//  L3
  		_TDSMssgBuild  (md,0,msg,020, 16,"DATA1 ł");	//   DATA1
  		_TDSMssgBuild  (md,0,msg,020, 16,"DATA2 ł");	//   DATA2
  		_TDSMssgBuild  (md,0,msg,020, 14,"YYYYMMDDhhmmss");
						// @TIME ({͌ݎݒ
						// ̂AȗB
    len=	_TDSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
    //EnterCriticalSection(&Cs0);
		_TDSMDMssgInit (Md,0,msg,sizeof(msg),"S6F11");
    vs[0]=cnt;	_TDSMDMssgBuild(Md,0,msg,"DATAID",1,vs);	//  DATAID
    len=	_TDSMDMssgEnd  (Md,0,msg);
    //LeaveCriticalSection(&Cs0);
  }

  if(len<0)		rtn=len;	// SendS1F1()  () QƂ邱ƁB
  else{
    if(FUNC_TYPE==0)	rtn=_TDSCommSend (Fd,0x0000,0,sf,  0,msg,len,&hd);
    else		rtn=_TDSUDrvSend (Fd,0x0000,0,sf,  0,msg,len,&hd);
  }
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}



/* ---------------------------------------------------------------------------*/
/* S6F12 bZ[W\zyёM --------------------------------------------- */

static int
SendS6F12(
int		did,
unsigned int	xid)
{
  TDSECSHead	hd;
  char		msg[256];
  char		vb[4];
  int		rtn,md,sf=0x0600+12,len;

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDSMssgInit (   0,msg,sizeof(msg),Fd);		// S6F12
    vb[0]=0;	_TDSMssgBuild(md,0,msg,010,  1,vb);		// ACKC
    len=	_TDSMssgEnd  (md,0,msg);

  }else{					// bZ[W`gp
    //EnterCriticalSection(&Cs0);
		_TDSMDMssgInit (Md,0,msg,sizeof(msg),"S6F12");
    len=	_TDSMDMssgEnd  (Md,0,msg);
    //LeaveCriticalSection(&Cs0);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDSCommSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
    else		rtn=_TDSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
  }
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}



/* ---------------------------------------------------------------------------*/
/* w薼̂̃bZ[WbZ[W`t@Cgpč\zM ----- */

static int
SendNamedMssg(
int		did,
unsigned int	xid,
char		*mname)
{
  TDSECSHead	hd;
  char		msg[4096];			// ő 4096Bytes ܂łƂ
  int		rtn=(-1),sf,scode,fcode,len;

						// bZ[W`gpȂ
  if((MSSG_USE_FILE&0x80)				==0)	goto Exit;

		// bZ[W`t@C̕ύX̎_Ŕf邽߁A
		// ēxsB
		// ƂAbZ[W`t@C̕ύXȂ̂ł΁A
		// ͕KvȂB
		// ܂Aōď̂́Ǎ _TDSMssgInit() ̏
		// Ɋւ̂łAg[X\͊ς݂̏ɂ
		// ŝŁAKŐVbZ[W񂪎gpł͂
		// Ƃɗӂ邱ƁB
  if(Md>0)	_TDSMDMssgTerminate (Md,0);
  Md=		_TDSMDMssgInitialize(0x4000,Fd,0);

  sscanf(mname,"S%dF%d"	,&scode,&fcode);
  sf = scode*0x0100 + fcode;
  if(scode!=9 && (fcode%2)!=0)	sf|=0x8000;

  //EnterCriticalSection(&Cs0);
  if(	_TDSMDMssgInit(Md,0,msg,sizeof(msg),mname)	< 0)	goto Exit;
  len=	_TDSMDMssgEnd (Md,0,msg);
  //LeaveCriticalSection(&Cs0);

  if(len<0)		rtn=len;	// SendS1F1()  () QƂ邱ƁB
  else{
    if(FUNC_TYPE==0)	rtn=_TDSCommSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
    else		rtn=_TDSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,&hd);
  }
  DispData(2,&hd,msg,len,rtn);

Exit:
  return(rtn);
}



/* ========================================================================== */
/* Callback ֐ ============================================================ */

/* -------------------------------------------------------------------------- */
/* 肩 SECS bZ[WMp Callback -------------------------------- */

static int
CBRecv(
void		*par,
TDSCBData	*cbd)
{
  TDSECSHead	hd;
  char		msg[1024],rname[32],sname[32];
  int		rtn,len,sf;

  DispData(1,&cbd->thd,cbd->msg,cbd->rtn,cbd->rtn);

  if      (cbd->req== 0 && cbd->rtn>=0){
    if((MSSG_USE_FILE&0x80)==0){	// bZ[W`t@CgpȂ
					// ꍇ́A͂ SF-Code 𒲂ׁAQ
					// bZ[W̑o̕Kv𔻒fA
					// Kvȏꍇ́AoB
      if     (cbd->sf==(0x8100+ 1)&&OType==0)	SendS1F2H (cbd->devid,cbd->xid);
      else if(cbd->sf==(0x8100+ 1)&&OType==1)	SendS1F2E (cbd->devid,cbd->xid);
      else if(cbd->sf==(0x8200+49))		SendS2F50 (cbd->devid,cbd->xid);
      else if(cbd->sf==(0x8600+11))		SendS6F12 (cbd->devid,cbd->xid);

    }else if((cbd->sf&0x8000)!=0){	// bZ[W`t@Cgp
					// ꍇ́AԐM@\gpB
					//igpȂĂ͂Ȃł͂ȂBj
      memcpy(msg,cbd->msg,cbd->rtn);
      //EnterCriticalSection(&Cs0);
      len=_TDSMDMssgAutoRes(Md,0,&cbd->thd
		,msg,cbd->rtn,sizeof(msg),rname,sname,&sf);
      //LeaveCriticalSection(&Cs0);
      if(len							>=0){
	PO,"RECV %s ..  Auto respond %s [S%dF%d]\n"
		,rname,sname,sf/0x100,sf&0xff);
	if(FUNC_TYPE==0){
	  rtn=_TDSCommSend (Fd,0x0000,cbd->devid,sf,cbd->xid,msg,len,&hd);
	}else{
	  rtn=_TDSUDrvSend (Fd,0x0000,cbd->devid,sf,cbd->xid,msg,len,&hd);
	}
	DispData(2,&hd,msg,len,rtn);
      }else{
	if(len!=(-930) && len!=(-931)){
	  PE,"RECV Auto response error (%d)\n",len);
  } } } }

  return(0);
}



/* -------------------------------------------------------------------------- */
/* MʎMp Callback -------------------------------------------------- */

static int
CBSend(
void		*par,
TDSCBData	*cbd)
{
  DispData(0,&cbd->thd,cbd->msg,cbd->rtn,cbd->rtn);
  return(0);
}



/* -------------------------------------------------------------------------- */
/* [UEg[Xo͊֐ ------------------------------------------------- */

static int
CBTrace(
void		*par,
TDSTRData	*trd)
{
  PO,"UserTrace [%08d.%06d.%03d] (%4d) : %s\n"
	,trd->date,trd->time,trd->msec,trd->proc,trd->msg);
  return(0);
}



/* ========================================================================== */
/* Signal handler ----------------------------------------------------------- */

static void
CBSignal(
int		vec)
{
  signal(SIGINT,CBSignal);
  Break=1;
}
