
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2016.  All rights reserved.
 */


/* ========================================================================== */
/*
 * JVIo : eXg y TvEvO
 *
 *  `oŃbZ[W\zAP SECS bZ[W̑MsB
 *
 *
 * N@
 *
 *   java JVIo {h|e}
 *   ~~~~~~~~~~~~~~~
 *   h    : Sample.ini  [HOST]  ZNVQƂ肷
 *   e    : Sample.ini  [EQUIP]      :              :
 *
 *
 *   ʏAJVIo h y JVIo e ̗A}VA͈قȂ}V
 *   삳āAݒʐMsBʐḾABasicIo.exeACallbackio.exe ł
 *   悢B
 *
 *   NAj\QƂAvR[h͂A@\sB
 * 
 *   zXg͋NƁAu̐ڑ҂BuNƁAI
 *   ɃzXgɐڑvASelect v𔭍sBzXgł́A1:Recv 
 *   JԂsA\uSTATUS=951 : No datavƂȂ̂mFB̌A
 *   Cӂ̃bZ[ŴƂsBMł́AMf[^̊u
 *   STATUS=951vɂȂ܂ōsƂYʂƁB
 *
 *   QbZ[W𑗐Mۂ̃gUNVhćAOɎMP
 *   bZ[Ŵ̂gpB
 *
 *   {Tv́Aُ펞ꕔȗĂB
 *
 *   ȉŒ` "SECS_MODE" ́A֐Ƃ _TDJVSCommXxxx() gp
 *   ꍇ Active ڑ̏ꍇ Passive ւ̐ڑ̎s̗L𔻒f
 *   ߂ɒ`B
 *   "FUNC_TYPE" ́Agp鏈֐̎ʂI邽߂ɒ`B
 *   _TDJVSUDrvXxxx() gpꍇ́AHSMS-SS Active ڑ̏ꍇ̐ڑ
 *   sKvȂ̂ŁA{ł "SECS_MODE" ̐ݒKvȂB
 *   TDS ́ASECS-1 ڑ or HSMS-SS ڑ̐ؑւ́Aݒt@C (.ini) ɂčs
 *   ߁A֐Ƃ _TDJVSUDrvXxxx() gṕA[U`oł́A
 *   ڑiSECS-1/HSMS-SS  HSMS-SS Passive/ActivejmKv
 *   ȂB
 *
 *   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
 *   ɂĕ\ SECS bZ[W̏o͌`ύXłB
 *   "MSSG_USE_NEXTL" ̒lύXƁAbZ[We͂ۂɁAڒl
 *   f[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
 *   l "USE_CALLBACK"  =1 ƂƁAMs Callback ֐gp
 *   AMbZ[W̕\AQbZ[W̏o͂ōsB
 *   Callback ֐gpꍇA͑ipbZ[Wɗꂪ鎖ɗ
 *   邱ƁB
 */
/* ========================================================================== */

import		java.lang.*;
import		java.util.*;
import		java.io.*;
import		java.nio.*;

import static	TDL.TDS.TDJVS.*;


public class	JVIo{


/* -------------------------------------------------------------------------- */

static final int	EBADF		=9;
static final int	EBUSY		=16;
static final int	ENOMEM		=12;
static final int	ENODEV		=19;
static final int	E2BIG		=7;

static final int	E_NOTCONNECT	=999;
static final int	E_DESELECT	=998;
static final int	E_REJECT	=997;
static final int	E_SELECT	=992;
static final int	E_CONNECT	=991;
static final int	E_RETRYOVER	=989;
static final int	E_T8TIMEDOUT	=988;
static final int	E_T7TIMEDOUT	=987;
static final int	E_T6TIMEDOUT	=986;
static final int	E_T5TIMEDOUT	=985;
static final int	E_T4TIMEDOUT	=984;
static final int	E_T3TIMEDOUT	=983;
static final int	E_T2TIMEDOUT	=982;
static final int	E_T1TIMEDOUT	=981;
static final int	E_ILLBLOCK	=980;
static final int	E_NODATA	=951;


/* -------------------------------------------------------------------------- */

static final int	SECS_MODE	=1;	// SECS/HSMS [h
						// 0    : SECS-1
						// 1    : HSMS
static final int	FUNC_TYPE	=0;	// ʐMɎgp֐̎
						// 0    : _TDSCommXxxxx
						// 1    : _TDSUDrvXxxxx
static final int	UDRV_MASK  =0x8383ffff;	// UDrvOpen() Ɏgp}XN
						// 0 ̏ꍇ 0x49 ƂȂB
						// 0x8383ffff ͑SĂ EVENT

static final int	USE_CALLBACK	=1;	// Callback ֐gp̗L
						// 0    : gpȂ
						// 1    : gp

static final int	MSSG_USE_FILE	=0x80;	// bZ[W`t@C
						// 0x00 : gpȂ
						// 0x80 : gpčږ\
static final int	MSSG_DISP_TYPE	=0x20;	// SECS bZ[W\`
						// 0x00 : ʏ`
						// 0x10 : ????`
						// 0x20 : SML `
						// 0x40 : NSG/TS300 `
static final int	MSSG_USE_NEXTL	=1;	// MssgNextL gp邩ۂ
						// 0    : gpȂ
						// 1    : gp

static final String	PARAMFILE	="Sample.ini";


/* -------------------------------------------------------------------------- */

static int		Fd=0;		// ʐMpʎq
static int		Md=0;		// bZ[W͗pʎq
static int		Break=0;	// XbhIw
static int		OType=0;	// ^Cv (0:Host 1:Equip)

static int		cnt249=0;
static int		cnt250=0;
static int		cnt611=0;


/* ========================================================================== */
/* ʊ֐ ================================================================= */

static private void
printf(
String		form,
Object...	arg)
{
  try{
    System.out.printf(form,arg);
  }catch(UnknownFormatConversionException	err){
    System.out.printf("Format error\n");
  }catch(Exception				err){
    System.out.printf("Printf error\n");
  }
}


/* -------------------------------------------------------------------------- */

static private void
Sleep(
int		msec)
{
  try{
    Thread.sleep((long)msec);
  }catch(InterruptedException	err){
  }catch(Exception		err){
  }finally{
  }
}


/* -------------------------------------------------------------------------- */

static private String
ReadLine(			//  o : ͕
BufferedReader	in,		// i  : ͋Lqq
String		msg)		// i  : ͑ibZ[W
{
  String	line;

  for(;;){
    printf("%s"	,msg);
    try{			line=in.readLine();
    }catch(Exception		err){			continue;
    }							break;
  }

  return(line);
}


static private int
ReadInt(			//  o : ͒l
BufferedReader	in,		// i  : ͋Lqq
String		msg,		// i  : ͑ibZ[W
int		base)		// i  : 
{
  String	line;
  int		val;

  for(;;){
    line=ReadLine(in,msg);
    try{			val=Integer.parseInt(line,base);
    }catch(Exception		err){			continue;
    }							break;
  }

  return(val);
}


/* -------------------------------------------------------------------------- */
/* SECS bZ[WWo͂ɕ\B ------------------------------------ */

static private void
DispSECSMssg(			//
int		tp,		// i  : bZ[W
				//	=0 : M
				//	 1 : MbZ[W
				//	 2 : MbZ[W
byte		hd[],		// i  : SECS bZ[WEwb_
int		did,		// i  : SECS bZ[W̃foCXhc
int		sf,		// i  : SECS bZ[ŴreR[h
int		xid,		// i  : SECS bZ[W̃gUNVhc
byte		msg[],		// i  : SECS bZ[Wi[̈iwb_܂܂j
int		len)		// i  : SECS bZ[W̃oCg
{
  String	ctp[]={"SRES","RECV","SEND"};
  String	rbit,wbit,sfcode,c;
  StringBuffer	mname=new StringBuffer(),sitem=new StringBuffer();
  ByteBuffer	pm;
  byte		msg1[];
  long		ul;
  int		form[]=new int[1],sz[]=new int[1],noi[]=new int[1];
  int		rtn,md=0,dp=MSSG_USE_FILE|MSSG_DISP_TYPE,fm,la,i,j;

  rbit=" ";	if((did&0x8000)!=0)	rbit="R";
  wbit=" ";	if((sf &0x8000)!=0)	wbit="W";
  sfcode=String.format("S%dF%d",(sf&0x7f00)/0x0100,sf&0xff);
  printf("[%s]  Dev=0x%04x  %-8s  %s%s  XId=0x%04x  Len=%4d\n"
		,ctp[tp],did&0x7fff,sfcode,rbit,wbit,xid,len);

  if((MSSG_USE_FILE&0x80)!=0)	fm =0x8000;		// bZ[W`gp
  else				fm =0x0000;		// gp

  if(len>0){
    if(tp==1){	dp|=0x3000;	fm|=0x3000;}		// M̏ꍇ
    else{	dp|=0x2000;	fm|=0x2000;}		// M̏ꍇ
    pm=ByteBuffer.allocate(1024);	pm.order(ByteOrder.nativeOrder());
    msg1=pm.array();

    if((md=_TDJVSMssgFind(fm,msg,len,Fd,hd,mname))	> 0){
      printf("[%s]\n",mname.toString());		// bZ[W

      for(la=0;;){
	if(MSSG_USE_NEXTL==0){				// ڒl擾
	  rtn=_TDJVSMssgNext(md,0,msg,form,sz,noi,pm,1024);
	  if(rtn						< 0)	break;
	  printf("%03o:%d*%3d:"	,form[0],sz[0],noi[0]);
	  switch(form[0]){
	    case 000: printf("L[%d]\n"	,noi[0]);		break;
	    case 010: printf("B[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s0x%02x"
				,c,((int)msg1[i]&0xff));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 011: printf("T[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,msg1[i]);		if(i==0) c=",";
		      } printf("\n");				break; 
	    case 020: c=new String(msg1,0 ,noi[0]);
		      printf("A[%d]=%s.\n",noi[0],c);	c=null;	break;
	    case 021: c=new String(msg1,0 ,noi[0]);
		      printf("J[%d]=%s.\n",noi[0],c);	c=null;	break;
	    case 022: c=new String(msg1,0 ,noi[0]);
		      printf("K[%d]=%s.\n",noi[0],c);	c=null;	break;
	    case 030: printf("I8[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,pm.getLong	(i*8));	if(i==0) c=",";
		      } printf("\n");				break;
	    case 031: printf("I1[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,msg1[i]);		if(i==0) c=",";
		      } printf("\n");				break; 
	    case 032: printf("I2[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"
				,c,(int)pm.getShort	(i*2));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 034: printf("I4[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,pm.getInt	(i*4));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 040: printf("F8[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%22.17e"
				,c,pm.getDouble		(i*8));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 044: printf("F4[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%13.8e",c,pm.getFloat	(i*4));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 050: printf("U8[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,pm.getLong	(i*8));	if(i==0) c=",";
		      } printf("\n");				break;
	    case 051: printf("U1[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
			ul=((long)msg1[i])&0xffL;
		        printf("%s%d"	,c,ul);			if(i==0) c=",";
		      } printf("\n");				break; 
	    case 052: printf("U2[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
			ul=((long)pm.getShort(i*2))&0xffffL;
		        printf("%s%d"	,c,ul);			if(i==0) c=",";
		      } printf("\n");				break; 
	    case 054: printf("U4[%d]"		,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
			ul=((long)pm.getInt  (i*4))&0xffffffffL;
		        printf("%s%d"	,c,ul);			if(i==0) c=",";
		      } printf("\n");				break; 
	    default:  printf("\n");				break;
	  }

	}else{						// Xg\`Ŏ擾
	  rtn=_TDJVSMssgNextL(md,dp,msg,form,noi,mname);
	  if(rtn						< 0)	break;
	  if((dp&0x70)>0x10){				// SMLANSG/TS300 ̏ꍇ
	    for(  i=la;i>rtn;i--){
	      for(j= 0;j<i  ;j++) printf("  ");
	      printf(">\n");				// '>' \
	  } }
	  la=rtn;					// ݂̊Kwۑ
	  printf("  %s\n",mname.toString());		// 擾ڒl\
	  if((dp&0x70)>0x10 && form[0]==000 && noi[0]==0){
	    for(  j= 0;j<=la;j++) printf("  ");
	    printf(">\n");				// L0 ̏ꍇ '>' 
      } } }
      if(MSSG_USE_NEXTL!=0){
	if((dp&0x70)>0x10){
	  for(  i=la;i>0;i--){
	    for(j= 0;j<i;j++)	  printf("  ");
	    printf(">\n");				// c '>' \
      } } }
      _TDJVSMssgExit(md,0,msg);
  } }
}



/* -------------------------------------------------------------------------- */
/* Mf[^\B-------------------------------------------------- */

static private int
DispData(
int		tp,		// i  : bZ[W
				//	=0 : M
				//	 1 : MbZ[W
				//	 2 : MbZ[W
byte		hd[],		// i  : SECS bZ[WEwb_
int		did,		// i  : SECS bZ[W̃foCXhc
int		sf,		// i  : SECS bZ[ŴreR[h
int		xid,		// i  : SECS bZ[W̃gUNVhc
byte		msg[],		// i  : SECS bZ[W{
int		len,		// i  : msg ̒
int		rtn)		// i  : I/O ̖߂l
{
  int		ok=0,stat;

  if(rtn<0){							 ok=1;
    if((rtn<(-E_NOTCONNECT) || (-E_ILLBLOCK)<rtn) && rtn!=(-E_NODATA)){
      printf("ERROR  [%d]"			,rtn);
      if      (rtn==(-ENODEV)){
	printf(" : No such device ID\n");	len=ok=0;
      }else if(rtn==(-E2BIG )){
	printf(" : Data size to large\n");	len=ok=0;
      }else			printf("\n");
    }else{
      if(FUNC_TYPE==0)	stat=_TDJVSCommStatus(Fd,0);
      else		stat=_TDJVSUDrvStatus(Fd,0);
      printf("STATUS = %d,%d : "		,-rtn,stat);
      switch(-rtn){
	case E_NODATA:		printf("No data\n");			break;
	case E_ILLBLOCK:	printf("Illegal block#\n");		break;
	case E_T1TIMEDOUT:	printf("T1 Timeout occur\n");		break;
	case E_T2TIMEDOUT:	printf("T2 Timeout occur\n");		break;
	case E_T3TIMEDOUT:	printf("T3 Timeout occur\n");		break;
	case E_T4TIMEDOUT:	printf("T4 Timeout occur\n");		break;
	case E_T5TIMEDOUT:	printf("T5 Timeout occur\n");		break;
	case E_T6TIMEDOUT:	printf("T6 Timeout occur\n");		break;
	case E_T7TIMEDOUT:	printf("T7 Timeout occur\n");		break;
	case E_T8TIMEDOUT:	printf("T8 Timeout occur\n");		break;
	case E_RETRYOVER:	printf("Retry over\n");			break;
	case E_CONNECT:		printf("Connected\n");			break;
	case E_SELECT:		printf("Selected\n");			break;
	case E_REJECT:		printf("Rejected XId=0x%04x\n",xid);	break;
	case E_DESELECT:	printf("Deselected\n");			break;
	case E_NOTCONNECT:	printf("Not connected\n");		break;
	default:		printf("\n");				break;
  } } }

  if(ok==0) DispSECSMssg(tp,hd,did,sf,xid,msg,len);

  return(0);
}



/* ========================================================================== */
/* S1F1 bZ[W\zyёM ---------------------------------------------- */

static private int
SendS1F1()
{
  byte		hd[]=new byte[12],msg[]=new byte[16];
  int		rtn,sf=0x8101,len=0;

  if(FUNC_TYPE	==0)	rtn=_TDJVSCommSend(Fd,0x0000,0,sf,0,msg,len,hd);
  else			rtn=_TDJVSUDrvSend(Fd,0x0000,0,sf,0,msg,len,hd);
  DispData(2,hd,0x00,sf,rtn,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Host) \zyёM -------------------------------------- */

static private int
SendS1F2H(
int		did,
int		xid)
{
  byte		hd[]=new byte[12],msg[]=new byte[256];
  byte		vb[]=new byte[32];
  int		rtn,md,sf=0x0102,len;
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDJVSMssgInit   (   0,msg, 256,Fd);		// S1F2
		_TDJVSMssgBuild  (md,0,msg, 000,  0,vb);	// L0
    len=	_TDJVSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
		_TDJVSMDMssgInit (Md,0,msg, 256,"S1F2_H");
    len=	_TDJVSMDMssgEnd  (Md,0,msg);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDJVSCommSend (Fd,0x0000,did,sf,xid,msg,len,hd);
    else		rtn=_TDJVSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S1F2 bZ[W (Equip) \zyёM ------------------------------------- */

static private int
SendS1F2E(
int		did,
int		xid)
{
  byte		hd[]=new byte[12],msg[]=new byte[256];
  byte		vb[]=new byte[32];
  int		rtn,md,sf=0x0102,len;
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDJVSMssgInit   (   0,msg, 256,Fd);		// S1F2
		_TDJVSMssgBuild  (md,0,msg, 000, 2,vb);		// L2
		_TDJVSMssgBuild  (md,0,msg, 020, 6,"EQUIP1");	//  MDLN
		_TDJVSMssgBuild  (md,0,msg, 020, 6,"01.000");	//  SOFTREV
    len=	_TDJVSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
		_TDJVSMDMssgInit (Md,0,msg, 256,"S1F2_E");
    len=	_TDJVSMDMssgEnd  (Md,0,msg);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDJVSCommSend (Fd,0x0000,did,sf,xid,msg,len,hd);
    else		rtn=_TDJVSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);

  return(rtn);
}


/* ========================================================================== */
/* S2F49 bZ[W\zyёM --------------------------------------------- */

static private int
SendS2F49()
{
  byte		hd[]=new byte[12],msg[]=new byte[1024];
  byte		vb[]=new byte[32];
  int		vi[]=new int[4];
  String	str,itm;
  int		rtn,md,sf=0x8200+49,no1,no2,len,i,j;

  cnt249++;	no1=(cnt249%2)+1;	no2=(cnt249%10)+1;
  str=String.format("LOTID (%04d)"	,cnt249);
  
  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDJVSMssgInit   (   0,msg,1024,Fd);		// S2F49
  		_TDJVSMssgBuild  (md,0,msg, 000,  3,vb);	// L3
    vb[0]=0;	_TDJVSMssgBuild  (md,0,msg, 010,  1,vb);	//  DATAIDB
  		_TDJVSMssgBuild  (md,0,msg, 020,  0,"LOAD");	//  RCMD
  		_TDJVSMssgBuild  (md,0,msg, 000,  4,vb);	//  L4
    vb[0]=1;	_TDJVSMssgBuild  (md,0,msg, 010,  1,vb);	//   STID
    vb[0]=0;	_TDJVSMssgBuild  (md,0,msg, 010,  1,vb);	//   MTKD
  		_TDJVSMssgBuild  (md,0,msg, 020, 20,str);	//   LOTID
		_TDJVSMssgBuild  (md,0,msg, 000,no1,vb);	//   L[no1]
    for(i=0;i<no1;i++){
		_TDJVSMssgBuild  (md,0,msg, 000,no2,vb);	//    L[no2]
      for(j=0;j<no2;j++){
		_TDJVSMssgBuild  (md,0,msg, 000,  2,vb);	//     L[2]
	str=String.format("WAFER(%04d-%d-%02d)",cnt249,i+1,i+2);
  		_TDJVSMssgBuild  (md,0,msg, 020, 20,str);	//      WAFERID
	str=String.format("PPID (%04d-%d-%02d)",cnt249,i+1,i+2);
  		_TDJVSMssgBuild  (md,0,msg, 020, 16,str);	//      PPID
    } }
    len=	_TDJVSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
		_TDJVSMDMssgInit (Md,0,msg,1024,"S2F49");
  		_TDJVSMDMssgBuild(Md,0,msg,"LOTID",0,str);	//   LOTID
    vi[0]=no1;	_TDJVSMDMssgBuild(Md,0,msg,"NOI1" ,1,vi);	//   L[no1]
    for(i=0;i<no1;i++){
      itm  =String.format("NOI2:%d"			,i+1);
      vi[0]=no2;_TDJVSMDMssgBuild(Md,0,msg,itm   ,1,vi);	//    L[no2]
      for(j=0;j<no2;j++){
	itm=String.format("WAFERID:%d:%d"		,i+1,j+1);
	str=String.format("WAFERID[%04d-%d-%02d]",cnt249,i+1,j+1);
  		_TDJVSMDMssgBuild(Md,0,msg,itm    ,0,str);	//     WAFERID
	itm=String.format("PPID:%d:%d"			,i+1,j+1);
	str=String.format("PPID [%04d-%d-%02d]"	 ,cnt249,i+1,j+1);
  		_TDJVSMDMssgBuild(Md,0,msg,itm    ,0,str);	//     PPID
    } }
    len=	_TDJVSMDMssgEnd  (Md,0,msg);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDJVSCommSend (Fd,0x0000,0,sf,  0,msg,len,hd);
    else		rtn=_TDJVSUDrvSend (Fd,0x0000,0,sf,  0,msg,len,hd);
  }
  DispData(2,hd,0x00,sf,rtn,msg,len,rtn);

  return(rtn);
}


/* ---------------------------------------------------------------------------*/
/* S2F50 bZ[W\zyёM --------------------------------------------- */

static private int
SendS2F50(
int		did,
int		xid)
{
  byte		hd[]=new byte[12],msg[]=new byte[256];
  byte		vb[]=new byte[32];
  String	str;
  int		rtn,md,sf=0x0200+50,len;
  
  str=String.format("LOTID (%04d)"		,++cnt250);

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDJVSMssgInit   (   0,msg, 256,Fd);		// S2F50
		_TDJVSMssgBuild  (md,0,msg, 000,  2,vb);	// L2
    vb[0]=0;	_TDJVSMssgBuild  (md,0,msg, 010,  1,vb);	//  HCACK
		_TDJVSMssgBuild  (md,0,msg, 000,  2,vb);	//  L2
  		_TDJVSMssgBuild  (md,0,msg, 020,  5,"PODID");	//   PODID
  		_TDJVSMssgBuild  (md,0,msg, 020, 20,str);	//   LOTID
    len=	_TDJVSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
		_TDJVSMDMssgInit (Md,0,msg, 256,"S2F50");
		_TDJVSMDMssgBuild(Md,0,msg,"LOTID",  0,str);	//   LOTID
    len=	_TDJVSMDMssgEnd  (Md,0,msg);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDJVSCommSend (Fd,0x0000,did,sf,xid,msg,len,hd);
    else		rtn=_TDJVSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);

  return(rtn);
}


/* ========================================================================== */
/* S6F11 bZ[W\zyёM --------------------------------------------- */

static private int
SendS6F11()
{
  byte		hd[]=new byte[12],msg[]=new byte[256];
  short		vs[]=new short[4];
  int		rtn,md,sf=0x8600+11,len;

  if((++cnt611)==32768) cnt611=0;

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDJVSMssgInit   (   0,msg, 256,Fd);		// S6F11
  		_TDJVSMssgBuild  (md,0,msg, 000,  3,vs);	// L3
    vs[0]=(short)cnt611;
		_TDJVSMssgBuild	 (md,0,msg, 052,  1,vs);	//  DATAID
    vs[0]=8;	_TDJVSMssgBuild  (md,0,msg, 052,  1,vs);	//  CEID
  		_TDJVSMssgBuild  (md,0,msg, 000,  3,vs);	//  L3
  		_TDJVSMssgBuild  (md,0,msg, 020, 16,"DATA1");	//   DATA1
  		_TDJVSMssgBuild  (md,0,msg, 020, 16,"DATA2");	//   DATA2
  		_TDJVSMssgBuild  (md,0,msg, 020, 14,"YYYYMMDDhhmmss");
						// @TIME ({͌ݎݒ
						// ̂AȗB
    len=	_TDJVSMssgEnd    (md,0,msg);

  }else{					// bZ[W`gp
		_TDJVSMDMssgInit (Md,0,msg, 256,"S6F11");
    vs[0]=(short)cnt611;
		_TDJVSMDMssgBuild(Md,0,msg,"DATAID",1,vs);	//  DATAID
    len=	_TDJVSMDMssgEnd  (Md,0,msg);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDJVSCommSend (Fd,0x0000,0,sf,  0,msg,len,hd);
    else		rtn=_TDJVSUDrvSend (Fd,0x0000,0,sf,  0,msg,len,hd);
  }
  DispData(2,hd,0x00,sf,rtn,msg,len,rtn);

  return(rtn);
}



/* ---------------------------------------------------------------------------*/
/* S6F12 bZ[W\zyёM --------------------------------------------- */

static private int
SendS6F12(
int		did,
int		xid)
{
  byte		hd[]=new byte[12],msg[]=new byte[256];
  byte		vb[]=new byte[32];
  int		rtn,md,sf=0x0600+12,len;

  if((MSSG_USE_FILE&0x80)==0){			// bZ[W`gpȂ
    md=		_TDJVSMssgInit	(   0,msg, 256,Fd);		// S6F12
    vb[0]=0;	_TDJVSMssgBuild	(md,0,msg, 010,  1,vb);		// ACKC
    len=	_TDJVSMssgEnd 	(md,0,msg);

  }else{					// bZ[W`gp
		_TDJVSMDMssgInit(Md,0,msg, 256,"S6F12");
    len=	_TDJVSMDMssgEnd (Md,0,msg);
  }

  if(len<0)		rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=_TDJVSCommSend (Fd,0x0000,did,sf,xid,msg,len,hd);
    else		rtn=_TDJVSUDrvSend (Fd,0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);

  return(rtn);
}



/* ========================================================================== */
/* Callback ֐ ============================================================ */

static private int
CBRecvProc(
int		req,		// i  : Cuւ̗vR[h
int		rtn,		// i  : Cu̖߂l
int		did,		// i  : SECS bZ[W̃foCXhc
int		xsf,		// i  : SECS bZ[ŴreR[h
int		xid,		// i  : SECS bZ[W̃gUNVhc
byte		xhd[],		// i  : SECS bZ[WEwb_
byte		xmsg[])		// i  : SECS bZ[W
{
  StringBuffer	rname=new StringBuffer(),sname=new StringBuffer();
  byte		hd[]=new byte[12],msg[]=new byte[1024];
  int		sf[]=new int[1];
  int		len;

  DispData(1,xhd,did,xsf,xid,xmsg,rtn,rtn);
  if      (req== 0 && rtn>=0){
    if((MSSG_USE_FILE&0x80)==0){	// bZ[W`t@CgpȂ
					// ꍇ́A͂ SF-Code 𒲂ׁAQ
					// bZ[W̑o̕Kv𔻒fA
					// Kvȏꍇ́AoB
      if     (xsf==(0x8100+ 1)&&OType==0)	SendS1F2H (did,xid);
      else if(xsf==(0x8100+ 1)&&OType==1)	SendS1F2E (did,xid);
      else if(xsf==(0x8200+49))			SendS2F50 (did,xid);
      else if(xsf==(0x8600+11))			SendS6F12 (did,xid);

    }else if((xsf & 0x8000)!=0){	// bZ[W`t@Cgp
					// ꍇ́A{Tvł́AԐM@\
					// gpB
      msg=xmsg;
      if((len=_TDJVSMDMssgAutoRes(Md,0,xhd
			,msg,rtn,1024,rname,sname,sf))		>=0){
	printf("RECV %s ..  Auto respond %s [S%dF%d]\n"
		,rname.toString(),sname.toString(),sf[0]/0x100,sf[0]&0xff);
	if(FUNC_TYPE==0) rtn=_TDJVSCommSend(Fd,0x0000,did,sf[0],xid,msg,len,hd);
	else		 rtn=_TDJVSUDrvSend(Fd,0x0000,did,sf[0],xid,msg,len,hd);
	DispData(2,hd,did,sf[0],xid,msg,len,rtn);
      }else{
	if(len!=(-930) && len!=(-931)){
	  printf("RECV Auto response error (%d)\n",len);
  } } } }

  return(0);
}



/* -------------------------------------------------------------------------- */

static class RecvProcThread extends Thread{
public void
run()
{
  byte		msg[]=new byte[1024],hd[]=new byte[12];
  int		xid[]=new int[1],did[]=new int[1],sf[]=new int[1];
  int		rtn,req;

  for(;Break==0;){
    req=0;
    if(FUNC_TYPE==0)	rtn=_TDJVSCommRecv(Fd,0,did,sf,xid,msg,1024,hd);
    else		rtn=_TDJVSUDrvRecv(Fd,0,did,sf,xid,msg,1024,hd);
    if(rtn==(-951)){
      Sleep(100);
    }else{
      if((-1000)<rtn && rtn<(-959))	req=(-rtn)-900;
      CBRecvProc(req,rtn,did[0],sf[0],xid[0],hd,msg);
  } }
}
}



/* ========================================================================== */
/* Main  ---------------------------------------------------------------- */

public static void
main(
String[]		argv)
{
  if     (argv.length<1)		printf("JVIo {h|e}\n");
  else if(argv[0].equals("h")==false &&
	  argv[0].equals("e")==false)	printf("JVIo {h|e}\n");
  else{
    if(argv[0].equals("h")==true)	Host ();
    else				Equip();
  }
}



/* ========================================================================== */
/* zXg ------------------------------------------------------------- */

static private void
Host()
{
  BufferedReader	in;
  RecvProcThread	th;
  String		str;
  byte			hd[]=new byte[12],msg[]=new byte[1024];
  int			xid[]=new int[1],did[]=new int[1],sf[]=new int[1];
  int			req,rtn,mno,dsd=0,xsd=0;

  OType=0;	Break=0;
  in=new BufferedReader(new InputStreamReader(System.in));

L0:{
  if(FUNC_TYPE	==0)	Fd=_TDJVSCommOpen(0x02,PARAMFILE,"HOST");
  else			Fd=_TDJVSUDrvOpen(0x02,PARAMFILE,"HOST",UDRV_MASK);
  if(Fd							  < 0) break L0;
  printf("(H) Opened (%d)\n",Fd);
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDJVSMDMssgInitialize(0x4000,Fd,"");

  if(USE_CALLBACK!=0){
    th=new RecvProcThread();
    th.start();
  }

  for(;;){		rtn=0;
    if(USE_CALLBACK==0)	str="Req (0:Exit 1:Recv 2:Send) : ";
    else		str="Req (0:Exit 2:Send) : ";
    req=ReadInt(in,str,10);
    if      (req==0){						break;

    }else if(req==1){
      if(FUNC_TYPE==0)	rtn=_TDJVSCommRecv(Fd,0,did,sf,xid,msg,1024,hd);
      else		rtn=_TDJVSUDrvRecv(Fd,0,did,sf,xid,msg,1024,hd);
      if(rtn	>=0){	dsd=did[0];	xsd=xid[0];}
      DispData(1,hd,did[0],sf[0],xid[0],msg,rtn,rtn);

    }else if(req==2){
      if(USE_CALLBACK==0) str="Message(1:S1F1 2:S2F49  6:S1F2 7:S6F12) : ";
      else		  str="Message(1:S1F1 2:S2F49) : ";
      mno=ReadInt(in,str,10);
      switch(mno){
	case 1: rtn=SendS1F1 ();		break;
	case 2: rtn=SendS2F49();		break;
	case 6: rtn=SendS1F2H(dsd,xsd);		break;
	case 7: rtn=SendS6F12(dsd,xsd);		break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      printf("(H) I/O Error (%d)\n"	,rtn);
  } }
  }	// L0:

  Break=1;
  if(Md>0)		_TDJVSMDMssgTerminate(Md,0);
  if(Fd>0){
    if(FUNC_TYPE==0)	_TDJVSCommClose(Fd,0);
    else		_TDJVSUDrvClose(Fd,0);
  } else	printf("(H) Error (%d)\n"	,Fd);
}



/* ========================================================================== */
/* u --------------------------------------------------------------- */

static private void
Equip()
{
  BufferedReader	in;
  RecvProcThread	th;
  String		str;
  byte			hd[]=new byte[12],msg[]=new byte[1024];
  int			xid[]=new int[1],did[]=new int[1],sf[]=new int[1];
  int			req,rtn,mno,dsd=0,xsd=0;

  OType=1;	Break=0;
  in=new BufferedReader(new InputStreamReader(System.in));

L0:{
  if(FUNC_TYPE	==0)	Fd=_TDJVSCommOpen(0x02,PARAMFILE,"EQUIP");
  else			Fd=_TDJVSUDrvOpen(0x02,PARAMFILE,"EQUIP",UDRV_MASK);
  if(Fd								  < 0) break L0;
  printf("(E) Opened (%d)\n",Fd);
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDJVSMDMssgInitialize(0x4000,Fd,"");

  if(USE_CALLBACK!=0){
    th=new RecvProcThread();
    th.start();
  }

  if(SECS_MODE!=0 && FUNC_TYPE==0){		// HSMS  TDSComm gp̏ꍇ
    if(_TDJVSCommSend(Fd,0x0100,0,0,0,msg,0,hd)			< 0) break L0;
    printf("(E) Connected\n");
    if(_TDJVSCommSend(Fd,0x0200,0,0,0,msg,0,hd)			< 0) break L0;
    printf("(E) Selected\n");
  }

  for(;;){		rtn=0;
    if(USE_CALLBACK==0)	str="Req (0:Exit 1:Recv 2:Send) : ";
    else		str="Req (0:Exit 2:Send) : ";
    req=ReadInt(in,str,10);
    if      (req==0){						     break;

    }else if(req==1){
      if(FUNC_TYPE==0)	rtn=_TDJVSCommRecv(Fd,0,did,sf,xid,msg,1024,hd);
      else		rtn=_TDJVSUDrvRecv(Fd,0,did,sf,xid,msg,1024,hd);
      if(rtn	>=0){	dsd=did[0];	xsd=xid[0];}
      DispData(1,hd,did[0],sf[0],xid[0],msg,rtn,rtn);

    }else if(req==2){
      if(USE_CALLBACK==0) str="Message(1:S1F1 2:S6F11  6:S1F2 7:S2F50) : ";
      else		  str="Message(1:S1F1 2:S6F11) : ";
      mno=ReadInt(in,str,10);
      switch(mno){
	case 1: rtn=SendS1F1 ();		break;
	case 2: rtn=SendS6F11();		break;
	case 6: rtn=SendS1F2E(dsd,xsd);		break;
	case 7: rtn=SendS2F50(dsd,xsd);		break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      printf("(E) I/O Error (%d)\n"	,rtn);
  } }

  if(SECS_MODE!=0){				// HSMS ڑ̏ꍇ
  // Deselect request ͍sȂBiSEMI ł HSMS-SS ɂāADeselect request
  // ͍sĂ͂ȂȂAƂĂBj
  //if(FUNC_TYPE==0)	rtn=_TDJVSCommSend(Fd,0x0800,0,0,0,msg,0,hd);
  //else		rtn=_TDJVSUDrvSend(Fd,0x0800,0,0,0,msg,0,hd);
  //if(rtn							< 0) break L0;
  //printf("(E) Deselected\n");
    if(FUNC_TYPE==0)	rtn=_TDJVSCommSend(Fd,0x0900,0,0,0,msg,0,hd);
    else		rtn=_TDJVSUDrvSend(Fd,0x0900,0,0,0,msg,0,hd);
    if(rtn							< 0) break L0;
    printf("(E) Separate\n");
  }
  }	// L0:

  Break=1;
  if(Md>0)		_TDJVSMDMssgTerminate(Md,0);
  if(Fd>0){
    if(FUNC_TYPE==0)	_TDJVSCommClose(Fd,0);
    else		_TDJVSUDrvClose(Fd,0);
  } else	printf("(E) Error (%d)\n"	,Fd);
}

}
