
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2016.  All rights reserved.
 */


/* ========================================================================== */
/*
 * CallbackIo : eXg y TvEvO
 *
 *  Callback ֐gpĎMbZ[Wɑ΂鉞sB܂A[U
 *  `g[Xo͊֐gpAg[Xo͂͂ōsB
 *
 *
 * N@
 *
 *   CallbackIo {h|e}
 *   ~~~~~~~~~~~~~~~~
 *   h    : Sample.ini  [HOST]  ZNVQƂ肷
 *   e    : Sample.ini  [EQUIP]      :              :
 *
 *
 *   ʏACallbackIo h y CallbackIo e ̗A}VA͈قȂ
 *   }Vœ삳āAݒʐMsB
 *
 *   N̑ƂẮA^C ̓͂ɂ胁j\sAvR[h
 *   āA葤ɃbZ[W𑗏oB
 *   MbZ[WAyъeCxg Callback ֐̒ŏ
 *   BL "MSSG_USE_FILE"  0x80 ɐݒ肷ƁACallbackIo.ini Őݒ
 *   bZ[W`t@C Sample.sml ̓eɂAMPbZ[W
 *   ɑΉQbZ[WoB
 *   MSSG_USE_FILE=0x80ibZ[W`t@Cgpjꍇ́AbZ[W
 *   `t@Cɒ`Cӂ̃bZ[Ŵ̖w肷邱ƂɂA
 *   bZ[W𑗏oB
 * 
 *   vR[hɂAԊuiSEND_WAIT ɂĎwjł̘AMsB
 *   AḾA^C ̓͂ɂIB
 *   ̏ꍇAPbZ[W̑MƁAQbZ[W̑Mɔ
 *   \BbZ[W`t@CgpđMbZ[W쐬ꍇA
 *   {Tvł́AbZ[W͗p̃fXNv^͂PpӂĂȂ
 *   ŁAMAԐMł̃bZ[W\zobeBOȂ悤ɃbN
 *   KvBڍׂ SunFunctions.h ̐擪QƂ邱ƁB
 * 
 *   {Tv́Aُ펞ꕔȗĂB
 *
 *   ȉŒ` "SECS_MODE" ́A֐Ƃ _TDSCommXxxx() gp
 *   ꍇ Active ڑ̏ꍇ Passive ւ̐ڑ̎s̗L𔻒f
 *   ߂ɒ`B
 *   "FUNC_TYPE" ́Agp鏈֐̎ʂI邽߂ɒ`B
 *   _TDSUDrvXxxx() gpꍇ́AHSMS-SS Active ڑ̏ꍇ̐ڑs
 *   KvȂ̂ŁA{ł "SECS_MODE" ̐ݒKvȂB
 *   TDS ́ASECS-1 ڑ or HSMS-SS ڑ̐ؑւ́Aݒt@C (.ini) ɂčs
 *   ߁A֐Ƃ _TDSUDrvXxxx() gṕA[U`oł́A
 *   ڑiSECS-1/HSMS-SS  HSMS-SS Passive/ActivejmKv
 *   ȂB _TDSUDrvXxxx() gpꍇ́ACallback ͎͂ōs
 *   KvB
 *
 *   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
 *   ɂĕ\ SECS bZ[W̏o͌`ύXłB
 *   "MSSG_USE_NEXTL" ̒lύXƁAbZ[We͂ۂɁAڒl
 *   f[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
 *   l "USE_USER_TRACE" ̒lύXƁAUser Trace o͗p Callback 
 *   gp̗LύXłB
 */
/* ========================================================================== */

#include	"TDS.h"


#define		PO		fprintf(stdout
#define		PE		fprintf(stderr

#define		SECS_MODE	1		// SECS/HSMS [h
						// 0    : SECS-1
						// 1    : HSMS
#define		FUNC_TYPE	0		// ʐMɎgp֐̎
						// 0    : _TDSCommXxxxx
						// 1    : _TDSUDrvXxxxx
#define		UDRV_MASK  	0x8383ffff	// UDrvOpen() Ɏgp}XN
						// 0 ̏ꍇ 0x49 ƂȂB
						// 0x8383ffff ͑SĂ EVENT

#define		MSSG_USE_FILE	0x80		// bZ[W`t@C
						// 0x00 : gpȂ
						// 0x80 : gpčږ\
#define		MSSG_DISP_TYPE	0x20		// SECS bZ[W\`
						// 0x00 : ʏ`
						// 0x20 : SML `
						// 0x40 : NSG/TS300 `
#define		MSSG_USE_NEXTL	1		// MssgNextL gp邩ۂ
						// 0    : gpȂ
						// 1    : gp
#define		USE_USER_TRACE	0		// UserTracepCB gp邩ۂ
						// 0    : gpȂ
						// 1    : gp

#define		SEND_WAIT	2000		// bZ[WMԊu      (mb)
#define		SEND_NO		10		// bZ[WMx݂܂ł̉
#define		SEND_SLEEP	10000		// xݎ              (mb)
#define		ERROR_SLEEP	10000		// G[xݎ  (mb)

#define		PARAMFILE	"Sample.ini"

static int	Finish=0;	// Xbhւ̏Iw


static void	Host();
static void	Equip();



/* ========================================================================== */
/* ʊ֐ ================================================================= */

#include	"SubFunctions.h"



/* ========================================================================== */
/* M Callback pXbh (_TDSUDrvRecv() p) ------------------------- */

#if defined	WINDOWS
static void
#else
static void*
#endif
RecvProcThread(
void			*par)
{
  TDSCBData		cbd;
  char			msg[1024];
  int			msz;

  cbd.vec=1;		cbd.msg=msg;
  msz=sizeof(msg);

  for(;Finish==0;){
    cbd.rtn=_TDSUDrvRecv(Fd,0,&cbd.devid,&cbd.sf,&cbd.xid,cbd.msg,msz,&cbd.thd);
    if(cbd.rtn	== -E_NODATA)	Sleep(100);
    else{
      if((-1000)<cbd.rtn && cbd.rtn<(-959))	cbd.req=(-cbd.rtn)-900;
      else					cbd.req=0;
      CBRecv(par,&cbd);
  } }
}



/* ========================================================================== */
/* Main  ---------------------------------------------------------------- */

int
main(
int			argc,
char			*argv[])
{
  if(argc<2 || (argv[1][0]!='h' && argv[1][0]!='e')){
    PE,"%s {host|equip}\n"	,argv[0]);			exit(1);
  }

  signal(SIGINT,CBSignal);
//InitializeCriticalSection(&Cs0);
  InitializeCriticalSection(&Cs1);

  if(argv[1][0]=='h')	Host ();
  else			Equip();

//DeleteCriticalSection(&Cs0);
  DeleteCriticalSection(&Cs1);
  exit(0);
}



/* ========================================================================== */
/* zXg ------------------------------------------------------------- */

static void
Host()
{
  int			(*cbtrace)(void*,TDSTRData*)=0;
  char			mname[64];
  int			req,rtn,mno,stat,i;

  if(USE_USER_TRACE!=0)	cbtrace=CBTrace;
  if(FUNC_TYPE==0){
    Fd=_TDSCommOpen(0x02,PARAMFILE,"HOST",CBRecv,0,CBSend,0,cbtrace,0);
  }else{
    Fd=_TDSUDrvOpen(0x02,PARAMFILE,"HOST",UDRV_MASK);
  }
  if(Fd								< 0) goto Exit;

  		// _TDSUDrvXxxx() gp̏ꍇ Callback ͂Ŏs
  if(FUNC_TYPE!=0) _beginthread(RecvProcThread,0,0);

  PO,"(H) Opened (%d)\n",Fd);	OType=0;
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);

  for(Break=0;;){
    Sleep(500);
    if(Break!=0){	Break=rtn=0;	req=99;
      PE,"Req (0:Exit 2:Send 3:Continuous) : "); scanf("%d",&req);
      if      (req==0){						break;
      }else if(req==2){
	PE,"Message(1:S1F1 2:S2F49   9:Any) : ");
	scanf("%d",&mno);
	switch(mno){
	  case 1: rtn=SendS1F1 ();			break;
	  case 2: rtn=SendS2F49();			break;
	  case 9: if((MSSG_USE_FILE&0x80)!=0){
		    PE,"Message Name : ");	scanf("%s",mname);
		    rtn=SendNamedMssg(0,0,mname);
		  }					break;
	}
      }else if(req==3){
	for(i=0;Break==0;i++){
	  Sleep(SEND_WAIT);
	  if(FUNC_TYPE==0)	stat=_TDSCommStatus(Fd,0);
	  else			stat=_TDSUDrvStatus(Fd,0);
	  if(stat==3){
	    if((rtn=SendS2F49())	< 0){
	      PE,"(H) Send error (%d)\n",rtn);	Sleep(ERROR_SLEEP);
	    }
	    if((i%SEND_NO)		==0)	Sleep(SEND_SLEEP);
	} }
	rtn=0;
      }
      if(rtn<(-999) || ((-900)<rtn && rtn<0) ){
	PE,"(H) Send error (%d)\n"	,rtn);
  } } }

Exit:
  Finish=1;		Sleep(1000);
  if(Md>0)		_TDSMDMssgTerminate(Md,0);
  if(Fd>0){
    if(FUNC_TYPE==0)	_TDSCommClose(Fd,0);
    else		_TDSUDrvClose(Fd,0);
  } else		PE,"(H) Error (%d)\n",Fd);
}



/* ========================================================================== */
/* u --------------------------------------------------------------- */

static void
Equip()
{
  int			(*cbtrace)(void*,TDSTRData*)=0;
  char			mname[64];
  int			req,rtn,mno,stat,i;

  if(USE_USER_TRACE!=0)	cbtrace=CBTrace;
  if(FUNC_TYPE==0){
    Fd=_TDSCommOpen(0x02,PARAMFILE,"EQUIP",CBRecv,0,CBSend,0,cbtrace,0);
  }else{
    Fd=_TDSUDrvOpen(0x02,PARAMFILE,"EQUIP",UDRV_MASK);
  }
  if(Fd								< 0) goto Exit;

  		// _TDSUDrvXxxx() gp̏ꍇ Callback ͂Ŏs
  if(FUNC_TYPE!=0) _beginthread(RecvProcThread,0,0);

  PO,"(E) Opened (%d)\n",Fd);	OType=1;
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);
  if(SECS_MODE!=0 && FUNC_TYPE==0){		// HSMS  TDSComm gp̏ꍇ
    if(_TDSCommSend(Fd,0x0100,0,0,0,0,0,0)			< 0) goto Exit;
    printf("(E) Connected\n");
    if(_TDSCommSend(Fd,0x0200,0,0,0,0,0,0)			< 0) goto Exit;
    printf("(E) Selected\n");
  }

  for(Break=0;;){
    Sleep(500);
    if(Break!=0){	Break=rtn=0;	req=99;
      PE,"Req (0:Exit 2:Send 3:Continuous) : "); scanf("%d",&req);
      if      (req==0){						 break;
      }else if(req==2){
	PE,"Message(1:S1F1 2:S6F11   9:Any) : ");
	scanf("%d",&mno);
	switch(mno){
	  case 1: rtn=SendS1F1 ();			break;
	  case 2: rtn=SendS6F11();			break;
	  case 9: if((MSSG_USE_FILE&0x80)!=0){
		    PE,"Message Name : ");	scanf("%s",mname);
		    rtn=SendNamedMssg(0,0,mname);
		  }					break;
	}
      }else if(req==3){
	for(i=0;Break==0;i++){
	  Sleep(SEND_WAIT);
	  if(FUNC_TYPE==0)	stat=_TDSCommStatus(Fd,0);
	  else			stat=_TDSUDrvStatus(Fd,0);
	  if(stat==3){
	    if((rtn=SendS6F11())	< 0){
	      PE,"(E) Send error (%d)\n",rtn);	Sleep(ERROR_SLEEP);
	    }
	    if((i%SEND_NO)		==0)	Sleep(SEND_SLEEP);
        } }
	rtn=0;
      }
      if(rtn<(-999) || ((-900)<rtn && rtn<0)){
	PE,"(E) Send error (%d)\n"	,rtn);
  } } }

  if(SECS_MODE!=0){				// HSMS ̏ꍇAؒf
  // Deselect request ͍sȂBiSEMI ł HSMS-SS ɂāADeselect request
  // ͍sĂ͂ȂȂAƂĂBj
  //if(FUNC_TYPE==0)	rtn=_TDSCommSend(Fd,0x0800,0,0,0,0,0,0);
  //else		rtn=_TDSUDrvSend(Fd,0x0800,0,0,0,0,0,0);
  //if(rtn							< 0) goto Exit;
  //PO,"(E) Deselected\n");
    if(FUNC_TYPE==0)	rtn=_TDSCommSend(Fd,0x0900,0,0,0,0,0,0);
    else		rtn=_TDSUDrvSend(Fd,0x0900,0,0,0,0,0,0);
    if(rtn							< 0) goto Exit;
    PO,"(E) Separated\n");
  }

Exit:
  Finish=1;		Sleep(1000);
  if(Md>0)		_TDSMDMssgTerminate(Md,0);
  if(Fd>0){
    if(FUNC_TYPE==0)	_TDSCommClose(Fd,0);
    else		_TDSUDrvClose(Fd,0);
  } else		PE,"(E) Error (%d)\n",Fd);
}
