
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2018.  All rights reserved.
 */

/* ========================================================================== */
/*
 * ExTraceAP : Og[Xo͂`õTv
 *
 *  Sample.ini  TRCTHOSTATRCTPORT ݒ肷邱Ƃɂ TDS  TCP/IP 
 *  oʐMg[X擾AWo͂ɕ\B
 * 
 * N@
 *
 *   ExTraceAP [port#]
 *   ~~~~~~~~~~~~~~~~~
 *   port# : Og[Xo͂̒ʐMɎgp TCP/IP Port#
 *	     ȗ́A6000 (ȉɒ` PORT) gpB
 *
 *
 *  { AP gpɂ́ATDS s邽߂ .ini t@C (Sample.ini) 
 *  ȉ̃p[^ݒ肷KvB
 *
 *  TRCHOST = "127.0.0.1"	// { AP 삷zXg IP-Address
 *  TRCPORT = 6000		// ʐMɎgp TCP/IP  Port#
 *
 *  ʏ́A{`oNABasicIoACallbackIo NB
 *  (TDS gp`őNA{`oNĂ͉\)
 *  {`óACTRL-C ̓͂ŏIB
 *  {`o̓G[ȗĂB
 */
/* ========================================================================== */

#include		<stdio.h>
#include		<stdlib.h>
#include		<signal.h>

#if defined		WINDOWS
#include		<winsock2.h>
#include		<process.h>
#define			SOPTYPE		(const char*)
#define			SHUT_RDWR	SD_BOTH
#else
#include		<memory.h>
#include		<unistd.h>
#include		<fcntl.h>
#include		<pthread.h>
#include		<sys/socket.h>
#include		<netinet/in.h>
#include		<arpa/inet.h>
#define			SOPTYPE		(const void*)
#define			closesocket(x)	close(x)
#endif


#define			PORT		6000

#define			PO		fprintf(stdout
#define			PE		fprintf(stderr


// -----------------------------------------------------------------------------

static void		Usage		();

int			Port=PORT;
int			Break=0,Cd=0;


// =============================================================================
// ʊ֐ --------------------------------------------------------------------

#if !defined	WINDOWS
static void*
_beginthread(
void*			(*func)(void*),
int			stacksz,
void			*par)
{
  pthread_t		th;
  pthread_attr_t	ta;

  if(pthread_attr_init(&ta)				==0){
    pthread_attr_setdetachstate(&ta,PTHREAD_CREATE_DETACHED);
    if(stacksz>0) pthread_attr_setstacksize(&ta,stacksz);
    pthread_attr_destroy(&ta);
  }
  return((void*)pthread_create(&th,&ta,func,par));
}



static void
Sleep(
int			msec)
{
  struct timespec	itimer,otimer;

  itimer.tv_sec =(msec/1000);
  itimer.tv_nsec=(msec%1000)*1000*1000;
  nanosleep(&itimer,&otimer);
}
#endif


// =============================================================================
// Signal handlers -------------------------------------------------------------

static void
ServerStop(
int			vec)
{
  Break=1;
  closesocket(Cd);
  exit(0);
}



// =============================================================================
// Trace message server function thread ----------------------------------------

#if defined	WINDOWS
static void
#else
static void*
#endif
TraceThread(
void			*param)
{
  char			host[64],str[2048];
  int			seq,sd,len,xlen,alen,mlen,ok0,i;

  sscanf((char*)param,"%d,%d,%s",&seq,&sd,host);	
  xlen=sizeof(str)-1;			// ȍ~ param ͎gpsƂȂ

  for(alen=0;;){
    if(Break						!=0)	break;
    if((len=recv(sd,&str[alen],xlen-alen,0))		<=0)	break;

    for(ok0=-1,i=0;ok0<0 && i<len;i++){	// '\n' 擾܂ str ɂߍށB
      if(str[alen+i]=='\n')	ok0=i;	// ʐMg[X sizeof(str)
    }      				// ȉƂOB

    if(ok0< 0)	alen+=len;		// '\n' Ȃ
    else{				// '\n' 
      str[alen+ok0]='\0';		// I[肵
      PO,"[%2d.%3d] %s\n",seq,sd,str);	// Wo͂ɕ\
      if((mlen=len-ok0-1)	> 0)	memcpy(str,&str[alen+ok0+1],mlen);
      alen=mlen;			// '\n' ̌̎c str ̐擪
  } }					// ړāA recv() ɔ

  closesocket(Cd);
}



// =============================================================================
// Main function ---------------------------------------------------------------

int
main(
int			argc,
char			*argv[])
{
  struct sockaddr_in	ladd,radd;
  char			runs[256],*add;
  unsigned long		pnobio=0;
  int			sd,seq,len,ru=1,i;

  for(i=1;i<argc;i++){
    if      (argv[i][0]=='-'){
      switch(argv[i][1]){
	case 'h': Usage();					break;
	case 'p': sscanf(argv[++i],"%d",&Port);			break;
  } } }

  signal(SIGTERM,ServerStop);
  signal(SIGINT ,ServerStop);

  memset(&ladd,0,sizeof(ladd));
  ladd.sin_family=AF_INET;
  ladd.sin_addr.s_addr=INADDR_ANY;
  ladd.sin_port=htons((unsigned short)Port);

  #if defined		WINDOWS
  { WSADATA		wsadata;
    WSAStartup(MAKEWORD(2,2),&wsadata);
  }
  #endif

  if((Cd=(int)socket(AF_INET,SOCK_STREAM,0))		< 0)	goto Exit;
  setsockopt(Cd,SOL_SOCKET,SO_REUSEADDR,SOPTYPE(&ru),sizeof(ru));
  if(bind   (Cd,(struct sockaddr*)(&ladd),sizeof(ladd))	< 0)	goto Exit;
  if(listen (Cd,4)					< 0)	goto Exit;
  PO,"INITIALIZED Port=%d Cd=%d\n",Port,Cd);

  for(seq=0;;seq++){
    memset(&radd,0,sizeof(radd));	len=sizeof(radd);
    if((sd=(int)accept(Cd,(struct sockaddr*)(&radd),&len))< 0)	goto Exit;
    #if defined		WINDOWS
    ioctlsocket	(sd,FIONBIO,&pnobio);
    #else
    fcntl	(sd,F_SETFL,0);
    #endif
    add=inet_ntoa(radd.sin_addr);

    PO,"CONNECTED form %s [%d]\n",add,sd);
    sprintf(runs,"%d,%d,%s",seq,sd,add);
    PO,"RUN Thread parameter=%s\n",runs);
    _beginthread(TraceThread,0,runs);
    Sleep(300);			// Xbh runs ͂邽߂̎ԂKv
  }				// X蔲łB

Exit:
  if(Cd>0) closesocket(Cd);
  return(0);
}



// -----------------------------------------------------------------------------

static void
Usage()
{
  PO,"\n");
  PO,"Usage: ExTraceAP [options...]\n");
  PO,"\n");
  PO,"  options  : Optional parameter\n");
  PO,"    -p port#   : TCP Port#                         [%d]\n"	,Port);
  PO,"\n");
  exit(22);
}
