
/*
/* Trust Design LLC : SECS/HSMS Communication library
/*
/* (c) Copyright Trust Design LLC.  2010-2012.  All rights reserved.
/*
/**/

#include	"stdafx.h"
#include	"EditList.h"


/////////////////////////////////////////////////////////////////////////////
// CEditList

IMPLEMENT_DYNAMIC(CEditList, CEdit)

CEditList::CEditList()
{
	m_uiVCode   = SB_ENDSCROLL;
	m_uiHCode   = SB_ENDSCROLL;
	m_iNowLines = 0;
	m_iMaxLines = 10000;
	m_iDelLines = 1000;
}



CEditList::~CEditList()
{
}



BEGIN_MESSAGE_MAP(CEditList, CEdit)
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CEditList bZ[W nh

void CEditList::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	m_uiVCode = nSBCode;
	CEdit::OnVScroll(nSBCode, nPos, pScrollBar);
}



void CEditList::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	m_uiHCode = nSBCode;
	CEdit::OnHScroll(nSBCode, nPos, pScrollBar);
}



/////////////////////////////////////////////////////////////////////////////

int CEditList::GetLineNum(char *str)		// str ̍s擾
{
	char			c0,c1;
	int				cnt,i;

	for(c0=str[0],cnt=i=1;;c0=c1,i++){
		if((c1=str[i])=='\0')		break;
		if(c0=='\r' && c1=='\n')	cnt++;
	}

	return cnt;
}



void CEditList::Init(int max, int del)
{
	m_iMaxLines = max;
	m_iDelLines = del;
	SetLimitText(0);
}



void CEditList::AddString(char *str)
{
	CString			buf;
	int				hpos, vpos, vlim, nl, lp, mp;

	SetRedraw(FALSE);
	hpos = GetScrollPos  (SB_HORZ);
	vpos = GetScrollPos  (SB_VERT);
	vlim = GetScrollLimit(SB_VERT);
	nl   = GetLineNum(str);

	if(m_iNowLines == 0) buf.Format("%s"    , str);
	else                 buf.Format("\r\n%s", str);

	lp=GetWindowTextLength();
	SetSel(lp, lp);
	ReplaceSel(buf);
	m_iNowLines=GetLineCount();
	if(vpos == vlim) LineScroll(nl, 0);

	if(m_uiHCode==SB_ENDSCROLL && m_uiVCode==SB_ENDSCROLL){		// XN[łȂ
		if((mp=((m_iNowLines-m_iMaxLines+(m_iDelLines-1))/m_iDelLines))	> 0){
			if((lp=LineIndex(m_iDelLines*mp))	>0){
				SetSel(0, lp-1);
				ReplaceSel("");
				m_iNowLines -= (m_iDelLines*mp);
	}	}	}
	SetRedraw(TRUE);
}

