
//
// Trust Design LLC : SECS/HSMS Communication library
//
// (c) Copyright Trust Design LLC.  2010-2019.  All rights reserved.
//

#pragma once

#include	"TDS.h"


class		CTDSSample2Proc					// TDS I/F NX
{
public:
  int		m_Fd;							// ʐMpʎq
  int		m_Md;							// bZ[W͗pʎq
  int		m_Status;						// 
											// (0:ڑ 1:Select 2:Select)
  int		m_OType;						// ^Cv       (0:u    1:zXg)
  int		m_Stop0;						// SECSMIw
  int		m_Stop1;						// AMIw
  int		m_CRun;							// AMw (0:w  1:w)
  int		m_CRunP;						// AM (0:s  1:s)
  CWinThread		*m_Thread0;				// SECSMXbh
  CWinThread		*m_Thread1;				// AMXbh
  CRITICAL_SECTION	m_cs0;					// IbNp 
  CRITICAL_SECTION	m_cs1;					// \bNp

			CTDSSample2Proc	();				// RXgN^
			~CTDSSample2Proc();	

  int		CBRecv			(void *par, TDSCBData *cbd);	// Mp Callback
  int		CBSend			(void *par, TDSCBData *cbd);	// Mp Callback

  int		Initialize		(int type);			// TDS 
  int		Terminate		();					// TDS I
  int		GetStatus		();					// ݏԎ擾
  int		GetCRun			();					// AMԎ擾

  int		SendS1F1		();							// S1F1			Mv
  int		SendS1F2H		(int did, unsigned int xid);// S1F2 (zXg)	:
  int		SendS1F2E		(int did, unsigned int xid);// S1F2 (u)		:
  int		SendS2F49		();							// S2F49(zXg)	:
  int		SendS2F50		(int did, unsigned int xid);// S2F50(u)		:
  int		SendS6F11		();							// S6F11(u)		:
  int		SendS6F12		(int did, unsigned int xid);// S6F12(zXg)	:
  int		SendNamedMssg	(char* name);				// CӖ̃bZ[WM

  void		ContRecvStart	();					// MssgMJnw
  void		ContRecvStop	();					// MssgMIw
  void		ContSendStart	();					// AMJnw
  void		ContSendStop	();					// AMIw

  int		DispData		(int type, TDSECSHead *hd, void *msg, int len, int rtn);
  void		DispSECSMssg	(int type, TDSECSHead *hd, void *msg, int len);
};
