
/*
 * Trust Design LLC : SECS/HSMS Communication library
 *
 * (c) Copyright Trust Design LLC.  2010-2019.  All rights reserved.
 */

#if !defined	__TDS__
#define		__TDS__


#include	"TDL.h"


// =============================================================================
// Header contents -------------------------------------------------------------

#define		E_NOTCONNECT	999
#define		E_DESELECT	998
#define		E_REJECT	997
#define		E_SELECT	992
#define		E_CONNECT	991
#define		E_NOMSSGTO	990
#define		E_RETRYOVER	989
#define		E_T8TIMEDOUT	988
#define		E_T7TIMEDOUT	987
#define		E_T6TIMEDOUT	986
#define		E_T5TIMEDOUT	985
#define		E_T4TIMEDOUT	984
#define		E_T3TIMEDOUT	983
#define		E_T2TIMEDOUT	982
#define		E_T1TIMEDOUT	981
#define		E_ILLBLOCK	980
#define		E_CONN_ERR	961
#define		E_NODATA	951


#define		TDS_LST		000
#define		TDS_BIN		010
#define		TDS_LOG		011
#define		TDS_ASC		020
#define		TDS_JIS		021
#define		TDS_KAN		022
#define		TDS_S8		030
#define		TDS_S1		031
#define		TDS_S2		032
#define		TDS_S4		034
#define		TDS_F8		040
#define		TDS_F4		044
#define		TDS_U8		050
#define		TDS_U1		051
#define		TDS_U2		052
#define		TDS_U4		054


#define		TDS_SIZE_LEN	4
#define		TDS_HEAD_LEN	10
#define		TDS_XBF		65536



// -----------------------------------------------------------------------------

#define		_TDSCommUserComment(a,b,c)	\
		_TDSCommSendComment(a,b,c,__FILE__,__LINE__)
#define		_TDSUDrvUserComment(a,b,c)	\
		_TDSUDrvSendComment(a,b,c,__FILE__,__LINE__)


// -----------------------------------------------------------------------------
// For lower compatible --------------------------------------------------------

#define		_TDSSMMssgInitialize	_TDSMDMssgInitialize
#define		_TDSSMMssgTerminate	_TDSMDMssgTerminate
#define		_TDSSMMssgInit		_TDSMDMssgInit
#define		_TDSSMMssgEnd		_TDSMDMssgEnd
#define		_TDSSMMssgBuild		_TDSMDMssgBuild
#define		_TDSSMMssgFind		_TDSMDMssgFind
#define		_TDSSMMssgExit		_TDSMDMssgExit
#define		_TDSSMMssgNext		_TDSMDMssgNext
#define		_TDSSMMssgNextL		_TDSMDMssgNextL
#define		_TDSSMMssgAutoRes	_TDSMDMssgAutoRes

#define		_TDSTSMssgInitialize(a,b,c)	\
					_TDSMDMssgInitialize(a|0x02,b,c)
#define		_TDSTSMssgTerminate	_TDSMDMssgTerminate
#define		_TDSTSMssgInit		_TDSMDMssgInit
#define		_TDSTSMssgEnd		_TDSMDMssgEnd
#define		_TDSTSMssgBuild		_TDSMDMssgBuild
#define		_TDSTSMssgFind		_TDSMDMssgFind
#define		_TDSTSMssgExit		_TDSMDMssgExit
#define		_TDSTSMssgNext		_TDSMDMssgNext
#define		_TDSTSMssgNextL		_TDSMDMssgNextL
#define		_TDSTSMssgAutoRes	_TDSMDMssgAutoRes


// =============================================================================
// Specify data structure ------------------------------------------------------

#if defined	__cplusplus
extern "C" {
#endif


// Data structures -------------------------------------------------------------

typedef union{
  TDLI08        sc[TDS_XBF];
  TDLU08        uc[1];
  TDLI16        ss[1];
  TDLU16        us[1];
  TDLI32        si[1];
  TDLU32        ui[1];
  TDLI64        sl[1];
  TDLU64        ul[1];
  TDLF32        fs[1];
  TDLF64        fl[1];
}               TDSAllType;



typedef struct  {
  TDLU16	did;		// DeviceID + Reverse bit
  TDLU08	scd;		// S Code   + Wait bit
  TDLU08	fcd;		// F Code
  TDLU08	ptp;		// P Type
  TDLU08	stp;		// S Type
				//  = 0 : Data Message
				//    1 : Select    Request
				//    2 : Select    Response
				//    3 : Deselect  Request
				//    4 : Deselect  Response
				//    5 : Link Test Request
				//    6 : Link Test Response
				//    7 : Reject    Request
				//    8 : <reserved>
				//    9 : Separate  Request
				//   10 : <reserved>
 TDLU16		sid;		// Source ID      (Upper System Byte)
 TDLU16		xid;		// Transaction ID (Lower System Byte)
				//  = 1 - 65535
}               TDSECSHead;


typedef struct  {
  int		vec;		// Callback type code  (1:Recv  2:Send cont.)
  int		req;		// Request code
  int		rtn;		// Return code
  int		devid;		// Device ID
  int		sf;		// SF Code
  unsigned int	xid;		// Transaction ID
  TDSECSHead	thd;		// SECS Message header
  char		*msg;		// SECS User message
}		TDSCBData;



typedef struct  {
  int		proc;		// Trace process code
  int		date;		// Trace date           (YYYYMMDD)
  int		time;		// Trace time           (hhmmss)
  int		msec;		// Trace mili seconnd   (999)
  char		*msg;		// Trace message
}		TDSTRData;


typedef struct{
  TDLU08	xmod[2];        // Extended processing mode
  TDLU08	xpr0[2];        // Extended processing parameter type0
  TDLU16	xpr1[2];        // Extended processing parameter type1
}		TDSXParam;



// =============================================================================
// Function prototypes ---------------------------------------------------------

TDLInt		_TDSCommOpen		(int,char*,char*
					,int (*cbr)(void*,TDSCBData*),void*
					,int (*cbs)(void*,TDSCBData*),void*
					,int (*trc)(void*,TDSTRData*),void*);
TDLInt		_TDSCommOpen0		(int,char*,char*);
TDLInt		_TDSCommClose		(int,int);
TDLInt		_TDSCommRecv		(int,int,int*,int*,unsigned int*,void*
					,int,TDSECSHead*);
TDLInt		_TDSCommSend		(int,int,int ,int ,unsigned int ,void*
					,int,TDSECSHead*);
TDLInt		_TDSCommSendError	(int,int,int ,int ,TDSECSHead*
					,TDSECSHead*,void*);
TDLInt		_TDSCommSendComment	(int,int,char*,char*,int);
TDLInt		_TDSCommStatus		(int,int);
TDLInt		_TDSCommSelectStatus	(int,int,int);
TDLVoid		_TDSCommTrcComment	(int,int,char*);
TDLVoid		_TDSCommTrcAcb		(int,int,char*);

TDLInt		_TDSCommAcb		(int,int,void**);
TDLInt		_TDSCommAcbParam	(int,int,int,void*,int,int);

TDLInt		_TDSErrorValue		(int);
TDLInt		_TDSErrorPosition	(int);
TDLVoid		_TDSErrorStatus		(int,int*,int*);
TDLInt		_TDSMssgErrorValue	(int);
TDLInt		_TDSMssgErrorPosition	(int);
TDLVoid		_TDSMssgErrorStatus	(int,int*,int*);

TDLInt		_TDSMssgAcb		(int,int,void**);
TDLInt		_TDSMssgAcbParam	(int,int,int,void*,int,int);
TDLInt		_TDSMssgInit		(int,void*,int,int);
TDLInt		_TDSMssgEnd		(int,int,void*);
TDLInt		_TDSMssgBuild		(int,int,void*,int,int,void*);
TDLInt		_TDSMssgBuildL		(int,int,void*,char*);
TDLInt		_TDSMssgFind		(int,void*,int,int,TDSECSHead*,char*);
TDLInt		_TDSMssgExit		(int,int,void*);
TDLInt		_TDSMssgNext		(int,int,void*,int*,int*,int*,void*,int);
TDLInt		_TDSMssgNextL		(int,int,void*,int*,int*,char*,int);

TDLInt		_TDSMDMssgTrimComment	(char*,char*,int);
TDLInt		_TDSMDMssgInitialize	(int,int,char*);
TDLVoid		_TDSMDMssgTerminate	(int,int);
TDLInt		_TDSMDMssgTableDump	(int,int,FILE*);
TDLInt		_TDSMDMssgInit		(int,int,void*,int,char*);
TDLInt		_TDSMDMssgEnd		(int,int,void*);
TDLInt		_TDSMDMssgBuild		(int,int,void*,char*,int,void*);
TDLInt		_TDSMDMssgFind		(int,int,void*,int,int,char*);
TDLInt		_TDSMDMssgExit		(int,int,void*);
TDLInt		_TDSMDMssgNext		(int,int,void*,char*,int,void*);
TDLInt		_TDSMDMssgNextEx	(int,int,void*,char*,int,void*
					,int*,int*);
TDLInt		_TDSMDMssgNextL		(int,int,void*,int*,int*,char*,int);
TDLInt		_TDSMDMssgAutoRes	(int,int,TDSECSHead*,void*,int,int
					,char*,char*,int*);
TDLInt		_TDSMDMssgAcb		(int,int,void**);
TDLInt		_TDSMDMssgAcbParam	(int,int,int,void*,int,int);

TDLInt		_TDSUDrvOpen		(int,char*,char*,int);
TDLInt		_TDSUDrvClose		(int,int);
TDLInt		_TDSUDrvRecv		(int,int,int*,int*,unsigned int*,void*
					,int,TDSECSHead*);
TDLInt		_TDSUDrvSend		(int,int,int ,int ,unsigned int ,void*
					,int,TDSECSHead*);
TDLInt		_TDSUDrvSendError	(int,int,int ,int ,TDSECSHead*
					,TDSECSHead*,void*);
TDLInt		_TDSUDrvSendComment	(int,int,char*,char*,int);
TDLInt		_TDSUDrvStatus		(int,int);
TDLInt		_TDSUDrvSelectStatus	(int,int,int);

TDLVoid		_TDSTOut		(int,char*,...);

#if defined	__cplusplus
}
#endif
#endif
