
//
// Trust Design LLC : SECS/HSMS Communication library
//
// (c) Copyright Trust Design LLC.  2010-2020.  All rights reserved.
//


// =============================================================================
//
// BasicIo : Test and sample program
//
//  Construct a message in AP and simply send and receive SECS messages.
// 
//
// Starting method
//
//   BasicIo {h|e}
//   ~~~~~~~~~~~~~
//   h    : Refer to [HOST]  section of Sample.ini to determine operation
//   e    : Refer to [EQUIP] section of Sample.ini to determine operation
//
//
//   Normally, "BasicIo h" and "BasicIo e" both operate on same machine or
//   different machines to communicate with each other.
//
//   After startup, it refers to the menu display, inputs request codes (0,1,2),
//   etc., and executes functions such as receiving a message from the other
//   side and sending a message to the other side.
//
//   Execute functions such as receiving a message or sending a message to the
//   other side. Host side and equipment side do not use Callback function but
//   perform Receive processing according to request code.
//   When using a message definition file, message is sent out by defining it in
//   message definition file and specifying an arbitrary message name.
// 
//   When host starts up, it waits for a connection from equipment.
//   When equipment side is started, connection request and Select request are
//   automatically issued to host side. On host side, repeat "1:Recv" processing,
//   and confirm that display is "STATUS = 951: No data".  After that, exchange
//   any message. On receiving side, do not forget to reap received data until
//   "STATUS = 951".
//
//   The transaction ID used when sending secondary message uses that of primary
//   message received immediately before.
//
//   This sample omits some of abnormal processing.
//
//   The following "SECS_MODE" is defined to use _TDSCommXxxx() as processing
//   function and to judge whether or not connection processing to Passive side
//   in case of Active connection is performed.
//   In this sample, operation on eqipment side is assumed to be Active
//   operation.
//   (Note) Changing this value alone does not make TDS aware of the change in
//      SECS1 or HSMS.  TDS determines SECS1 or HSMS based on the setting of
//      SECSMODE in the configuration file (.ini).  To change this value, you
//      must change the setting of SECSMODE in .ini.
//
//   The following "FUNC_TYPE" is defined to select type of processing function
//   to be used.
//   When using _TDSUDrvXxxx(), there is no need to perform connection
//   processing for HSMS-SS Active connection, so there is no need to set
//   "SECS_MODE" in principle.
//   TDS switches SECS-1 connection or HSMS connection in setting file (.ini).
//   When _TDSUDrvXxxx() is used, user AP is not necessary to know connection
//   method (SECS-1 or HSMS and  Passive or Active).
//   However, when using _TDSUDrvXxxx(), Callback processing needs to be
//   performed by itself.
//
//   By changing values of "MSSG_USE_FILE" and "MSSG_DISP_TYPE" defined below,
//   you can change output format of SECS message displayed by this AP.
//   By changing value of "MSSG_USE_NEXTL", it is possible to change whether to
//   acquire field values as data or display list format when analyzing message
//   contents.
//
//
// =============================================================================
//
// BasicIo : eXg y TvEvO
//
//  `oŃbZ[W\zAP SECS bZ[W̑MsB
// 
//
// N@
//
//   BasicIo {h|e}
//   ~~~~~~~~~~~~~
//   h    : Sample.ini  [HOST]  ZNVQƂ肷
//   e    : Sample.ini  [EQUIP]      :              :
//
//
//   ʏABasicIo h y BasicIo e ̗A}VA͈قȂ
//   }Vœ삳āAݒʐMsB
//
//   NAj\QƂAvR[h (0,1,2) ͂A葤
//   bZ[WMA葤փbZ[W𑗏o铙̋@\sB
//   zXgAu Callback ֐gpAReceive vR[h
//   ɉčsB
//   bZ[W`t@Cgpꍇ́AbZ[W`t@Cɒ`
//   Cӂ̃bZ[Ŵw肷邱ƂɂÃbZ[W𑗏oB
// 
//   zXg͋NƁAu̐ڑ҂BuNƁAI
//   ɃzXgɐڑvASelect v𔭍sBzXgł́A1:Recv 
//   JԂsA\uSTATUS=951 : No datavƂȂ̂mFB̌A
//   Cӂ̃bZ[ŴƂsBMł́AMf[^̊u
//   STATUS=951vɂȂ܂ōsƂYʂƁB
//
//   QbZ[W𑗐Mۂ̃gUNVhćAOɎMP
//   bZ[Ŵ̂gpB
//
//   {Tv́Aُ펞ꕔȗĂB
//
//   ȉŒ` "SECS_MODE" ́A֐Ƃ _TDSCommXxxx() gp
//   ꍇ Active ڑ̏ꍇ Passive ւ̐ڑ̎s̗L𔻒f
//   ߂ɒ`B
//   ȂA{Tv́Auł̓ Active Ɖ肵ĂB
//   () ̒l̕ύX TDS  SECS1 or HSMS ̕ύXF킯ł͂ȂB 
//      TDS  SECS1 or HSMS 𔻒f̂͐ݒt@C (.ini)  SECSMODE 
//      ݒɂ̂ŁA̒lύXꍇ .ini  SECSMODE ̐ݒύX
//      Ȃ΂ȂȂB
//
//   "FUNC_TYPE" ́Agp鏈֐̎ʂI邽߂ɒ`B
//   _TDSUDrvXxxx() gpꍇ́AHSMS-SS Active ڑ̏ꍇ̐ڑs
//   KvȂ̂ŁA{ł "SECS_MODE" ̐ݒKvȂB
//   TDS ́ASECS-1 ڑ or HSMS-SS ڑ̐ؑւ́Aݒt@C (.ini) ɂčs
//   ߁A֐Ƃ _TDSUDrvXxxx() gṕA[U`oł́A
//   ڑiSECS-1/HSMSS  HSMS-SS Passive/ActivejmKv
//   ȂB _TDSUDrvXxxx() gpꍇ́ACallback ͎͂ōs
//   KvB
//
//   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
//   ɂĕ\ SECS bZ[W̏o͌`ύXłB
//   "MSSG_USE_NEXTL" ̒lύXƁAbZ[We͂ۂɁAڒl
//   f[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
//
// =============================================================================

#include	"TDS.h"


#define		PO		fprintf(stdout
#define		PE		fprintf(stderr

#define		SECS_MODE	1		// SECS/HSMS mode
						// 0    : SECS1
						// 1    : HSMS
						// (Note) See comments above
						// () 㕔RgQ
#define		FUNC_TYPE	0		// Type of function used 
						// ʐMɎgp֐̎
						// 0    : _TDSCommXxxxx()
						// 1    : _TDSUDrvXxxxx()
#define		UDRV_MASK  	0x8383ffff	// Mask value for UDrvOpen()
						// 0          : Set =0x49
						// 0x8383ffff : All event

#define		MSSG_USE_FILE	0x80		// Message definition file
						// 0x00 : Not use
						// 0x80 : Use to display item
						//	  names
						//	  gpčږ\
#define		MSSG_DISP_TYPE	0x20		// SECS Message display format
						// 0x00 : TDS Format
						// 0x20 : SML Format
#define		MSSG_USE_NEXTL	1		// Use MssgNextL() or not
						// 0    : Not use
						// 1    : Use


#define		PARAMFILE	"Sample.ini"


static void	Host();
static void	Equip();



// =============================================================================
// Common functions ============================================================

#include	"SubFunctions.h"



// =============================================================================
// Main process ----------------------------------------------------------------

int
main(
int			argc,
char			*argv[])
{
  if(argc<2 || (argv[1][0]!='h' && argv[1][0]!='e')){
    PE,"Usage: %s {host|equip}\n"	,argv[0]);		exit(1);
  }
//InitializeCriticalSection(&Cs0);
  InitializeCriticalSection(&Cs1);

  if(argv[1][0]=='h')	Host ();
  else			Equip();

//DeleteCriticalSection(&Cs0);
  DeleteCriticalSection(&Cs1);
  exit(0);
}



// =============================================================================
// Host side process -----------------------------------------------------------

static void
Host()
{
  TDSECSHead		hd;
  char			msg[1024],mname[64];
  unsigned int		xid,xids=0;
  int			did,dids=0;
  int			req,rtn,msz,mno;

  msz=sizeof(msg);
  if(FUNC_TYPE==0)	Fd=_TDSCommOpen(0x02,PARAMFILE,"HOST",0,0,0,0,0,0);
  else			Fd=_TDSUDrvOpen(0x02,PARAMFILE,"HOST",UDRV_MASK);
  if(Fd								< 0) goto Exit;
  PO,"(H) Opened (%d)\n",Fd);
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);

  for(;;){
    PE,"Req (0:Exit 1:Recv 2:Send) : ");	scanf("%d",&req);
    if      (req==0){						break;

    }else if(req==1){
      if(FUNC_TYPE==0)	rtn=_TDSCommRecv(Fd,0,&did,0,&xid,msg,msz,&hd);
      else		rtn=_TDSUDrvRecv(Fd,0,&did,0,&xid,msg,msz,&hd);
      if(rtn	>=0){	dids=did;	xids=xid;}
      DispData(1,&hd,msg,rtn,rtn);

    }else if(req==2){
      PE,"Message(1:S1F1 2:S2F49   6:S1F2 7:S6F12   9:Any) : ");
      scanf("%d",&mno);
      switch(mno){
	case 1: rtn=SendS1F1 ();			break;
	case 2: rtn=SendS2F49();			break;
	case 6: rtn=SendS1F2H(dids,xids);		break;
	case 7: rtn=SendS6F12(dids,xids);		break;
	case 9: if((MSSG_USE_FILE&0x80)!=0){
		  PE,"Message Name : ");	scanf("%s",mname);
		  rtn=SendNamedMssg(dids,xids,mname);
		}					break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      PE,"(H) I/O Error (%d)\n",	rtn);
  } }

Exit:
  if(Fd> 0){
    if(FUNC_TYPE==0)	_TDSCommClose(Fd,0);
    else		_TDSUDrvClose(Fd,0);
  }else			PE,"(H) Error (%d)\n",Fd);
  if(Md> 0)		_TDSMDMssgTerminate(Md,0);
}



// =============================================================================
// Equipment side process ------------------------------------------------------

static void
Equip()
{
  TDSECSHead		hd;
  char			msg[1024],mname[64];
  unsigned int		xid,xids=0;
  int			did,dids=0;
  int			req,rtn,msz,mno;

  msz=sizeof(msg);
  if(FUNC_TYPE==0)	Fd=_TDSCommOpen(0x02,PARAMFILE,"EQUIP",0,0,0,0,0,0);
  else			Fd=_TDSUDrvOpen(0x02,PARAMFILE,"EQUIP",UDRV_MASK);
  if(Fd								< 0) goto Exit;
  PO,"(E) Opened (%d)\n",Fd);
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);
  if(SECS_MODE!=0 && FUNC_TYPE==0){	// In case of HSMS and use TDSCommXxxxx()
					// HSMS  TDSComm gp̏ꍇ
    if(_TDSCommSend(Fd,0x0100,0,0,0,0,0,0)			< 0) goto Exit;
    PO,"(E) Connected\n");
    if(_TDSCommSend(Fd,0x0200,0,0,0,0,0,0)			< 0) goto Exit;
    PO,"(E) Selected\n");
  }

  for(;;){		rtn=0;
    PE,"Req (0:Exit 1:Recv 2:Send) : ");	scanf("%d",&req);
    if      (req==0){						 break;

    }else if(req==1){
      if(FUNC_TYPE==0)	rtn=_TDSCommRecv(Fd,0,&did,0,&xid,msg,msz,&hd);
      else		rtn=_TDSUDrvRecv(Fd,0,&did,0,&xid,msg,msz,&hd);
      if(rtn	>=0){	dids=did; xids=xid;}
      DispData(1,&hd,msg,rtn,rtn);

    }else if(req==2){
      PE,"Message(1:S1F1 2:S6F11   6:S1F2 7:S2F50   9:Any) : ");
      scanf("%d",&mno);
      switch(mno){
	case 1: rtn=SendS1F1 ();			break;
	case 2: rtn=SendS6F11();			break;
	case 6: rtn=SendS1F2E(dids,xids);		break;
	case 7: rtn=SendS2F50(dids,xids);		break;
	case 9: if((MSSG_USE_FILE&0x80)!=0){
		  PE,"Message Name : ");	scanf("%s",mname);
		  rtn=SendNamedMssg(dids,xids,mname);
		}					break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      PE,"(E) I/O Error (%d)\n",	rtn);
  } }

  if(SECS_MODE	!=0){			// In case of HSMS, Shutdown process
					// HSMS ̏ꍇAؒf
    if(FUNC_TYPE==0)	rtn=_TDSCommStatus(Fd,0);
    else		rtn=_TDSUDrvStatus(Fd,0);
    if(rtn	==3){
    // Deselect request is not performed. (Of course you may go. However SEMI
    // claims that HSMS-SS does not perform Deselect request.)
    // Deselect request ͍sȂB (sĂ悢BSEMI ł HSMS-SS
    // ɂāADeselect request ͍sȂAƂĂB)
    //if(FUNC_TYPE==0)	rtn=_TDSCommSend(Fd,0x0800,0,0,0,0,0,0);
    //else		rtn=_TDSUDrvSend(Fd,0x0800,0,0,0,0,0,0);
    //if(rtn							< 0) goto Exit;
    //PO,"(E) Deselected\n");
      if(FUNC_TYPE==0)	rtn=_TDSCommSend(Fd,0x0900,0,0,0,0,0,0);
      else		rtn=_TDSUDrvSend(Fd,0x0900,0,0,0,0,0,0);
      if(rtn							< 0) goto Exit;
      PO,"(E) Separate\n");
  } }

Exit:
  if(Fd> 0){
    if(FUNC_TYPE==0)	_TDSCommClose(Fd,0);
    else		_TDSUDrvClose(Fd,0);
  }else			PE,"(E) Error (%d)\n",Fd);
  if(Md> 0)		_TDSMDMssgTerminate(Md,0);
}
