
//
// Trust Design LLC : SECS/HSMS Communication library
//
// (c) Copyright Trust Design LLC.  2010-2020.  All rights reserved.
//


// =============================================================================
//
// CallbackIo : Test and sample program
//
//  Respond to received messages using Callback function. Also, the
//  user-defined trace output function is used to perform trace output by itself.
//
//
// Starting method
//
//   CallbackIo {h|e}
//   ~~~~~~~~~~~~~~~~
//   h    : Refer to [HOST]  section of Sample.ini to determine operation
//   e    : Refer to [EQUIP] section of Sample.ini to determine operation
//
//
//   Normally, "CallbackIo h" and "CallbackIo e" both operate on same machine or
//   different machines to communicate with each other.
//
//   After startup, refer to the menu display, enter request code (0,2,3) etc.
//   and execute functions such as sending a message to the other side.
//
//   The received message and various event information complete processing in
//   Callback function. When following "MSSG_USE_FILE" is set to 0x80, secondary
//   message corresponding to received primary message is automatically sent
//   according to contents of message definition file Sample.sml set in
//   Sample.ini.
//   When MSSG_USE_FILE=0x80 (using a message definition file), message is sent
//   out by specifying name of any message defined in message definition file.
//
//   Continuous sending and receiving is performed at a fixed interval
//   (specified by SEND_WAIT) according to request code.
//   Continuous sending and receiving is terminated by input of CTRL-C.
//   In this case, sending of primary message and sending of secondary message
//   may occur simultaneously. When creating a send message using a message
//   definition file, in this sample, only one descriptor for message analysis
//   is prepared. Therefore, it is necessary to perform lock control so that
//   message construction in sending processing and reply processing does not
//   collide. See top of SunFunctions.h for details.
// 
//   This sample omits some of abnormal processing.
//
//   The following "SECS_MODE" is defined to use _TDSCommXxxx() as a processing
//   function and to judge whether or not connection processing to Passive side
//   in case of Active connection is performed.
//   In this sample, operation on eqipment side is assumed to be  Active
//   operation.
//   (Note) Changing this value alone does not make TDS aware of the change in
//      SECS1 or HSMS.  TDS determines SECS1 or HSMS based on the setting of
//      SECSMODE in the configuration file (.ini).  To change this value, you
//      must change the setting of SECSMODE in .ini.
//
//   The following "FUNC_TYPE" is defined to select type of processing function
//   to be used.
//   When using _TDSUDrvXxxx(), there is no need to perform connection
//   processing for HSMS-SS Active connection, so there is no need to set
//   "SECS_MODE" in principle.
//   TDS switches SECS-1 connection or HSMS connection in setting file (.ini).
//   When _TDSUDrvXxxx() is used, user AP is not necessary to know connection
//   method (SECS-1 or HSMS and  Passive or Active).
//   However, when using _TDSUDrvXxxx(), Callback processing needs to be
//   performed by itself.
//
//   By changing values of "MSSG_USE_FILE" and "MSSG_DISP_TYPE" defined below,
//   you can change output format of SECS message displayed by this AP.
//   By changing value of "MSSG_USE_NEXTL", it is possible to change whether to
//   acquire field values as data or display list format when analyzing message
//   contents.
//   Similarly, changing value of "USE_USER_TRACE" can change use of Callback
//   for User Trace output.
//
//
// =============================================================================
//
// CallbackIo : eXg y TvEvO
//
//  Callback ֐gpĎMbZ[Wɑ΂鉞sB܂A[U
//  `g[Xo͊֐gpAg[Xo͂͂ōsB
//
//
// N@
//
//   CallbackIo {h|e}
//   ~~~~~~~~~~~~~~~~
//   h    : Sample.ini  [HOST]  ZNVQƂ肷
//   e    : Sample.ini  [EQUIP]      :              :
//
//
//   ʏACallbackIo h y CallbackIo e ̗A}VA͈قȂ
//   }Vœ삳āAݒʐMsB
//
//   NAj\QƂAvR[h (0,2,3) ͂āA葤Ƀb
//   Z[W𑗏o铙̋@\sB
//   MbZ[WAyъeCxg Callback ֐̒ŏ
//   BL "MSSG_USE_FILE"  0x80 ɐݒ肷ƁASample.ini Őݒ肵
//   bZ[W`t@C Sample.sml ̓eɂAMPbZ[WɑΉ
//   QbZ[WoB
//   MSSG_USE_FILE=0x80ibZ[W`t@Cgpjꍇ́AbZ[W
//   `t@Cɒ`Cӂ̃bZ[Ŵ̖w肷邱ƂɂA
//   bZ[W𑗏oB
// 
//   vR[hɂAԊuiSEND_WAIT ɂĎwjł̘AMsB
//   AḾACTRL-C ̓͂ɂIB
//   ̏ꍇAPbZ[W̑MƁAQbZ[W̑Mɔ
//   \BbZ[W`t@CgpđMbZ[W쐬ꍇA
//   {Tvł́AbZ[W͗p̃fXNv^͂PpӂĂȂ
//   ŁAMAԐMł̃bZ[W\zobeBOȂ悤ɃbN
//   KvBڍׂ SunFunctions.h ̐擪QƂ邱ƁB
// 
//   {Tv́Aُ펞ꕔȗĂB
//
//   ȉŒ` "SECS_MODE" ́A֐Ƃ _TDSCommXxxx() gp
//   ꍇ Active ڑ̏ꍇ Passive ւ̐ڑ̎s̗L𔻒f
//   ߂ɒ`B
//   ȂA{Tv́Auł̓ Active Ɖ肵ĂB
//   () ̒l̕ύX TDS  SECS1 or HSMS ̕ύXF킯ł͂ȂB 
//      TDS  SECS1 or HSMS 𔻒f̂͐ݒt@C (.ini)  SECSMODE 
//      ݒɂ̂ŁA̒lύXꍇ .ini  SECSMODE ̐ݒύX
//      Ȃ΂ȂȂB
//
//   "FUNC_TYPE" ́Agp鏈֐̎ʂI邽߂ɒ`B
//   _TDSUDrvXxxx() gpꍇ́AHSMS-SS Active ڑ̏ꍇ̐ڑs
//   KvȂ̂ŁA{ł "SECS_MODE" ̐ݒKvȂB
//   TDS ́ASECS-1 ڑ or HSMS-SS ڑ̐ؑւ́Aݒt@C (.ini) ɂčs
//   ߁A֐Ƃ _TDSUDrvXxxx() gṕA[U`oł́A
//   ڑiSECS-1/HSMS-SS  HSMS-SS Passive/ActivejmKv
//   ȂB _TDSUDrvXxxx() gpꍇ́ACallback ͎͂ōs
//   KvB
//
//   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
//   ɂĕ\ SECS bZ[W̏o͌`ύXłB
//   "MSSG_USE_NEXTL" ̒lύXƁAbZ[We͂ۂɁAڒl
//   f[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
//   l "USE_USER_TRACE" ̒lύXƁAUser Trace o͗p Callback 
//   gp̗LύXłB
//
// =============================================================================

#include	"TDS.h"


#define		PO		fprintf(stdout
#define		PE		fprintf(stderr

#define		SECS_MODE	1		// SECS/HSMS mode
						// 0    : SECS-1
						// 1    : HSMS
						// (Note) See comments above
						// () 㕔RgQ
#define		FUNC_TYPE	0		// Type of function used
						// ʐMɎgp֐̎
						// 0    : _TDSCommXxxxx
						// 1    : _TDSUDrvXxxxx
#define		UDRV_MASK  	0x8383ffff	// Mask value for UDrvOpen()
						// 0          : Set =0x49
						// 0x8383ffff : All event

#define		MSSG_USE_FILE	0x80		// Message definition file
						// 0x00 : Not use
						// 0x80 : Use to display item
						//	  names
						//	  gpčږ\
#define		MSSG_DISP_TYPE	0x20		// SECS Message display format
						// 0x00 : TDS Format
						// 0x20 : SML Format
#define		MSSG_USE_NEXTL	1		// Use MssgNextL() or not
						// 0    : Not use
						// 1    : Use
#define		USE_SEND_CB	1		// Use CB for sending result
						// MʎMp Callback gp
						// 0	: Not Use
						// 1	: Use
#define		USE_USER_TRACE	0		// Use User trace call back
						// function or not
						// UserTracepCB gp邩ۂ
						// 0    : Not use
						// 1    : Use

#define		SEND_WAIT	2000		// Message sending interval(ms)
						// bZ[WMԊu      (mb)
#define		SEND_NO		10		// Number of times until message
						// sending off
						// bZ[WMx݂܂ł̉
#define		SEND_SLEEP	10000		// Wait time		   (ms)
						// xݎ              (mb)
#define		ERROR_SLEEP	10000		// Wait time in error case (ms)
						// G[xݎ  (mb)

#define		PARAMFILE	"Sample.ini"

static int	Finish=0;	// End instruction to thread
				// Xbhւ̏Iw


static void	Host();
static void	Equip();



// =============================================================================
// Common functions ============================================================

#include	"SubFunctions.h"



// =============================================================================
// Receive Callback processing thread (for _TDSUDrvRecv()) ---------------------
// M Callback pXbh (_TDSUDrvRecv() p) ----------------------------

#if defined	WINDOWS
static void
#else
static void*
#endif
RecvProcThread(
void			*par)
{
  TDSCBData		cbd;
  char			msg[1024];
  int			msz;

  cbd.vec=1;		cbd.msg=msg;
  msz=sizeof(msg);

  for(;Finish==0;){
    cbd.rtn=_TDSUDrvRecv(Fd,0,&cbd.devid,&cbd.sf,&cbd.xid,cbd.msg,msz,&cbd.thd);
    if(cbd.rtn	== -E_NODATA)	Sleep(100);
    else{
      if((-1000)<cbd.rtn && cbd.rtn<(-959))	cbd.req=(-cbd.rtn)-900;
      else					cbd.req=0;
      CBRecv(par,&cbd);
  } }
}



// =============================================================================
// Main process ----------------------------------------------------------------

int
main(
int			argc,
char			*argv[])
{
  if(argc<2 || (argv[1][0]!='h' && argv[1][0]!='e')){
    PE,"Usage: %s {host|equip}\n"	,argv[0]);		exit(1);
  }

  signal(SIGINT,CBSignal);
//InitializeCriticalSection(&Cs0);
  InitializeCriticalSection(&Cs1);

  if(argv[1][0]=='h')	Host ();
  else			Equip();

//DeleteCriticalSection(&Cs0);
  DeleteCriticalSection(&Cs1);
  exit(0);
}



// =============================================================================
// Host side process -----------------------------------------------------------

static void
Host()
{
  int			(*cbtrace)(void*,TDSTRData*)=0;
  char			mname[64];
  int			req,rtn,mno,stat,i;

  if(USE_USER_TRACE!=0)	cbtrace=CBTrace;
  if(FUNC_TYPE==0){
    Fd=_TDSCommOpen(0x02,PARAMFILE,"HOST",CBRecv,0,CBSend,0,cbtrace,0);
  }else{
    Fd=_TDSUDrvOpen(0x02,PARAMFILE,"HOST",UDRV_MASK);
  }
  if(Fd								< 0) goto Exit;

	// Execute Callback processing by itself when using _TDSUDrvXxxx()
  	// _TDSUDrvXxxx() gp̏ꍇ Callback ͂Ŏs
  if(FUNC_TYPE!=0) _beginthread(RecvProcThread,0,0);

  PO,"(H) Opened (%d)\n",Fd);	OType=0;
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);

  for(;;){
    Sleep(500);
    req=99;	rtn=0;
    PE,"Req (0:Exit 2:Send 3:Continuous Send) : ");	scanf("%d",&req);
    if      (req==0){						break;
    }else if(req==2){
      PE,"Message(1:S1F1 2:S2F49   9:Any) : ");		scanf("%d",&mno);
      switch(mno){
	case 1: rtn=SendS1F1 ();				break;
	case 2: rtn=SendS2F49();				break;
	case 9: if((MSSG_USE_FILE&0x80)!=0){
		  PE,"Message Name : ");		scanf("%s",mname);
		  rtn=SendNamedMssg(0,0,mname);
		}						break;
      }
    }else if(req==3){
      for(Break=i=0;Break==0;i++){
	Sleep(SEND_WAIT);
	if(FUNC_TYPE==0)	stat=_TDSCommStatus(Fd,0);
	else			stat=_TDSUDrvStatus(Fd,0);
	if(stat==3){
	  if((rtn=SendS2F49())	< 0){
	    PE,"(H) Send error (%d)\n",rtn);	Sleep(ERROR_SLEEP);
	  }
	  if((i%SEND_NO)		==0)	Sleep(SEND_SLEEP);
      } }
      rtn=0;
    }
    if(rtn<(-999) || ((-900)<rtn && rtn<0) ){
      PE,"(H) Send error (%d)\n"	,rtn);
  } }

Exit:
  Finish=1;		Sleep(1000);
  if(Fd> 0){
    if(FUNC_TYPE==0)	_TDSCommClose(Fd,0);
    else		_TDSUDrvClose(Fd,0);
  }else			PE,"(H) Error (%d)\n",Fd);
  if(Md> 0)		_TDSMDMssgTerminate(Md,0);
}



// =============================================================================
// Equipment side process ------------------------------------------------------

static void
Equip()
{
  int			(*cbsend) (void*,TDSCBData*)=0;
  int			(*cbtrace)(void*,TDSTRData*)=0;
  char			mname[64];
  int			req,rtn,mno,stat,i;

  if(USE_SEND_CB   !=0)	cbsend =CBSend;
  if(USE_USER_TRACE!=0)	cbtrace=CBTrace;
  if(FUNC_TYPE==0){
    Fd=_TDSCommOpen(0x02,PARAMFILE,"EQUIP",CBRecv,0,cbsend,0,cbtrace,0);
  }else{
    Fd=_TDSUDrvOpen(0x02,PARAMFILE,"EQUIP",UDRV_MASK);
  }
  if(Fd								< 0) goto Exit;

	// Execute Callback processing by itself when using _TDSUDrvXxxx()
  	// _TDSUDrvXxxx() gp̏ꍇ Callback ͂Ŏs
  if(FUNC_TYPE!=0) _beginthread(RecvProcThread,0,0);

  PO,"(E) Opened (%d)\n",Fd);	OType=1;
  if((MSSG_USE_FILE&0x80)!=0) Md=_TDSMDMssgInitialize(0x4000,Fd,0);
  if(SECS_MODE!=0 && FUNC_TYPE==0){	// In case of HSMS and use TDSCommXxxxx()
					// HSMS  TDSComm gp̏ꍇ
    if(_TDSCommSend(Fd,0x0100,0,0,0,0,0,0)			< 0) goto Exit;
    printf("(E) Connected\n");
    if(_TDSCommSend(Fd,0x0200,0,0,0,0,0,0)			< 0) goto Exit;
    printf("(E) Selected\n");
  }

  for(;;){
    Sleep(500);
    req=99;	rtn=0;
    PE,"Req (0:Exit 2:Send 3:Continuous Send) : ");	scanf("%d",&req);
    if      (req==0){						break;
    }else if(req==2){
      PE,"Message(1:S1F1 2:S6F11   9:Any) : ");		scanf("%d",&mno);
      switch(mno){
	case 1: rtn=SendS1F1 ();				break;
	case 2: rtn=SendS6F11();				break;
	case 9: if((MSSG_USE_FILE&0x80)!=0){
		  PE,"Message Name : ");		scanf("%s",mname);
		  rtn=SendNamedMssg(0,0,mname);
		}						break;
      }
    }else if(req==3){
      for(Break=i=0;Break==0;i++){
	Sleep(SEND_WAIT);
	if(FUNC_TYPE==0)	stat=_TDSCommStatus(Fd,0);
	else			stat=_TDSUDrvStatus(Fd,0);
	if(stat==3){
	  if((rtn=SendS6F11())	< 0){
	    PE,"(E) Send error (%d)\n"	,rtn);	Sleep(ERROR_SLEEP);
	  }
	  if((i%SEND_NO)		==0)	Sleep(SEND_SLEEP);
      } }
      rtn=0;
    }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      PE,"(E) Send error (%d)\n"	,rtn);
  } }

  if(SECS_MODE	!=0){			// In case of HSMS, Shutdown process
					// HSMS ̏ꍇAؒf
    if(FUNC_TYPE==0)	rtn=_TDSCommStatus(Fd,0);
    else		rtn=_TDSUDrvStatus(Fd,0);
    if(rtn	==3){
    // Deselect request is not performed. (Of course you may go. However SEMI
    // claims that HSMS-SS does not perform Deselect request.)
    // Deselect request ͍sȂB (sĂ悢BSEMI ł HSMS-SS
    // ɂāADeselect request ͍sȂAƂĂB)
    //if(FUNC_TYPE==0)	rtn=_TDSCommSend(Fd,0x0800,0,0,0,0,0,0);
    //else		rtn=_TDSUDrvSend(Fd,0x0800,0,0,0,0,0,0);
    //if(rtn							< 0) goto Exit;
    //PO,"(E) Deselected\n");
      if(FUNC_TYPE==0)	rtn=_TDSCommSend(Fd,0x0900,0,0,0,0,0,0);
      else		rtn=_TDSUDrvSend(Fd,0x0900,0,0,0,0,0,0);
      if(rtn							< 0) goto Exit;
      PO,"(E) Separated\n");
  } }

Exit:
  Finish=1;		Sleep(1000);
  if(Fd> 0){
    if(FUNC_TYPE==0)	_TDSCommClose(Fd,0);
    else		_TDSUDrvClose(Fd,0);
  }else			PE,"(E) Error (%d)\n",Fd);
  if(Md> 0)		_TDSMDMssgTerminate(Md,0);
}
