
//
// Trust Design LLC : SECS/HSMS Communication library
//
// (c) Copyright Trust Design LLC.  2010-2020.  All rights reserved.
//


// =============================================================================
//
// JavaIo : Test and sample program
//
// In a pure Java environment using only TDSJava.jar without using JNA (and thus
// not using TDS.dll), use Callback function to handle incoming messages.
//
//
// Starting method
//
//   java JavaIo {h|e}
//   ~~~~~~~~~~~~~~~~~
//   h    : Refer to [HOST]  section of Sample.ini to determine operation
//   e    : Refer to [EQUIP] section of Sample.ini to determine operation
//
//
//   Normally, "JavaIo h" and "JavaIo e" both operate on same machine or
//   different machines to communicate with each other. The communication
//   partner may be BasicIo.exe or Callbackio.exe.
//
//   After startup, refer to the menu display, enter request code etc. and the
//   function is executed.
// 
//   When host starts up, it waits for a connection from equipment.
//   When device side is started, connection request and Select request are
//   automatically issued to host side.
//   On host side, repeat '1:Recv' processing, and confirm that display is
//   'STATUS=951: No data'. After that, exchange any message. On receiving side,
//   do not forget to reap received data until 'STATUS=951'.
//
//   The transaction ID used when sending secondary message uses that of primary
//   message received immediately before.
//
//   This sample omits some of abnormal processing.
//
//   "SECS_MODE" defined below is defined to determine whether or not connection
//   processing to Passive side in case of Active connection is performed when
//   using _TDSCommXxxx() as processing function.
//   (Note) Changing this value alone does not make TDS aware of the change in
//      SECS1 or HSMS.  TDS determines SECS1 or HSMS based on the setting of
//      SECSMODE in the configuration file (.ini).  To change this value, you
//      must change the setting of SECSMODE in .ini.  (SECS-1 is not supported
//      by TDSJava)
//
//   "FUNC_TYPE" is defined to select type of processing function to be used.
//   If you use _TDSUDrvXxxx(), there is no need to perform connection
//   processing for HSMS-SS Active connection, so there is no need to set
//   "SECS_MODE" in principle.
//   Since TDS switches SECS-1 connection or HSMS-SS connection in setting file
//   (.ini), user AP does not need to know connection method (SECS-1or HSMS and
//   Passive/Active at HSMS) as long as _TDSUDrvXxxx() is used as processing
//   function.
//
//   By changing values of "MSSG_USE_FILE" and "MSSG_DISP_TYPE" defined below,
//   you can change output format of SECS message displayed by this AP.
//   By changing value of "MSSG_USE_NEXTL", it is possible to change whether to
//   acquire field values as data or display list format when analyzing message
//   contents.
//   Similarly, if "USE_CALLBACK" is set to 1, use Callback function to perform
//   receiving processing, and automatically display received message and output
//   secondary message.
//   When using Callback function, keep in mind that input prompting message may
//   be disturbed.
//
//
// =============================================================================
//
// JavaIo : eXg y TvEvO
//
// JNA gpi] TDS.dll gpjTDSJava.jar ݂̂gp Java
// ̂œ Callback ֐gpĎMbZ[Wɑ΂鉞sB
//
//
// N@
//
//   java JavaIo {h|e}
//   ~~~~~~~~~~~~~~~~~
//   h    : Sample.ini  [HOST]  ZNVQƂ肷
//   e    : Sample.ini  [EQUIP]      :              :
//
//
//   ʏAJavaIo h y JavaIo e ̗A}VA͈قȂ}V
//   œ삳āAݒʐMsBʐḾABasicIo.exeACallbackio.exe ł
//   悢B
//
//   NAj\QƂAvR[h͂A@\sB
// 
//   zXg͋NƁAu̐ڑ҂BuNƁAI
//   ɃzXgɐڑvASelect v𔭍sBzXgł́A1:Recv 
//   JԂsA\uSTATUS=951 : No datavƂȂ̂mFB̌A
//   Cӂ̃bZ[ŴƂsBMł́AMf[^̊u
//   STATUS=951vɂȂ܂ōsƂYʂƁB
//
//   QbZ[W𑗐Mۂ̃gUNVhćAOɎMP
//   bZ[Ŵ̂gpB
//
//   {Tv́Aُ펞ꕔȗĂB
//
//   ȉŒ` "SECS_MODE" ́A֐Ƃ _TDSCommXxxx() gp
//   ꍇ Active ڑ̏ꍇ Passive ւ̐ڑ̎s̗L𔻒f
//   ߂ɒ`B
//   () ̒l̕ύX TDS  SECS1 or HSMS ̕ύXF킯ł͂ȂB 
//      TDS  SECS1 or HSMS 𔻒f̂͐ݒt@C (.ini)  SECSMODE 
//      ݒɂ̂ŁA̒lύXꍇ .ini  SECSMODE ̐ݒύX
//      Ȃ΂ȂȂB(TDSJava ł SECS-1 ͖T|[g)
//
//   "FUNC_TYPE" ́Agp鏈֐̎ʂI邽߂ɒ`B
//   _TDSUDrvXxxx() gpꍇ́AHSMS-SS Active ڑ̏ꍇ̐ڑ
//   sKvȂ̂ŁA{ł "SECS_MODE" ̐ݒKvȂB
//   TDS ́ASECS-1 ڑ or HSMS-SS ڑ̐ؑւ́Aݒt@C (.ini) ɂčs
//   ߁A֐Ƃ _TDSUDrvXxxx() gṕA[U`oł́A
//   ڑiSECS-1/HSMS-SS  HSMS-SS Passive/ActivejmKv
//   ȂB
//
//   ȉŒ` "MSSG_USE_FILE"A"MSSG_DISP_TYPE" ̒lύXƁA{`o
//   ɂĕ\ SECS bZ[W̏o͌`ύXłB
//   "MSSG_USE_NEXTL" ̒lύXƁAbZ[We͂ۂɁAڒl
//   f[^ƂĎ擾邩A\Xg`Ŏ擾邩ύXłB
//   l "USE_CALLBACK"  =1 ƂƁAMs Callback ֐gp
//   AMbZ[W̕\AQbZ[W̏o͂ōsB
//   Callback ֐gpꍇA͑ipbZ[Wɗꂪ鎖ɗ
//   邱ƁB
//
// =============================================================================

import		java.lang.*;
import		java.util.*;
import		java.io.*;
import		java.nio.*;

import 		TDL.TDS.TDSComm;
import 		TDL.TDS.TDSUDrv;
import 		TDL.TDS.TDSMssg;


public class	JavaIo{


// -----------------------------------------------------------------------------

static final int	EBADF		=9;
static final int	EBUSY		=16;
static final int	ENOMEM		=12;
static final int	ENODEV		=19;
static final int	E2BIG		=7;

static final int	E_NOTCONNECT	=999;
static final int	E_DESELECT	=998;
static final int	E_REJECT	=997;
static final int	E_SELECT	=992;
static final int	E_CONNECT	=991;
static final int	E_RETRYOVER	=989;
static final int	E_T8TIMEDOUT	=988;
static final int	E_T7TIMEDOUT	=987;
static final int	E_T6TIMEDOUT	=986;
static final int	E_T5TIMEDOUT	=985;
static final int	E_T4TIMEDOUT	=984;
static final int	E_T3TIMEDOUT	=983;
static final int	E_T2TIMEDOUT	=982;
static final int	E_T1TIMEDOUT	=981;
static final int	E_ILLBLOCK	=980;
static final int	E_NODATA	=951;


// -----------------------------------------------------------------------------

static final int	SECS_MODE	=1;	// SECS/HSMS mode
						// 0    : SECS-1   <Not support>
						// 1    : HSMS
						// (Note) See comments above
						// () 㕔RgQ
static final int	FUNC_TYPE	=1;	// Type of function used
						// ʐMɎgp֐̎
						// 0    : _TDSCommXxxxx
						// 1    : _TDSUDrvXxxxx
static final int	UDRV_MASK	=0x8383ffff;
						// Mask value of UDrvOpen()
						// 0          : Set =0x49
						// 0x8383ffff : All event

static final int	USE_CALLBACK	=1;	// Use of Callback function
						// 0    : Not use
						// 1    : Use

static final int	MSSG_DISP_TYPE	=0x20;	// SECS Message display format
						// 0x00 : TDS Format
						// 0x20 : SML Format
static final int	MSSG_USE_NEXTL	=1;	// Use MssgNextL() or not
						// 0    : Not use
						// 1    : Use

static final String	PARAMFILE	="Sample.ini";


// -----------------------------------------------------------------------------

static TDSComm		SAcb;		// SECS Communication class
static TDSUDrv		UAcb;		// SECS Communication class
static int		OType=0;	// Operation type  (0:Host  1:Equipment)
static int		Break=0;	// End instruction to thread
					// XbhIw

static int		cnt249=0;
static int		cnt250=0;
static int		cnt611=0;


// =============================================================================
// Common functions ============================================================

static private void
printf(
String		form,
Object...	arg)
{
  try{
    System.out.printf(form,arg);
  }catch(UnknownFormatConversionException	err){
    System.out.printf("Format error\n");
  }catch(Exception				err){
    System.out.printf("Printf error\n");
  }
}


// -----------------------------------------------------------------------------

static private void
Sleep(
int		msec)
{
  try{
    Thread.sleep((long)msec);
  }catch(InterruptedException	err){
  }catch(Exception		err){
  }finally{
  }
}


// -----------------------------------------------------------------------------

static private String
ReadLine(			//  o : Input string
BufferedReader	in,		// i  : Input descriptor
String		msg)		// i  : Input promotion message
{
  String	line;

  for(;;){
    printf("%s"	,msg);
    try{			line=in.readLine();
    }catch(Exception		err){			continue;
    }							break;
  }

  return(line);
}


static private int
ReadInt(			//  o : Input value
BufferedReader	in,		// i  : Input descriptor
String		msg,		// i  : Input promotion message
int		base)		// i  : Radix of integer
{
  String	line;
  int		val;

  for(;;){
    line=ReadLine(in,msg);
    try{			val=Integer.parseInt(line,base);
    }catch(Exception		err){			continue;
    }							break;
  }

  return(val);
}


// -----------------------------------------------------------------------------
// Display SECS messages on standard output ------------------------------------
// SECS bZ[WWo͂ɕ\B ---------------------------------------

static private void
DispSECSMssg(			//
int		tp,		// i  : Message type
				//	=0 : Transmission result
				//	 1 : Received message
				//	 2 : Send message
byte		hd[],		// i  : SECS Message Header
int		did,		// i  : SECS Message Device ID
int		sf,		// i  : SECS Message SF-Code
int		xid,		// i  : SECS Message Transaction ID
byte		msg[],		// i  : SECS Message strage area
				//	     (Header not included)
int		len)		// i  : SECS Message byte length
{
  String	ctp[]={"SRES","RECV","SEND"};
  String	rbit,wbit,sfcode,c;
  StringBuffer	mname=new StringBuffer(),sitem=new StringBuffer();
  ByteBuffer	pm;
  TDSMssg	mcb=new TDSMssg();
  byte		msg1[];
  long		ul;
  int		form[]=new int[1],sz[]=new int[1],noi[]=new int[1];
  int		rtn,md=0,dp=MSSG_DISP_TYPE,fm=0,la,i,j;

  rbit=" ";	if((did&0x8000)!=0)	rbit="R";
  wbit=" ";	if((sf &0x8000)!=0)	wbit="W";
  sfcode=String.format("S%dF%d",(sf&0x7f00)/0x0100,sf&0xff);
  printf("[%s]  Dev=0x%04x  %-8s  %s%s  XId=0x%04x  Len=%4d\n"
		,ctp[tp],did&0x7fff,sfcode,rbit,wbit,xid,len);

  if(len>0){
    if(tp==1){	dp|=0x3000;	fm|=0x3000;}	// In case of receiving
    else{	dp|=0x2000;	fm|=0x2000;}	// In case of sending
    pm=ByteBuffer.allocate(1024);	pm.order(ByteOrder.nativeOrder());
    msg1=pm.array();

    if(mcb._TDSMssgFind(fm,msg,len,0,hd)		>=0){
      for(la=0;;){
	if(MSSG_USE_NEXTL==0){			//  Get item value
	  rtn=mcb._TDSMssgNext(0,msg,form,sz,noi,pm,1024);
	  if(rtn						< 0)	break;
	  printf("%03o:%d*%3d:"	,form[0],sz[0],noi[0]);
	  switch(form[0]){
	    case 000: printf("L[%d]\n"	,noi[0]);		break;
	    case 010: printf("B[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s0x%02x"
				,c,((int)msg1[i]&0xff));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 011: printf("T[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,msg1[i]);		if(i==0) c=",";
		      } printf("\n");				break; 
	    case 020: c=new String(msg1,0 ,noi[0]);
		      printf("A[%d]=%s.\n",noi[0],c);	c=null;	break;
	    case 021: c=new String(msg1,0 ,noi[0]);
		      printf("J[%d]=%s.\n",noi[0],c);	c=null;	break;
	    case 022: c=new String(msg1,0 ,noi[0]);
		      printf("K[%d]=%s.\n",noi[0],c);	c=null;	break;
	    case 030: printf("I8[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,pm.getLong	(i*8));	if(i==0) c=",";
		      } printf("\n");				break;
	    case 031: printf("I1[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,msg1[i]);		if(i==0) c=",";
		      } printf("\n");				break; 
	    case 032: printf("I2[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"
				,c,(int)pm.getShort	(i*2));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 034: printf("I4[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%d"	,c,pm.getInt	(i*4));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 040: printf("F8[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%22.17e"
				,c,pm.getDouble		(i*8));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 044: printf("F4[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
		        printf("%s%13.8e",c,pm.getFloat	(i*4));	if(i==0) c=",";
		      } printf("\n");				break; 
	    case 050: printf("U8[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
			printf("%s%d"	,c,pm.getLong	(i*8));	if(i==0) c=",";
		      } printf("\n");				break;
	    case 051: printf("U1[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
			ul=((long)msg1[i])&0xffL;
		        printf("%s%d"	,c,ul);			if(i==0) c=",";
		      } printf("\n");				break; 
	    case 052: printf("U2[%d]"	,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
			ul=((long)pm.getShort(i*2))&0xffffL;
		        printf("%s%d"	,c,ul);			if(i==0) c=",";
		      } printf("\n");				break; 
	    case 054: printf("U4[%d]"		,noi[0]);
		      for(c="=",i=0;i<noi[0];i++){
			ul=((long)pm.getInt  (i*4))&0xffffffffL;
		        printf("%s%d"	,c,ul);			if(i==0) c=",";
		      } printf("\n");				break; 
	    default:  printf("\n");				break;
	  }

	}else{					// Get in list format
						// Xg\`Ŏ擾
	  rtn=mcb._TDSMssgNextL(dp,msg,form,noi,mname);
	  if(rtn						< 0)	break;
	  if((dp&0x70)>0x10){			// In case of SML
	    for(  i=la;i>rtn;i--){
	      for(j= 0;j<i  ;j++) printf("  ");
	      printf(">\n");			// Display '>'
	  } }
	  la=rtn;				// Save current hierarchy
						// ݂̊Kwۑ
	  printf("  %s\n",mname.toString());	// Display acquired field value
						// 擾ڒl\
	  if((dp&0x70)>0x10 && form[0]==000 && noi[0]==0){
	    for(  j= 0;j<=la;j++) printf("  ");	// '>' Processing for L0
	    printf(">\n");				
      } } }					// L0 ̏ꍇ '>' 
      if(MSSG_USE_NEXTL!=0){
	if((dp&0x70)>0x10){
	  for(  i=la;i>0;i--){
	    for(j= 0;j<i;j++)	  printf("  ");	// Show remaining '>'
	    printf(">\n");			// c '>' \
      } } }				
      mcb._TDSMssgExit(0,msg);
  } }

  mcb=null;
}



// -----------------------------------------------------------------------------
// Display sent and received data ----------------------------------------------

static private int
DispData(
int		tp,		// i  : Message type
				//	=0 : Transmission result
				//	 1 : Received message
				//	 2 : Send messag
byte		hd[],		// i  : SECS Message Header
int		did,		// i  : SECS Message Device ID
int		sf,		// i  : SECS Message SF-Code
int		xid,		// i  : SECS Message Transaction ID
byte		msg[],		// i  : SECS Message body
int		len,		// i  : Byte length of 'msg'
int		rtn)		// i  : I/O return value
{
  int		ok=0;

  if(rtn<0){							 ok=1;
    if((rtn<(-E_NOTCONNECT) || (-E_ILLBLOCK)<rtn) && rtn!=(-E_NODATA)){
      printf("ERROR  [%d]"			,rtn);
      if      (rtn==(-ENODEV)){
	printf(" : No such device ID\n");	len=ok=0;
      }else if(rtn==(-E2BIG )){
	printf(" : Data size to large\n");	len=ok=0;
      }else			printf("\n");
    }else{
      if(FUNC_TYPE==0)	printf("STATUS = %d,%d : ",-rtn,SAcb._TDSCommStatus(0));
      else		printf("STATUS = %d,%d : ",-rtn,UAcb._TDSUDrvStatus(0));
      switch(-rtn){
	case E_NODATA:		printf("No data\n");			break;
	case E_ILLBLOCK:	printf("Illegal block#\n");		break;
	case E_T1TIMEDOUT:	printf("T1 Timeout occur\n");		break;
	case E_T2TIMEDOUT:	printf("T2 Timeout occur\n");		break;
	case E_T3TIMEDOUT:	printf("T3 Timeout occur\n");		break;
	case E_T4TIMEDOUT:	printf("T4 Timeout occur\n");		break;
	case E_T5TIMEDOUT:	printf("T5 Timeout occur\n");		break;
	case E_T6TIMEDOUT:	printf("T6 Timeout occur\n");		break;
	case E_T7TIMEDOUT:	printf("T7 Timeout occur\n");		break;
	case E_T8TIMEDOUT:	printf("T8 Timeout occur\n");		break;
	case E_RETRYOVER:	printf("Retry over\n");			break;
	case E_CONNECT:		printf("Connected\n");			break;
	case E_SELECT:		printf("Selected\n");			break;
	case E_REJECT:		printf("Rejected XId=0x%04x\n",xid);	break;
	case E_DESELECT:	printf("Deselected\n");			break;
	case E_NOTCONNECT:	printf("Not connected\n");		break;
	default:		printf("\n");				break;
  } } }

  if(ok==0) DispSECSMssg(tp,hd,did,sf,xid,msg,len);

  return(0);
}



// =============================================================================
// S1F1 message construction and sending ---------------------------------------
static private int
SendS1F1()
{
  byte		hd[]=new byte[12],msg[]=new byte[16];
  int		rtn,sf=0x8101,len=0;

  if(FUNC_TYPE	==0)	rtn=SAcb._TDSCommSend(0x0000,0,sf,  0,msg,len,hd);
  else			rtn=UAcb._TDSUDrvSend(0x0000,0,sf,  0,msg,len,hd);
  DispData(2,hd,0x00,sf,rtn,msg,len,rtn);

  return(rtn);
}


// -----------------------------------------------------------------------------
// S1F2 message (Host) construction and sending --------------------------------

static private int
SendS1F2H(
int		did,
int		xid)
{
  TDSMssg	mcb =new TDSMssg();
  byte		hd[]=new byte[12],msg[]=new byte[256];
  int		rtn,sf=0x0102,len;
  
  		mcb._TDSMssgInit   (0,msg, 256);		// S1F2
		mcb._TDSMssgBuild  (0,msg, 000,  0);		// L0
  len=		mcb._TDSMssgEnd    (0,msg);

  if(len<0)	rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0000,did,sf,xid,msg,len,hd);
    else		rtn=UAcb._TDSUDrvSend(0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);
  mcb=null;

  return(rtn);
}


// -----------------------------------------------------------------------------
// S1F2 message (Equipment) construction and sending ---------------------------

static private int
SendS1F2E(
int		did,
int		xid)
{
  TDSMssg	mcb =new TDSMssg();
  byte		hd[]=new byte[12],msg[]=new byte[256];
  int		rtn,sf=0x0102,len;
  
    		mcb._TDSMssgInit   (0,msg, 256);		// S1F2
		mcb._TDSMssgBuild  (0,msg, 000, 2);		// L2
		mcb._TDSMssgBuild  (0,msg, 020, 6,"EQUIP1");	//  MDLN
		mcb._TDSMssgBuild  (0,msg, 020, 6,"01.000");	//  SOFTREV
  len=		mcb._TDSMssgEnd    (0,msg);

  if(len<0)	rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0000,did,sf,xid,msg,len,hd);
    else		rtn=UAcb._TDSUDrvSend(0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);
  mcb=null;

  return(rtn);
}


// =============================================================================
// S2F49 message construction and sending --------------------------------------

static private int
SendS2F49()
{
  TDSMssg	mcb =new TDSMssg();
  byte		hd[]=new byte[12],msg[]=new byte[1024];
  byte		vb[]=new byte[32];
  int		vi[]=new int[4];
  String	str,itm;
  int		rtn,sf=0x8200+49,no1,no2,len,i,j;

  cnt249++;	no1=(cnt249%2)+1;	no2=(cnt249%10)+1;
  str=String.format("LOTID (%04d)"	,cnt249);
  
		mcb._TDSMssgInit   (0,msg,1024);		// S2F49
  		mcb._TDSMssgBuild  (0,msg, 000,  3);		// L3
  vb[0]=0;	mcb._TDSMssgBuild  (0,msg, 010,  1,vb);		//  DATAIDB
  		mcb._TDSMssgBuild  (0,msg, 020,  0,"LOAD");	//  RCMD
  		mcb._TDSMssgBuild  (0,msg, 000,  4);		//  L4
  vb[0]=1;	mcb._TDSMssgBuild  (0,msg, 010,  1,vb);		//   STID
  vb[0]=0;	mcb._TDSMssgBuild  (0,msg, 010,  1,vb);		//   MTKD
  		mcb._TDSMssgBuild  (0,msg, 020, 20,str);	//   LOTID
		mcb._TDSMssgBuild  (0,msg, 000,no1);		//   L[no1]
  for(i=0;i<no1;i++){
		mcb._TDSMssgBuild  (0,msg, 000,no2);		//    L[no2]
    for(j=0;j<no2;j++){
		mcb._TDSMssgBuild  (0,msg, 000,  2);		//     L[2]
      str=String.format("WAFER(%04d-%d-%02d)",cnt249,i+1,i+2);
  		mcb._TDSMssgBuild  (0,msg, 020, 20,str);	//      WAFERID
      str=String.format("PPID (%04d-%d-%02d)",cnt249,i+1,i+2);
  		mcb._TDSMssgBuild  (0,msg, 020, 16,str);	//      PPID
  } }
  len=		mcb._TDSMssgEnd    (0,msg);

  if(len<0)	rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0000,0,sf,  0,msg,len,hd);
    else		rtn=UAcb._TDSUDrvSend(0x0000,0,sf,  0,msg,len,hd);
  }
  DispData(2,hd,0x00,sf,rtn,msg,len,rtn);
  mcb=null;

  return(rtn);
}


// -----------------------------------------------------------------------------
// S2F50 message construction and sending --------------------------------------

static private int
SendS2F50(
int		did,
int		xid)
{
  TDSMssg	mcb =new TDSMssg();
  byte		hd[]=new byte[12],msg[]=new byte[256];
  byte		vb[]=new byte[32];
  String	str;
  int		rtn,sf=0x0200+50,len;
  
  str=String.format("LOTID (%04d)"		,++cnt250);

		mcb._TDSMssgInit   (0,msg, 256);		// S2F50
		mcb._TDSMssgBuild  (0,msg, 000,  2);		// L2
  vb[0]=0;	mcb._TDSMssgBuild  (0,msg, 010,  1,vb);		//  HCACK
		mcb._TDSMssgBuild  (0,msg, 000,  2);		//  L2
  		mcb._TDSMssgBuild  (0,msg, 020,  5,"PODID");	//   PODID
  		mcb._TDSMssgBuild  (0,msg, 020, 20,str);	//   LOTID
  len=		mcb._TDSMssgEnd    (0,msg);

  if(len<0)	rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0000,did,sf,xid,msg,len,hd);
    else		rtn=UAcb._TDSUDrvSend(0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);
  mcb=null;

  return(rtn);
}


// =============================================================================
// S6F11 message construction and sending --------------------------------------

static private int
SendS6F11()
{
  TDSMssg	mcb =new TDSMssg();
  byte		hd[]=new byte[12],msg[]=new byte[256];
  short		vs[]=new short[4];
  int		rtn,sf=0x8600+11,len;

  if((++cnt611)==32768) cnt611=0;

		mcb._TDSMssgInit   (0,msg, 256);		// S6F11
  		mcb._TDSMssgBuild  (0,msg, 000,  3);		// L3
  vs[0]=(short)cnt611;
		mcb._TDSMssgBuild  (0,msg, 052,  1,vs);		//  DATAID
  vs[0]=8;	mcb._TDSMssgBuild  (0,msg, 052,  1,vs);		//  CEID
  		mcb._TDSMssgBuild  (0,msg, 000,  3);		//  L3
  		mcb._TDSMssgBuild  (0,msg, 020, 16,"DATA1");	//   DATA1
  		mcb._TDSMssgBuild  (0,msg, 020, 16,"DATA2");	//   DATA2
  		mcb._TDSMssgBuild  (0,msg, 020, 14,"YYYYMMDDhhmmss");
			// @TIME Actually I set current time, but omitted.
			// @TIME ({͌ݎݒ肷̂AȗB
  len=		mcb._TDSMssgEnd    (0,msg);

  if(len<0)	rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0000,0,sf,  0,msg,len,hd);
    else		rtn=UAcb._TDSUDrvSend(0x0000,0,sf,  0,msg,len,hd);
  }
  DispData(2,hd,0x00,sf,rtn,msg,len,rtn);
  mcb=null;

  return(rtn);
}



// -----------------------------------------------------------------------------
// S6F12 message construction and sending --------------------------------------

static private int
SendS6F12(
int		did,
int		xid)
{
  TDSMssg	mcb =new TDSMssg();
  byte		hd[]=new byte[12],msg[]=new byte[256];
  byte		vb[]=new byte[32];
  int		rtn,sf=0x0600+12,len;

		mcb._TDSMssgInit (0,msg, 256);			// S6F12
  vb[0]=0;	mcb._TDSMssgBuild(0,msg, 010,  1);		// ACKC
  len=		mcb._TDSMssgEnd  (0,msg);

  if(len<0)	rtn=len;
  else{
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0000,did,sf,xid,msg,len,hd);
    else		rtn=UAcb._TDSUDrvSend(0x0000,did,sf,xid,msg,len,hd);
  }
  DispData(2,hd,did,sf,rtn,msg,len,rtn);
  mcb=null;

  return(rtn);
}



// =============================================================================
// Callback function ===========================================================

static private int
CBRecvProc(
int		req,		// i  : Request code to library
int		rtn,		// i  : Return code from library
int		did,		// i  : SECS Message Device ID
int		xsf,		// i  : SECS Message SF-Code
int		xid,		// i  : SECS Message Transaction ID
byte		xhd[],		// i  : SECS Message Header
byte		xmsg[])		// i  : SECS Message Body
{
  DispData(1,xhd,did,xsf,xid,xmsg,rtn,rtn);
  if(req== 0 && rtn>=0){
    if     (xsf==(0x8100+ 1)&&OType==0)	SendS1F2H (did,xid);
    else if(xsf==(0x8100+ 1)&&OType==1)	SendS1F2E (did,xid);
    else if(xsf==(0x8200+49))		SendS2F50 (did,xid);
    else if(xsf==(0x8600+11))		SendS6F12 (did,xid);
  }

  return(0);
}


// -----------------------------------------------------------------------------

static class RecvProcThread extends Thread{
public void
run()
{
  byte		msg[]=new byte[1024],hd[]=new byte[12];
  int		xid[]=new int[ 1],did[]=new int[1],sf[]=new int[1];
  int		rtn,req;

  for(;Break==0;){
    req=0;
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommRecv(0,did,sf,xid,msg,1024,hd);
    else		rtn=UAcb._TDSUDrvRecv(0,did,sf,xid,msg,1024,hd);
    if(rtn	==(-E_NODATA)){
      Sleep(100);
    }else{
      if((-1000)<rtn && rtn<(-959))	req=(-rtn)-900;
      CBRecvProc(req,rtn,did[0],sf[0],xid[0],hd,msg);
  } }
}
}



// =============================================================================
// Main process ----------------------------------------------------------------

public static void
main(
String[]		argv)
{
  if     (argv.length<1)		printf("Usage: JavaIo {h|e}\n");
  else if(argv[0].equals("h")==false &&
	  argv[0].equals("e")==false)	printf("Usage: JavaIo {h|e}\n");
  else{
    if(argv[0].equals("h")==true)	Host ();
    else				Equip();
  }
}



// =============================================================================
// Host side process -----------------------------------------------------------

static private void
Host()
{
  BufferedReader	in;
  RecvProcThread	th;
  String		str;
  byte			hd[]=new byte[12],msg[]=new byte[1024];
  int			xid[]=new int[1],did[]=new int[1],sf[]=new int[1];
  int			req,rtn,mno,dsd=0,xsd=0;

  OType=0;		Break=0;
  in=new BufferedReader(new InputStreamReader(System.in));

L0:{
  if(FUNC_TYPE	==0)	SAcb=new TDSComm();
  else			UAcb=new TDSUDrv();
  if(FUNC_TYPE	==0)	rtn=SAcb._TDSCommOpen(0x02,PARAMFILE,"HOST");
  else			rtn=UAcb._TDSUDrvOpen(0x02,PARAMFILE,"HOST",UDRV_MASK);
  if(rtn						< 0)	break L0;
  printf("(H) Opened\n");
 
  if(USE_CALLBACK!=0){
    th=new RecvProcThread();
    th.start();
  }

  for(;;){		rtn=0;
    if(USE_CALLBACK==0)	str="Req (0:Exit 1:Recv 2:Send) : ";
    else		str="Req (0:Exit 2:Send) : ";
    req=ReadInt(in,str,10);
    if      (req==0){						break;

    }else if(req==1){
      if(FUNC_TYPE==0)	rtn=SAcb._TDSCommRecv(0,did,sf,xid,msg,1024,hd);
      else		rtn=UAcb._TDSUDrvRecv(0,did,sf,xid,msg,1024,hd);
      if(rtn	>=0){	dsd=did[0];	xsd=xid[0];}
      DispData(1,hd,did[0],sf[0],xid[0],msg,rtn,rtn);

    }else if(req==2){
      if(USE_CALLBACK==0) str="Message(1:S1F1 2:S2F49  6:S1F2 7:S6F12) : ";
      else		  str="Message(1:S1F1 2:S2F49) : ";
      mno=ReadInt(in,str,10);
      switch(mno){
	case 1: rtn=SendS1F1 ();		break;
	case 2: rtn=SendS2F49();		break;
	case 6: rtn=SendS1F2H(dsd,xsd);		break;
	case 7: rtn=SendS6F12(dsd,xsd);		break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      printf("(H) I/O Error (%d)\n"			,rtn);
  } }
  }	// L0:

  Break  = 1;
  if(SAcb!=null)	SAcb._TDSCommClose(0);		SAcb=null;
  if(UAcb!=null)	UAcb._TDSUDrvClose(0);		UAcb=null;
  if(rtn < 0)		printf("(H) Error (%d)\n"	,rtn);
}



// =============================================================================
// Equipment side process ------------------------------------------------------

static private void
Equip()
{
  BufferedReader	in;
  RecvProcThread	th;
  String		str;
  byte			hd[]=new byte[12],msg[]=new byte[1024];
  int			xid[]=new int[1],did[]=new int[1],sf[]=new int[1];
  int			req,rtn,mno,dsd=0,xsd=0;

  OType=1;	Break=0;
  in=new BufferedReader(new InputStreamReader(System.in));

L0:{
  if(FUNC_TYPE	==0)	SAcb=new TDSComm();
  else			UAcb=new TDSUDrv();
  if(FUNC_TYPE	==0)	rtn=SAcb._TDSCommOpen(0x02,PARAMFILE,"EQUIP");
  else			rtn=UAcb._TDSUDrvOpen(0x02,PARAMFILE,"EQUIP",UDRV_MASK);
  if(rtn							< 0) break L0;
  printf("(E) Opened\n");

  if(USE_CALLBACK!=0){
    th=new RecvProcThread();
    th.start();
  }

  if(SECS_MODE!=0 && FUNC_TYPE==0){  // In case of HSMS and use _TDSCommXxxxx()
				     // HSMS  _TDSCommXxxxx() gp̏ꍇ
    if(SAcb._TDSCommSend(0x0100,0,0,0,msg,0,hd)			< 0) break L0;
    printf("(E) Connected\n");
    if(SAcb._TDSCommSend(0x0200,0,0,0,msg,0,hd)			< 0) break L0;
    printf("(E) Selected\n");
  }

  for(;;){		rtn=0;
    if(USE_CALLBACK==0)	str="Req (0:Exit 1:Recv 2:Send) : ";
    else		str="Req (0:Exit 2:Send) : ";
    req=ReadInt(in,str,10);
    if      (req==0){						     break;

    }else if(req==1){
      if(FUNC_TYPE==0)	rtn=SAcb._TDSCommRecv(0,did,sf,xid,msg,1024,hd);
      else		rtn=UAcb._TDSUDrvRecv(0,did,sf,xid,msg,1024,hd);
      if(rtn	>=0){	dsd=did[0];	xsd=xid[0];}
      DispData(1,hd,did[0],sf[0],xid[0],msg,rtn,rtn);

    }else if(req==2){
      if(USE_CALLBACK==0) str="Message(1:S1F1 2:S6F11  6:S1F2 7:S2F50) : ";
      else		  str="Message(1:S1F1 2:S6F11) : ";
      mno=ReadInt(in,str,10);
      switch(mno){
	case 1: rtn=SendS1F1 ();		break;
	case 2: rtn=SendS6F11();		break;
	case 6: rtn=SendS1F2E(dsd,xsd);		break;
	case 7: rtn=SendS2F50(dsd,xsd);		break;
    } }
    if(rtn<(-999) || ((-900)<rtn && rtn<0)){
      printf("(E) I/O Error (%d)\n"		,rtn);
  } }

  if(SECS_MODE	!=0){			// In case of HSMS, Shutdown process
					// HSMS ڑ̏ꍇAؒf
    if(FUNC_TYPE==0)	rtn=SAcb._TDSCommStatus(0);
    else		rtn=UAcb._TDSUDrvStatus(0);
    if(rtn	==3){
    // Deselect request is not performed. (Of course you may go. However SEMI
    // claims that HSMS-SS does not perform Deselect request.)
    // Deselect request ͍sȂB (sĂ悢BSEMI ł HSMS-SS
    // ɂāADeselect request ͍sȂAƂĂB)
    //if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0800,0,0,0,msg,0,hd);
    //else		rtn=UAcb._TDSUDrvSend(0x0800,0,0,0,msg,0,hd);
    //if(rtn							< 0) break L0;
    //printf("(E) Deselected\n");
      if(FUNC_TYPE==0)	rtn=SAcb._TDSCommSend(0x0900,0,0,0,msg,0,hd);
      else		rtn=UAcb._TDSUDrvSend(0x0900,0,0,0,msg,0,hd);
      if(rtn							< 0) break L0;
      printf("(E) Separated\n");
  } }
  }	// L0:

  Break  = 1;
  if(SAcb!=null)	SAcb._TDSCommClose(0);		SAcb=null;
  if(UAcb!=null)	UAcb._TDSUDrvClose(0);		UAcb=null;
  if(rtn < 0)		printf("(H) Error (%d)\n"	,rtn);
}

}
