
//
// Trust Design LLC : SECS/HSMS Communication library
//
// (c) Copyright Trust Design LLC.  2010-2019.  All rights reserved.
//

#include		"stdafx.h"
#include		"TDSSample2.h"
#include		"TDSSample2Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif



/////////////////////////////////////////////////////////////////////////////
// CTDSSample2Proc ̊e֐{NX̕\̈ɁAbZ[Wo͂邽
// ̊֐B

CTDSSample2Dlg		*pDlg;			// { CLASS CX^X͗BłA
CWinThread			*pThread;		// ÔƁA֋XIɁAɖ{
									// CLASS CX^Xւ̃|C^y
									// bZ[W\Xbh̃|C^
									// mۂB

void	XXPrintf(char *form, ...)
{
	va_list		va;
	char		str[1024],*p;
	int			sz;

	va_start(va,form);
	_vsnprintf_s(str,sizeof(str)-2,_TRUNCATE,form,va);
	va_end(va);

  //pDlg->AddList(str);				// Winodw ւ̕\ł͂ȂA\Xbh
									// փbZ[W𑗏oĂ܂B
	p=(char*)malloc(sz=(int)(strlen(str)+1));
	strcpy_s(p,sz,str);
	PostThreadMessage(pThread->m_nThreadID,WM_DISPMSSG,(WPARAM)p,0);
}



/////////////////////////////////////////////////////////////////////////////
// {NX̃bZ[W\̈ւ̃bZ[W\ Windows bZ[W
// tAAddList() ɂ\郏[JXbh
// \̈ւ̕\́ASECS bZ[W̑MAMƂ̂ƂȂ邪A
// ̕\݂Ȃ悤ɃbNsBM̕\́Aʐ
// Ɠ̃Xbhōs߁AbNɂMbZ[W̕\ɑM
// bZ[W̕\AMbZ[W̕\~ƁAʂƂ
// ʐXbh~Aʕ\łȂ߁AMXbh~
// ƂfbhbNɂȂB邽߁A\bZ[W Windows 
// bZ[WőM邱ƂɂA\҂𖳂AfbhbNB
// {Xbh Windows bZ[W󂯎A\邽߂̃XbhŁA{
// `oNi{NX̐jƔɋNAIȂB
// bZ[W PostMessage() őMA\i[̈͑M
// malloc() Ă̂ŁAIA free() KvB

static UINT
DispText(
LPVOID				par)
{
	CTDSSample2Dlg	*pt;
	MSG				msg;

	pt=(CTDSSample2Dlg*)par;
	for(;;){
		if(GetMessage(&msg,NULL,WM_DISPMSSG,WM_DISPMSSG)	<=0) break;
		pt->AddList((char*)msg.wParam);
		free((void*)msg.wParam);
	}
	AfxEndThread(0);
	return(0);
}



/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

protected:
	DECLARE_MESSAGE_MAP()
};



CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}



void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}



BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CTDSSample2Dlg _CAO

CTDSSample2Dlg::CTDSSample2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTDSSample2Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	pDlg			= this;			// XXPrintf() ̂߂̃|C^m
	m_cWinSize.cx	= 0;
	m_cWinSize.cy	= 0;
	m_Thread		= 0;
	m_iPType		= 0;
	m_Stop			= 0;
}



void CTDSSample2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control	(pDX, IDC_EDIT1		, m_cEditList);
	DDX_Control	(pDX, IDC_EDIT2		, m_cEditMssg);
	DDX_Control	(pDX, IDC_BUTTON1	, m_cBtnStart);
	DDX_Control	(pDX, IDC_BUTTON6	, m_cBtnSend1);
	DDX_Control	(pDX, IDC_BUTTON7	, m_cBtnSend2);
	DDX_Control	(pDX, IDC_BUTTON9	, m_cBtnSend3);
	DDX_Control	(pDX, IDC_BUTTON8	, m_cBtnSendC);
	DDX_Control	(pDX, IDC_RADIO1	, m_cPType0);
	DDX_Control	(pDX, IDC_RADIO2	, m_cPType1);
	DDX_Control	(pDX, IDC_STATIC4	, m_cStaStat);
	DDX_Text	(pDX, IDC_EDIT2		, m_cStrMssgName);
	DDX_Radio	(pDX, IDC_RADIO1	, m_iPType);
}



BEGIN_MESSAGE_MAP(CTDSSample2Dlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDCANCEL		, &CTDSSample2Dlg::OnBnClickedCancel)
	ON_BN_CLICKED(IDC_BUTTON1	, &CTDSSample2Dlg::OnBnClickedStart)
	ON_BN_CLICKED(IDC_BUTTON6	, &CTDSSample2Dlg::OnBnClickedSend1)
	ON_BN_CLICKED(IDC_BUTTON7	, &CTDSSample2Dlg::OnBnClickedSend2)
	ON_BN_CLICKED(IDC_BUTTON9	, &CTDSSample2Dlg::OnBnClickedSend3)
	ON_BN_CLICKED(IDC_BUTTON8	, &CTDSSample2Dlg::OnBnClickedSendC)
	ON_WM_SIZE()
	ON_WM_GETMINMAXINFO()
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CTDSSample2Dlg bZ[W nh

BOOL CTDSSample2Dlg::OnInitDialog()
{
	CMenu		*pSysMenu;
	CRect		rect;
	CString		strAboutMenu;

	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT( IDM_ABOUTBOX < 0xF000);

	pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL){
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty()){
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B

	GetClientRect(rect);
	m_cWinSize.cx = rect.Width ();
	m_cWinSize.cy = rect.Height();

	m_cEditList.Init(10000, 1000);

	m_sp			= 0;
	m_iPType		= 0;
	m_cStrMssgName	= _T("");
	m_cStaStat		.SetWindowText("ڑ");
	m_cBtnSend1		.EnableWindow(FALSE);
	m_cBtnSend2		.EnableWindow(FALSE);
	m_cBtnSend3		.EnableWindow(FALSE);
	m_cBtnSendC		.EnableWindow(FALSE);
	m_cEditMssg		.EnableWindow(FALSE);

	UpdateData(FALSE);
	pThread=AfxBeginThread(DispText,(LPVOID)this);

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}


BOOL CTDSSample2Dlg::PreTranslateMessage(MSG *pMsg)
{
	switch(pMsg->message){
		case WM_KEYDOWN:
			switch(pMsg->wParam){
				case VK_ESCAPE:		return TRUE;
				case VK_RETURN:		return TRUE;
			}
			break;
	}

	return CDialog::PreTranslateMessage(pMsg);
}


void CTDSSample2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX){
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}else{
		CDialog::OnSysCommand(nID, lParam);
	}
}


// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CTDSSample2Dlg::OnPaint()
{
	if (IsIconic()){
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width()  - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}else{
		CDialog::OnPaint();
	}
}



// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CTDSSample2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CTDSSample2Dlg::OnGetMinMaxInfo(MINMAXINFO* lpMMI)
{
	lpMMI->ptMinTrackSize.x = 320;
	lpMMI->ptMinTrackSize.y = 240;

	CDialog::OnGetMinMaxInfo(lpMMI);
}



void CTDSSample2Dlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	if(m_cWinSize.cx == 0)				return;

	CRect		rect;
	int			dx, dy;

	dx = cx - m_cWinSize.cx;
	dy = cy - m_cWinSize.cy;

	m_cEditList.GetWindowRect(&rect);
	ScreenToClient(&rect);
	rect.right  += dx;
	rect.bottom += dy;
	m_cEditList.SetWindowPos(NULL, 0, 0, rect.Width(), rect.Height(), SWP_NOZORDER | SWP_NOMOVE);

	m_cWinSize.cx = cx;
	m_cWinSize.cy = cy;
}



/////////////////////////////////////////////////////////////////////////////
// I
// CTDSSample2Proc ς݂̏ꍇÃCX^XJB

void CTDSSample2Dlg::OnBnClickedCancel()
{
	AddList("I");
	if(m_Thread	!=0){	m_Stop=1;
		if(WaitForSingleObject(m_Thread->m_hThread,5000)==WAIT_TIMEOUT){
			TerminateThread	  (m_Thread->m_hThread,~0x00);
	}	}				m_Thread=0;
	if(m_sp		!=0)	OnBnClickedStart();
	OnCancel();
}



/////////////////////////////////////////////////////////////////////////////

#define		TERM_TIMER_ID		1

void CTDSSample2Dlg::OnTimer(UINT_PTR nIDEvent)
{
	KillTimer(TERM_TIMER_ID);
	OnBnClickedStart();
}



/////////////////////////////////////////////////////////////////////////////
// Jn^I {^

void CTDSSample2Dlg::OnBnClickedStart()
{
	CTDSSample2Proc	*p_sp;

	UpdateData(TRUE);

	if(m_sp==0){
		m_sp = new CTDSSample2Proc();
		m_sp->Initialize(m_iPType);
		m_cBtnStart			.SetWindowText("I");
		m_cPType0			.EnableWindow(FALSE);
		m_cPType1			.EnableWindow(FALSE);
		if(m_iPType==0){
			m_cBtnSend2		.SetWindowText("S6F11 M");
		}else{
			m_cBtnSend2		.SetWindowText("S2F49 M");
		}
		CheckStatusStart();

	}else{
		CheckStatusStop();
		if(m_sp->Terminate()< 0){
							// bNɎsďIꍇ́A100ms 
							// ēx݂B
			SetTimer(TERM_TIMER_ID,100,NULL);
		}else{				// bNAIsꍇ́A
							// ʏ̏IsB
			p_sp=m_sp;		// I m_sp gpݏԕ\
			m_sp=0;			// s߂̃Xbh CheckStatus() łُ̈I
							// 邽߁AU p_sp Rs[Am_sp 
							// =0 ƂBm_sp  delete ́AԂuĂ
							// sB
			m_cBtnStart			.SetWindowText("Jn");
			m_cStaStat			.SetWindowText("ڑ");
			m_cPType0			.EnableWindow(TRUE);
			m_cPType1			.EnableWindow(TRUE);
			m_cBtnSend1			.EnableWindow(FALSE);
			m_cBtnSend2			.EnableWindow(FALSE);
			m_cBtnSend3			.EnableWindow(FALSE);
			m_cBtnSendC			.EnableWindow(FALSE);
			m_cEditMssg			.EnableWindow(FALSE);
			Sleep(100);			delete p_sp;

		}
		UpdateData(FALSE);
	}
}



/////////////////////////////////////////////////////////////////////////////
// SECS bZ[WM

void CTDSSample2Dlg::OnBnClickedSend1()
{
	m_sp->SendS1F1();
}



void CTDSSample2Dlg::OnBnClickedSend2()
{
	if(m_iPType==0)			m_sp->SendS6F11();
	else					m_sp->SendS2F49();
}



void CTDSSample2Dlg::OnBnClickedSend3()
{
	char		name[64];

	UpdateData(TRUE);
	strcpy_s(name,sizeof(name),m_cStrMssgName);
	m_sp->SendNamedMssg(name);
}


/////////////////////////////////////////////////////////////////////////////
// SECS bZ[W̘AMJn^~w

void CTDSSample2Dlg::OnBnClickedSendC()
{
	if(m_sp->GetCRun()==0)	m_sp->ContSendStart();
	else					m_sp->ContSendStop();
}



/////////////////////////////////////////////////////////////////////////////
// CTDSSampleProc ݂̌̐ڑԁAyјAMsԂĎAe
// {^̗LAyуxݒ肷B
// {֐́A[JXbhƂē삷B

static UINT
CheckStatus(
LPVOID				par)
{
	CTDSSample2Dlg	*pt;
	int				stat0,stat1=(-1),run0,run1=(-1),ok;

	pt=(CTDSSample2Dlg*)par;
	for(pt->m_Stop=0;pt->m_Stop==0;){
		Sleep(100);		ok=FALSE;
			// {Xbhł́ATDS pĂ pt->m_sp Lł
			// ꍇ̂݁Aȉ̏sȂ΂Ȃ̂ŁATDS ̏I
			// ƂŃbNsKv邪A{Tvł͂̏
			// A|C^̗L݂̂̃`FbNsB
		if(pt->m_sp							==0)		continue;
		if((stat0=pt->m_sp->GetStatus())	!=stat1){
			switch(stat0){
				case 0:	ok=FALSE;	break;
				case 1: ok=FALSE;	break;
				case 2: ok=TRUE;	break;
			}
			if(ok)	pt->m_cStaStat	.SetWindowText("ڑ");
			else	pt->m_cStaStat	.SetWindowText("ڑ");
			pt->m_cBtnSendC			.EnableWindow(ok);
			if(ok && pt->m_sp->GetCRun()!=0)	ok=FALSE;
			pt->m_cBtnSend1			.EnableWindow(ok);
			pt->m_cBtnSend2			.EnableWindow(ok);
			pt->m_cBtnSend3			.EnableWindow(ok);
			pt->m_cEditMssg			.EnableWindow(ok);
			stat1=stat0;
		}
		if(pt->m_sp							==0)		continue;
		if((run0=pt->m_sp->GetCRun())		!=run1){
			if(run0==0){			ok=TRUE;
				pt->m_cBtnSendC		.SetWindowText("AMJn");
			}else{					ok=FALSE;
				pt->m_cBtnSendC		.SetWindowText("AMI");
			}
			if(ok && pt->m_sp->GetStatus()!=2)	ok=FALSE;
			pt->m_cBtnSend1			.EnableWindow(ok);
			pt->m_cBtnSend2			.EnableWindow(ok);
			pt->m_cBtnSend3			.EnableWindow(ok);
		  //pt->m_cBtnSendC			.EnableWindow(ok);
			pt->m_cEditMssg			.EnableWindow(ok);
			run1 =run0;
		}
		if( run0==0)	ok=TRUE;
		else			ok=FALSE;
		pt->m_cBtnStart				.EnableWindow(ok);
	}

	pt->m_Thread=0;		pt->m_Stop=0;
	AfxEndThread(0);
	return(0);
}



/////////////////////////////////////////////////////////////////////////////
// LXbh̊Jn y ~

void
CTDSSample2Dlg::CheckStatusStart()
{
	m_Thread=AfxBeginThread(CheckStatus,(LPVOID)this);
}



void
CTDSSample2Dlg::CheckStatusStop()
{
	if(m_Thread!=0)		m_Stop=1;
}



/////////////////////////////////////////////////////////////////////////////
// {NX̃bZ[W\̈ւ̎w胁bZ[W̕\

void CTDSSample2Dlg::AddList(char *str)		// Xgɒǉ
{
	m_cEditList.AddString(str);
}
