
//
// Trust Design LLC : SECS/HSMS Communication library
//
// (c) Copyright Trust Design LLC.  2010-2020.  All rights reserved.
//


// =============================================================================
//
// TDSSample1Proc : eXg y TvEvO
//
//  w SF R[h̃bZ[W𑗐MB
//  Callback ֐gpāAMbZ[Wɑ΂鉞sB̍ہA
//  bZ[W`t@CgpbZ[W\z@\gpB
//  SML `bZ[W`t@Cgp SECS bZ[W̍\zA͂
//  sB
//
//  (1) ATDS ̓bZ[W`t@Cp SECS bZ[W
//  ̍\zA͂sƂłBbZ[W`t@CpȂꍇ
//  SECS bZ[W̍\zA͂ɊւĂ Sample0/ ̊eTvE\[X
//  QƂ邱ƁB
//
//  (2) {Tv́ASECS bZ[WM TDSCommOpen() Ɏw
//   Callback ֐ŏBCallback ֐gpȂꍇ̎M
//  ɊւĂ Sample2/TDSSample2Proc.cpp QƂ邱ƁB
//
//  Build sƁAs`t@CiTDSSample1.exej Release/ 
//  Debug/ ɍ쐬B
//  sɂ́Aȉ̃t@CKvB../ y ../Sample0/ ɑ݂ȉ
//  t@CA{fBNgɃRs[邱ƁB
//  E Sample.ini
//  E Sample.sml
//  E TDS.dll
//
//  L #define SEND_WAIT lύXƁAAMɂ鑗MԊuύX
//  邱ƂłB
//
//
// N@
//
//   TDSSample1
//   ~~~~~~~~~~
// =============================================================================

#include			"stdafx.h"
#include			"TDSSample1Proc.h"


// -----------------------------------------------------------------------------

extern void		 	XXPrintf		(char*,...);

#define 			PO				XXPrintf
#define				SEND_WAIT		2000		// bZ[WMԊu      (mb)
#define				SEND_NO			10			// bZ[WMx݂܂ł̉
#define				SEND_SLEEP		10000		// xݎ              (mb)
#define				ERROR_SLEEP		10000		// G[xݎ  (mb)

#define				PARAMFILE		"Sample.ini"



// =============================================================================
// Callback ֐ ---------------------------------------------------------------

// TDS Ƃ I/F ֐ -----------------------------------------------------------

static int
Recv(
void				*par,			// i  : { CLASS CX^Xւ̃|C^
TDSCBData			*cbd)			// i  : Mf[^
{
  CTDSSample1Proc	*pt;
  pt=(CTDSSample1Proc*)par;
  return(pt->CBRecv(par,cbd));
}


static int
Send(
void				*par,			// i  : { CLASS CX^Xւ̃|C^
TDSCBData			*cbd)			// i  : Mʃf[^
{
  CTDSSample1Proc	*pt;
  pt=(CTDSSample1Proc*)par;
  return(pt->CBSend(par,cbd));
}


// -----------------------------------------------------------------------------
// 肩 SECS bZ[WMp Callback -----------------------------------

int
CTDSSample1Proc::CBRecv(
void				*par,			// i  : { CLASS ւ̃|C^ igpj
TDSCBData			*cbd)			// i  : Mf[^
{
  TDSECSHead		hd;
  char				msg[1024],rname[32],sname[32];
  int				rtn,len,sf;

  EnterCriticalSection(&m_cs0);
  DispData(1,&cbd->thd,cbd->msg,cbd->rtn,cbd->rtn);
  switch(cbd->rtn){
    case -E_CONNECT:	m_Status=1;	break;		// Connected
    case -E_SELECT:		m_Status=2;	break;		// Selected
    case -E_DESELECT:	m_Status=1;	break;		// Deselected
    case -E_SEPARATE:	m_Status=1;	break;		// Separated
    case -E_NOTCONNECT:	m_Status=0;	break;		// Not connected
  }

  if(cbd->req== 0 && cbd->rtn>=0 && m_Md>0){
    memcpy(msg,cbd->msg,cbd->rtn);
    len=_TDSMDMssgAutoRes(m_Md,0,&cbd->thd,msg,cbd->rtn,sizeof(msg),rname,sname,&sf);
	if(len	>=0){
	  PO("RECV %s ..  Automatically responds %s [S%dF%d]",rname,sname,sf/0x100,sf&0xff);
	  rtn=_TDSCommSend(m_Fd,0x0000,cbd->devid,sf,cbd->xid,msg,len,&hd);
	  DispData(2,&hd,msg,len,rtn);
    }else{
	  if(len!=(-930) && len!=(-931)) PO("RECV Auto response error (%d)",len);
  } }
  LeaveCriticalSection(&m_cs0);

  return(0);
}


// -----------------------------------------------------------------------------
// MʎMp Callback -----------------------------------------------------

int
CTDSSample1Proc::CBSend(
void				*par,			// i  : { CLASS ւ̃|C^ igpj
TDSCBData			*cbd)			// i  : Mʃf[^
{
//DispData(0,&cbd->thd,cbd->msg,cbd->rtn,cbd->rtn);
  return(0);
}



// =============================================================================
// \z y j --------------------------------------------------------------

CTDSSample1Proc::CTDSSample1Proc()
{
  m_Fd=m_Md=m_Status=m_OType=m_Stop=m_CRun=m_CRunP=0;
  m_Thread=0;
  InitializeCriticalSection(&m_cs0);
  InitializeCriticalSection(&m_cs1);
}


CTDSSample1Proc::~CTDSSample1Proc()
{
  ContSendStop();
  if(m_Md>0)	_TDSMDMssgTerminate	(m_Md,0);
  if(m_Fd>0)	_TDSCommClose		(m_Fd,0);
  DeleteCriticalSection(&m_cs0);
  DeleteCriticalSection(&m_cs1);
}



// =============================================================================
//  y I --------------------------------------------------------

int
CTDSSample1Proc::Initialize(		//  o : < 0 : NG
									//		= 0 : OK
int					type)			// i  : ^Cv
									//		= 0 : u
									//		  1 : zXg
{
  static char		*ctype[]={"EQUIP","HOST"};
  int				rtn;	

  if((m_Fd=_TDSCommOpen(0x1002,PARAMFILE,ctype[m_OType=type]
									,Recv,this,Send,this,0,0))	> 0){
	m_Md=_TDSMDMssgInitialize(0x4000,m_Fd,0);
  }
  PO("Opened (%d)"	,m_Fd);

  if((rtn=m_Fd)> 0)	rtn=0;
  return(rtn);
}


int
CTDSSample1Proc::Terminate()
{
  int				fd;

  fd=m_Fd;

  ContSendStop();

	// Iw󂯕tAIsXbhƂ͕ʂ̃Xbhœ삷
	// M삪܂ő҂߂ɁAbNsB
	// bNłȂꍇ́AMsŁAʂւ̃bZ[W\s
	// ŒȂ̂ŁAU{֐甲Aēx̖{֐ Call ҂B
  if(TryEnterCriticalSection(&m_cs0)	==0)	return(-1);

  if(m_Md>0)	_TDSMDMssgTerminate	(m_Md,0);	m_Md=0;
  if(m_Fd>0)	_TDSCommClose		(m_Fd,0);	m_Fd=0;
  LeaveCriticalSection(&m_cs0);

  PO("Closed (%d)"	,fd);
  return(0);
}



// =============================================================================
// ݓԂ̎擾  ---------------------------------------------------------

int
CTDSSample1Proc::GetStatus()		//  o : = 0 : ڑ
									//		  1 :  Select
									//		  2 : Select 
{
  return(m_Status);
}


int
CTDSSample1Proc::GetCRun()			//  o : = 0 : s
									//		  1 : s
{
  return(m_CRun);
}



// =============================================================================
// ڑAؒfvM ----------------------------------------------------------

int
CTDSSample1Proc::SendConnect()
{
  return(_TDSCommSend(m_Fd,0x0100,0,0,0,0,0,0));
}


int
CTDSSample1Proc::SendSelect()
{
  return(_TDSCommSend(m_Fd,0x0200,0,0,0,0,0,0));
}


int
CTDSSample1Proc::SendDeselect()
{
  return(_TDSCommSend(m_Fd,0x0800,0,0,0,0,0,0));
}


int
CTDSSample1Proc::SendShutdown()
{
  return(_TDSCommSend(m_Fd,0x0900,0,0,0,0,0,0));
}



// =============================================================================
// S1F1 bZ[W\zyёM -------------------------------------------------

int
CTDSSample1Proc::SendS1F1()
{
  TDSECSHead		hd;
  char				msg[16];
  int				rtn,len=0;

					// Sample0/SubFunction.h  SendS1F1()  () QƁB
  rtn=_TDSCommSend(m_Fd,0x0000,0,0x8101,0,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


// -----------------------------------------------------------------------------
// S1F2 bZ[W (Host) \zyёM -----------------------------------------

int
CTDSSample1Proc::SendS1F2H(
int					did,		// i  : MPbZ[W DeviceID
unsigned int		xid)		// i  : MPbZ[W TX-ID
{
  TDSECSHead		hd;
  char				msg[256];
  int				rtn,len;

  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),"S1F2_H");
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;
  else		rtn=_TDSCommSend (m_Fd,0x0000,did,0x0102,xid,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


// -----------------------------------------------------------------------------
// S1F2 bZ[W (Equip) \zyёM ----------------------------------------

int
CTDSSample1Proc::SendS1F2E(
int					did,		// i  : MPbZ[W DeviceID
unsigned int		xid)		// i  : MPbZ[W TX-ID
{
  TDSECSHead		hd;
  char				msg[256];
  int				rtn,len;

  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),"S1F2_E");
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;
  else		rtn=_TDSCommSend (m_Fd,0x0000,did,0x0102,xid,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}



// =============================================================================
// S1F21 bZ[W\zyёM ------------------------------------------------

int
CTDSSample1Proc::SendS1F21()
{
  TDSECSHead		hd;
  char				msg[1024];
  int				rtn,len;

	  _TDSMDMssgInit(m_Md,0,msg,sizeof(msg),"S1F21");
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;	// Sample0/SubFunction.h  SendS1F1()  () QƁB
  else		rtn=_TDSCommSend (m_Fd,0x0000,0,0x8100+21,0,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


// -----------------------------------------------------------------------------
// S1F22 bZ[W\zyёM ------------------------------------------------

int
CTDSSample1Proc::SendS1F22(
int					did,		// i  : MPbZ[W DeviceID
unsigned int		xid)		// i  : MPbZ[W TX-ID
{
  TDSECSHead		hd;
  char				msg[1024];
  int				rtn,len;
  
	  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),"S1F22");
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;
  else		rtn=_TDSCommSend (m_Fd,0x0000,did,0x0100+22,xid,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}



// =============================================================================
// S2F49 bZ[W\zyёM ------------------------------------------------

int
CTDSSample1Proc::SendS2F49()
{
  static int		cnt=0;
  TDSECSHead		hd;
  char				msg[1024],itm[32],str[128];
  int				rtn,no1,no2,len,i,j;

  sprintf_s(str,sizeof(str),"LOTID (%4d)",++cnt);
  no1=(cnt%2)+1;	no2=(cnt%10)+1;

  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),"S2F49");
  _TDSMDMssgBuild	(m_Md,0,msg,"LOTID"	, 1,str);			// LOTID
  _TDSMDMssgBuild	(m_Md,0,msg,"NOI1"	, 1,&no1);			// L[no1]
  for(i=0;i<no1;i++){
	sprintf_s(itm,sizeof(itm),"NOI2:%d"				    	,i+1);
	_TDSMDMssgBuild	(m_Md,0,msg,itm		, 1,&no2);			//  L[no2]
	for(j=0;j<no2;j++){
	  sprintf_s(itm,sizeof(itm),"WAFERID:%d:%d"		    	,i+1,j+1);
	  sprintf_s(str,sizeof(str),"WAFER[%04d-%d-%02d]"	,cnt,i+1,j+1);
 	  _TDSMDMssgBuild(m_Md,0,msg,itm	, 0,str);			//   WAFERID
	  sprintf_s(itm,sizeof(itm),"PPID:%d:%d"		    	,i+1,j+1);
	  sprintf_s(str,sizeof(str),"PPID [%04d-%d-%02d]"	,cnt,i+1,j+1);
 	  _TDSMDMssgBuild(m_Md,0,msg,itm	, 0,str);			//   PPID
  } }
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;	// Sample0/SubFunction.h  SendS1F1()  () QƁB
  else		rtn=_TDSCommSend (m_Fd,0x0000,0,0x8200+49,0,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


// -----------------------------------------------------------------------------
// S2F50 bZ[W\zyёM ------------------------------------------------

int
CTDSSample1Proc::SendS2F50(
int					did,		// i  : MPbZ[W DeviceID
unsigned int		xid)		// i  : MPbZ[W TX-ID
{
  static int		cnt=0;
  TDSECSHead		hd;
  char				msg[256],str[128];
  int				rtn,len;
  
  sprintf_s(str,sizeof(str),"LOTID (%4d)",++cnt);

  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),"S2F50");
  _TDSMDMssgBuild   (m_Md,0,msg,"LOTID",  0,str);			//   LOTID
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;
  else		rtn=_TDSCommSend (m_Fd,0x0000,did,0x0200+50,xid,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}



// =============================================================================
// S6F11 bZ[W\zyёM ------------------------------------------------

int
CTDSSample1Proc::SendS6F11()
{
  static int		cnt=0;
  TDSECSHead		hd;
  char				msg[256];
  unsigned short	vs[1];
  int				rtn,len;

  if((++cnt)==65536) cnt=0;		vs[0]=cnt;
  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),"S6F11_0");
  _TDSMDMssgBuild	(m_Md,0,msg,"DATAID",1,vs);				//  DATAID
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;	// Sample0/SubFunction.h  SendS1F1()  () QƁB
  else		rtn=_TDSCommSend (m_Fd,0x0000,0,0x8600+11,0,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}


// -----------------------------------------------------------------------------
// S6F12 bZ[W\zyёM ------------------------------------------------

int
CTDSSample1Proc::SendS6F12(
int					did,		// i  : MPbZ[W DeviceID
unsigned int		xid)		// i  : MPbZ[W TX-ID
{
  TDSECSHead		hd;
  char				msg[256];
  int				rtn,len;

  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),"S6F12");
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;
  else		rtn=_TDSCommSend (m_Fd,0x0000,did,0x0600+12,xid,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}



// =============================================================================
// w胁bZ[Ŵ̃bZ[W\zyёM ----------------------------------

int
CTDSSample1Proc::SendNamedMssg(
char				*name)
{
  TDSECSHead		hd;
  char				msg[4096];		// ő 4096Bytes Ƃ
  int				rtn,len,sf,scd,fcd;

	// bZ[W`t@C̕ύX̎_Ŕf邽߁Aōēx
	// sBƂAbZ[W`t@C̕ύXȂ̂ł΁A
	// ͕̏KvȂB܂Aōď̂́Ǎ _TDSMssgInit()
	// ̏Ɋւ̂łAg[X\͊ς݂̏ɂs
	// ̂ŁAKŐVbZ[W񂪎gpł͂ȂƂɗӂ
	// ƁB
  if(m_Md>0)	_TDSMDMssgTerminate	(m_Md,0);
  m_Md=			_TDSMDMssgInitialize(0x4000,m_Fd,0);

  sscanf_s(name,"S%dF%d"	,&scd,&fcd);
  sf = (scd<<8) | fcd;
  if(scd!=9 && (fcd%2)!=0)	sf |= 0x8000;

  _TDSMDMssgInit	(m_Md,0,msg,sizeof(msg),name);
  len=_TDSMDMssgEnd	(m_Md,0,msg);

  if(len<0)	rtn=len;	// Sample0/SubFunction.h  SendS1F1()  () QƁB
  else		rtn=_TDSCommSend (m_Fd,0x0000,0,sf,0,msg,len,&hd);
  DispData(2,&hd,msg,len,rtn);

  return(rtn);
}



// =============================================================================
// AM ----------------------------------------------------------------

static UINT
ContSend(
void				*par)		// i  : { CLASS CX^Xւ̃|C^
{
  CTDSSample1Proc	*pt;
  int				rtn,no;

  pt=(CTDSSample1Proc*)par;	pt->m_CRun=1;	pt->m_CRunP=0;
  for(pt->m_Stop=no=0; pt->m_Stop==0;){
	Sleep(SEND_WAIT);
	if(pt->m_Stop		!=0)									break;
	if(pt->m_Status		!=2 &&	pt->m_CRunP!=0)					break;
	if(pt->m_Status		==2){	pt->m_CRunP=1;
	  if(pt->m_OType	==0)	rtn=pt->SendS6F11();
	  else						rtn=pt->SendS2F49();
	  if(rtn			< 0)	Sleep(ERROR_SLEEP);
	  else{						no++;
		if((no%SEND_NO)	==0)	Sleep(SEND_SLEEP);
  } } }
  pt->m_Thread=0;	pt->m_Stop=pt->m_CRun=0;

  AfxEndThread(0);
  return(0);
}


void
CTDSSample1Proc::ContSendStart()
{
  if(m_Thread==0)	m_Thread=AfxBeginThread(ContSend,(LPVOID)this);
}


void
CTDSSample1Proc::ContSendStop()
{

  if(m_Thread!=0)	m_Stop=1;
}



// =============================================================================
// Mf[^\B-----------------------------------------------------

int
CTDSSample1Proc::DispData(
int					tp,			// i  : bZ[W
								//		=0 : M
								//		 1 : MbZ[W
								//		 2 : MbZ[W
TDSECSHead			*hd,		// i  : SECS bZ[WEwb_
void				*msg,		// i  : SECS bZ[W{
int					len,		// i  : msg ̒
int					rtn)		// i  : I/O ̖߂l
{
  char				str[128];
  int				err=0,pos=0,ok=0;

  EnterCriticalSection(&m_cs1);
	// ȉ̃Rg͍폜B_TDSMDMssgInitialize() ŃbNw
	// 邱ƂɂAfbhbN͔Ȃ̂ŁAbZ[W݂
	// Ȃ悤AbN{B
	// {\bZ[W݂Ȃ悤ɃbNsׂA
	// {TvɂāA̎_ŃbNsƁAMbZ[W
	// \ƁACӂ̃^C~Oł̑MbZ[W̕\dȂꍇ
	// ɃfbhbNƂȂ\BPȂTvł邱Ƃ
	// ܂AbNs킸A\bZ[W݂̍eB
  if(rtn<0){				ok=1;
    if((rtn<(-E_NOTCONNECT) || (-E_ILLBLOCK)<rtn) && rtn!=(-E_NODATA)){
      if(m_Fd>0) _TDSErrorStatus(m_Fd,&err,&pos);
      sprintf_s(str,sizeof(str),"ERROR  [%d.%d.%d]",rtn,err,pos);
      if      (rtn==(-ENODEV)){
		PO("%s : No such device ID\n%49s"	,str,"");	len=ok=0;
      }else if(rtn==(-E2BIG )){
		PO("%s : Data size to large\n%49s"	,str,"");	len=ok=0;
      }else			PO("%s"					,str);
   	}else{
      sprintf_s(str,sizeof(str),"STATUS = %d : ",-rtn);
      switch(-rtn){
		case E_NODATA:		PO("%sNo data"			,str);		break;
		case E_ILLBLOCK:	PO("%sIllegal block#"	,str);		break;
		case E_T1TIMEDOUT:	PO("%sT1 Timeout occur"	,str);		break;
		case E_T2TIMEDOUT:	PO("%sT2 Timeout occur"	,str);		break;
		case E_T3TIMEDOUT:	PO("%sT3 Timeout occur"	,str);		break;
		case E_T4TIMEDOUT:	PO("%sT4 Timeout occur"	,str);		break;
		case E_T5TIMEDOUT:	PO("%sT5 Timeout occur"	,str);		break;
		case E_T6TIMEDOUT:	PO("%sT6 Timeout occur"	,str);		break;
		case E_T7TIMEDOUT:	PO("%sT7 Timeout occur"	,str);		break;
		case E_T8TIMEDOUT:	PO("%sT8 Timeout occur"	,str);		break;
		case E_RETRYOVER:	PO("%sRetry over"		,str);		break;
		case E_CONNECT:		PO("%sConnected"		,str);		break;
		case E_SELECT:		PO("%sSelected   (0x%04x)"
									,str,hd->did);				break;
		case E_REJECT:		PO("%sRejected XId=0x%04x.0x%04x"
									,str,hd->sid,hd->xid);		break;
		case E_DESELECT:	PO("%sDeselected (0x%04x)"
									,str,hd->did);				break;
		case E_SEPARATE:	PO("%sSeparated  (0x%04x)"
									,str,hd->did);				break;
		case E_NOTCONNECT:	PO("%sNot connected"	,str);		break;
		default:			PO("%s"					,str);		break;
  } } }

  if(ok==0) DispSECSMssg(tp,hd,msg,len);
  LeaveCriticalSection(&m_cs1);

  return(0);
}


// -----------------------------------------------------------------------------
// SECS bZ[W\B -------------------------------------------------

void
CTDSSample1Proc::DispSECSMssg(
int					tp,			// i  : bZ[W
								//		=0 : M
								//		 1 : MbZ[W
								//		 2 : MbZ[W
TDSECSHead			*hd,		// i  : SECS bZ[WEwb_
void				*msg,		// i  : SECS bZ[Wi[̈iwb_܂܂j
int					len)		// i  : SECS bZ[W̃oCg
{
  static char		*ctp[]={"SRES","RECV","SEND"};
  char				str[512],sfcode[12],rbit,wbit;
  int				rtn,md=0,dp,fm,form,noi,la,i;

  rbit=' ';			if((hd->did&0x8000)!=0)	rbit='R';
  wbit=' ';			if((hd->scd&  0x80)!=0)	wbit='W';
  sprintf_s(sfcode,sizeof(sfcode),"S%dF%d",hd->scd&0x7f,hd->fcd);
  PO("[%s]  Dev=0x%04x  %-8s  %c%c  XId=0x%04x.0x%04x  Len=%4d"
			,ctp[tp],hd->did&0x7fff,sfcode,rbit,wbit,hd->sid,hd->xid,len);

  if(msg!=0){
    if(tp==1){		dp=0x30a0;	fm=0xb000;}		// M̏ꍇ
    else{			dp=0x20a0;	fm=0xa000;}		// M̏ꍇ
	if(m_Fd>0 && (md=_TDSMssgFind(fm,msg,len,m_Fd,hd,str))> 0){
      if(str[0]!='\0')	PO("[%s]",str);			// bZ[W
      for(la=0;;){
		rtn=_TDSMssgNextL(md,dp,msg,&form,&noi,str,sizeof(str));
		if(rtn													< 0)	break;
	  	for(i=la;i>rtn;i--)		PO("%*s>",i*2	,"");	// '>' o
		la=rtn;											// ݂̊Kwۑ
		PO("  %s",str);									// ڂ\
		if(form==000 && noi==0)	PO("%*s>",la*2+2,"");	// L0 ̏ꍇ '>' 
	  }
	  for(i=la;i>0;i--)			PO("%*s>",i*2	,"");	// c '>' \
      _TDSMssgExit(md,0,msg);
  } }
}
