
//
// Trust Design LLC : SECS/PLC Communication Connection Program
//
// Pseudo PLC Sample Program
//
// (c) Copyright Trust Design LLC.  2015-2016.  All rights reserved.
//

// =============================================================================
//
// PseudoPLC : eXg y TvEvO
//
//  ^ PLC u𗘗pāAʃzXg SECS ʐMsB
//
//  ^ PLC uƂāAL ({Tvɕtݒt@C
//  tdlSPLC.ini ̐ݒł́ALʖ tdlSPLC00) tAł
//  SECS Message \郁bZ[Wڒl̐ݒA擾sƂɂASECS
//  Message ʐMsBbZ[W̑M^C~ÓAL̃tO
//  ̈̃rbgĎArbgݒɂčsB
//  ڍׂ́AtdlSPLC.exe 戵 (tdlSPLC.pdf) Q͂QƂ邱ƁB
//
//  tdlSPLC ďʃzXgitdlSSim jƐڑB
//  ʃzXg SECS Message MƁA̓e\AKv (ԐM
//  KvȂPbZ[W̎MjɉāAΉQbZ[WԐMB
//  ^ PLC ui{TvĵPbZ[W̑óA҂̎wɂ
//  oΏۂ̂PbZ[WI邱ƂɂsB
//
//
// N@ y @
//
//   PseudoPLC
//   ~~~~~~~~~
//   ʏAtdlSPLC.exe y tdlSSim.exe gpāA^ PLC u𗘗p
//   Windows ł̋L𗘗pASECS ʐM@\Ȃ`o SECS ʐM
//   ɂAʃzXgȉꍇ tdlSSim.exejƐڑ鎖mFB
//
//   {Tv́AR}hEvvgœ삷邪A[Enter] ɂAoΏ
//   PbZ[Ẅꗗ\̂ŁA ID# IL[C邱Ƃɂ
//   ŵPbZ[W𑗏oB
//   ̑Aȉ ID# ̓͂\B
//    0   : {TvEvOI
//    1 - : HOST ɑtPbZ[W̑I
//   97   : ^ PLC ui{Tvj̉ғԂύXiOFF-->ONAON-->OFFj
//   98   : ғԕ (ssb) L '\0' NA
//   99   : L̍ڃf[^wb_̈̓e\
//
//   {Tv́Aُ펞ȗĂB
//   {Tv̑OiDispSxFx()ASendSxFx()ARecvSxFx() e֐j́A{T
//   v̏dvȕł͂ȂB
//
//
//   tdlSPLC.exe ́A../tdlSPLC.exe {fBNgɃRs[ĂNB
//   N [s] j [Jn] ɂAPLC <--> SECS ʐMJnB
//
//   tdlSSim.exe ́AЂgo_E[hAtdlSSim.exe A{fBN
//   gɃRs[ĂN邱ƁB
//   N [] Ƃ tdlSPLC.ini w肵A[ZNV] Ƃ "HOST"
//   w肵 [Start] B
//   ̌ASECS bZ[WꗗyCiẼyCjAMΏۂ̂Pb
//   Z[WIāAM鎖\ƂȂB
//   ̏ڍׂ́AtdlSSim ̎戵 (tdlSSim.pdf) QƂ邱ƁB
//
//
// =============================================================================

#include	<stdio.h>
#include	<signal.h>
#include	<time.h>
#include	<windows.h>
#include	<process.h>


#define		PO		fprintf(stdout	// Wo͂֏o
#define		PE		fprintf(stderr	// WG[֏o

#define		SMKEY		"tdlSPLC00"	// L
#define		SMSIZE		(0x4200)	// L̃TCY
#define		SDSIZE		(SMSIZE-(1*2+1*2+1*2*2+2*2*32))
						// SECS ڃf[^i[̈TCY

#define		INTER0		100		// LĎ


// -----------------------------------------------------------------------------

typedef union{
  char			sc [128];
  short			ss  [ 1];
  int			si  [ 1];
  long long		sl  [ 1];
  unsigned char		uc  [ 1];
  unsigned short	us  [ 1];
  unsigned int		ui  [ 1];
  unsigned long long	ul  [ 1];
  float			fs  [ 1];
  double		fl  [ 1];
} AllType;

typedef struct{
  unsigned char		ssb [ 2];	// Status    bit l (Orbĝݎgp)
  unsigned char		dmy0[ 2];
  unsigned char		hsb [ 2][ 2];	// Handshake bit l (Orbĝݎgp)
  unsigned short	msd [ 2][32];	// SECS Basic data
  unsigned short	ssd [SDSIZE];	// SECS Item  data i[̈
} DevPseudo;


static DevPseudo	*Md=0;			// LEAhX
static int		Break=0;		// IwyуVOiM

static void		ObserveMemory(void*);	// LĎXbh
static void		InterProcess (void*);	// P Message MwXbh



// =============================================================================
// Signal handler ==============================================================

static void
CBSignal(
int		vec)
{
  signal(SIGINT,CBSignal);
  Break=1;
}



// =============================================================================
// SECS bZ[We\ -----------------------------------------------------
// M SECS Message ̃wb_ y bZ[W\鍀ڒl̕\

static char	*DCode[]={"\r>>"   ,"\r<<"};
static char	*DMssg[]={"Send   ","Receive"};


// -----------------------------------------------------------------------------
// S1F1, S1F2 ------------------------------------------------------------------

static void
DispS1F1(
int		io,		// i  : 0: Send  1:Receive
int		fcd)		// i  : F-Code (1 or 2)
{
  int		off;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  if((io==0 && fcd== 2)){
    PO,"MDLN      = %.6s\n"	,&Md->ssd[0x0020+off]);
    PO,"SOFTREV   = %.6s\n"	,&Md->ssd[0x0023+off]);
  }
}


// -----------------------------------------------------------------------------
// S1F13, S1F14 ----------------------------------------------------------------

static void
DispS1F13(
int		io,		// i  : 0: Send  1:Receive
int		fcd)		// i  : F-Code (13 or 14)
{
  int		off;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  if((io==0)){
    PO,"MDLN      = %.6s\n"	,&Md->ssd[0x0020+off]);
    PO,"SOFTREV   = %.6s\n"	,&Md->ssd[0x0023+off]);
  }
}


// -----------------------------------------------------------------------------
// S1F21, S1F22 ----------------------------------------------------------------

static void
DispS1F21(
int		io,		// i  : 0: Send  1:Receive
int		fcd)		// i  : F-Code (21 or 22)
{
  AllType	*at;
  int		off,i;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  at=(AllType*)				(&Md->ssd[0x0029+off]);
  PO,"VB        = 0x%02x,%02x\n"	, at->uc [0],at->uc[1]);
  at=(AllType*)				(&Md->ssd[0x002a+off]);
  PO,"VT        = 0x%02x,%02x\n"	, at->uc [0],at->uc[1]);

  PO,"MDLN      = %.6s\n"		,&Md->ssd[0x0020+off]);
  PO,"SOFTREV   = %.20s\n"		,&Md->ssd[0x0100+off]);
  PO,"COMMENT   = %.80s\n"		,&Md->ssd[0x0110+off]);

  at=(AllType*)				(&Md->ssd[0x013c+off]);
  PO,"VI1       = %d,%d\n"		, at->sc [0],at->sc[1]);
  at=(AllType*)				(&Md->ssd[0x013e+off]);
  PO,"VI2       = %hd,%hd\n"		, at->ss [0],at->ss[1]);
  at=(AllType*)				(&Md->ssd[0x0140+off]);
  PO,"VI4       = %d,%d\n"		, at->si [0],at->si[1]);
  at=(AllType*)				(&Md->ssd[0x0144+off]);
  PO,"VI8       = %lld,%lld\n"		, at->sl [0],at->sl[1]);

  at=(AllType*)				(&Md->ssd[0x014c+off]);
  PO,"VU1       = %u,%u\n"		, at->uc [0],at->uc[1]);
  at=(AllType*)				(&Md->ssd[0x014e+off]);
  PO,"VU2       = %hu,%hu\n"		, at->us [0],at->us[1]);
  at=(AllType*)				(&Md->ssd[0x0150+off]);
  PO,"VU4       = %u,%u\n"		, at->ui [0],at->ui[1]);
  at=(AllType*)				(&Md->ssd[0x0154+off]);
  PO,"VU8       = %llu,%llu\n"		, at->ul [0],at->ul[1]);

  at=(AllType*)				(&Md->ssd[0x015c+off]);
  PO,"AU8       = %llu"			, at->ul [0]);
  for(i=1;i<10;i++) PO,",%llu"		, at->ul [i]);
  PO,"\n");

  at=(AllType*)				(&Md->ssd[0x0184+off]);
  PO,"VF4       = %13.8e,%13.8e\n"	, at->fs [0],at->fs[1]);
  at=(AllType*)				(&Md->ssd[0x0188+off]);
  PO,"VF8       = %22.17le,%22.17le\n"	, at->fl [0],at->fl[1]);
}


// -----------------------------------------------------------------------------
// S2F49, S2F50 ----------------------------------------------------------------

static void
DispS2F49(
int		io,		// i  : 0: Send  1:Receive
int		type)		// i  : 0: S2F49_01
				//	1: S2F49_02
{
  AllType	*at;
  int		off;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  at=(AllType*)			(&Md->ssd[0x11a0+off]);
  PO,"DATAIDB   = 0x%02x\n"	, at->uc [0]);
  PO,"RCMD      = %.10s\n"	,&Md->ssd[0x01a1+off]);

  at=(AllType*)			(&Md->ssd[0x01ab+off]);
  PO,"STID      = 0x%02x\n"	, at->uc [0]);
  at=(AllType*)			(&Md->ssd[0x01ac+off]);
  PO,"MTKD      = 0x%02x\n"	, at->uc [0]);
  PO,"LOTID     = %.20s\n"	,&Md->ssd[0x01ad+off]);

  PO,"WAFERID01 = %.20s\n"	,&Md->ssd[0x0200+off]);
  PO,"PPID01    = %.12s\n"	,&Md->ssd[0x020a+off]);

  if(type==1){
    PO,"WAFERID02 = %.20s\n"	,&Md->ssd[0x0210+off]);
    PO,"PPID02    = %.12s\n"	,&Md->ssd[0x021a+off]);
  }
}


static void
DispS2F50(
int		io)		// i  : 0: Send  1:Receive
{
  AllType	*at;
  int		off;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  at=(AllType*)			(&Md->ssd[0x01a0+off]);
  PO,"HCACK     = 0x%02x\n"	, at->uc [0]);
  PO,"LOTID     = %.20s\n"	,&Md->ssd[0x01a1+off]);
}


// -----------------------------------------------------------------------------
// S5F1, S5F2 ------------------------------------------------------------------

static void
DispS5F1(
int		io,		// i  : 0: Send  1:Receive
int		type)		// i  : 0: S5F1_E1
				//	1: S5F1_E2
{
  AllType	*at;
  int		off;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  at=(AllType*)			(&Md->ssd[0x0200+off]);
  PO,"ALCD      = 0x%02x\n"	, at->uc [0]);
  at=(AllType*)			(&Md->ssd[0x0201+off]);
  PO,"ALID      = %u\n"		, at->us [0]);
  PO,"ALTX      = %.40s\n"	,&Md->ssd[0x0202+off]);
  if(type==1){
    PO,"ALTY      = %.40s\n"	,&Md->ssd[0x0216+off]);
    PO,"ALTZ      = %.40s\n"	,&Md->ssd[0x022c+off]);
  }
}


static void
DispS5F2(
int		io)		// i  : 0: Send  1:Receive
{
  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);
}


// -----------------------------------------------------------------------------
// S6F11, S6F12 ----------------------------------------------------------------

static void
DispS6F11(
int		io,		// i  : 0: Send  1:Receive
int		type)		// i  : 0: S6F11
				//	1: S6F11_T1
				//	2: S6F11_T2
{
  AllType	*at;
  int		off;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  at=(AllType*)			(&Md->ssd[0x0300+off]);
  PO,"DATAID    = %u\n"		, at->us [0]);
  at=(AllType*)			(&Md->ssd[0x0301+off]);
  PO,"CEID      = %u\n"		, at->us [0]);

  if	  (type==0){
    PO,"DATA1     = %.16s\n"	,&Md->ssd[0x0310+off]);
    PO,"DATA2     = %.16s\n"	,&Md->ssd[0x0318+off]);
    PO,"@TIME     = %.14s\n"	,&Md->ssd[0x0320+off]);
  }else if(type==1){
    at=(AllType*)		(&Md->ssd[0x0328+off]);
    PO,"STID1     = 0x%02x\n"	, at->uc [0]);
    PO,"CARRIER1  = %.14s\n"	,&Md->ssd[0x0329+off]);
    at=(AllType*)		(&Md->ssd[0x0330+off]);
    PO,"STID2     = 0x%02x\n"	, at->uc [0]);
    PO,"CARRIER2  = %.14s\n"	,&Md->ssd[0x0331+off]);
  }else if(type==2){
    at=(AllType*)		(&Md->ssd[0x0340+off]);
    PO,"STID      = 0x%02x\n"	, at->uc [0]);
    at=(AllType*)		(&Md->ssd[0x0341+off]);
    PO,"MTKD      = 0x%02x\n"	, at->uc [0]);
    PO,"PODID     = %.5s\n"	,&Md->ssd[0x0343+off]);
    PO,"CASID     = %.5s\n"	,&Md->ssd[0x0346+off]);
    PO,"LOTID     = %.20s\n"	,&Md->ssd[0x0349+off]);
    at=(AllType*)		(&Md->ssd[0x0342+off]);
    PO,"NOWAF     = %u\n"	, at->uc [0]);
  }
}


static void
DispS6F12(
int		io)		// i  : 0: Send  1:Receive
{
  AllType	*at;
  int		off;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  at=(AllType*)			(&Md->ssd[0x0300+off]);
  PO,"ACKC6     = 0x%02x\n"	, at->uc [0]);
}


// -----------------------------------------------------------------------------
// S9Fx ------------------------------------------------------------------------

static void
DispS9Fx(
int		io,		// i  : 0: Send  1:Receive
int		fcd)		// i  : F-Code (1,3,5,7,9,11,13)
{
  AllType	*at;
  int		off,i;

  PO,"%s %s SECS Message\n"	, DCode[io],DMssg[io]);
  PO,"SF-Code   = 0x%04x : %s\n", Md->msd[io][ 0],&Md->msd[io][ 4]);
  PO,"DeviceID  = 0x%04x\n"	, Md->msd[io][ 1]);
  PO,"XID       = 0x%04x,%04x\n", Md->msd[io][ 2], Md->msd[io][ 3]);

  if(io==0)	off=0x0000;
  else		off=0x1000;

  if(fcd<13){
    at=(AllType*)		(&Md->ssd[0x0f00+off]);
    PO,"MHEAD     = 0x%02x"	, at->uc [0]);
    for(i=1;i<10;i++) PO,",%02x", at->uc [i]);
    PO,"\n");
  }else{
    PO,"MEXP      = %.6s\n"	,&Md->ssd[0x0f00+off]);
  }
}



// =============================================================================
// bZ[W\z y MJn --------------------------------------------
// zXg֑M SECS Message ɕKvȏ (SF-CodeÁAڒl) AL
// ɐݒ肵Aݒl\AMJnB
// {TvɂāAe SECS Message \eڂɐݒ肷lɂ́AȂ
// Ӗ͖BbZ[W̑MłĂ̂mF邽߂̖ړI
// ŊeڂɒlݒsB
// S2F50 ̑MɂẮAݒ肷 LOTID 𒼑O S2F49 ̎Mlgp鎖
// AMf[^QƂ̃TvƂB

StrCpy(
void		*dst,
void		*src,
int		sz)
{
  int		len;

//strncpy((char*)dst,char*(src),sz);
// strncpy() ł́Asrc ̕񒷂 dst ̃TCYł sz ꍇ
// dst NAĂȂƁAdst  '\0' ̌ɃS~cꍇA\
// ʖ肪\̂ŁA\ߗ̈ '\0' NAB

  if((len=strlen(src))	> sz)	len=sz;
  memset(dst,'\0',sz);
  memcpy(dst,src ,len);
}


// -----------------------------------------------------------------------------
// S1F1, S1F2 ------------------------------------------------------------------

static void
SendS1F1()
{
  memset(	 Md->msd[0],'\0',sizeof(Md->msd[0]));	// PLC-->PC ̈NA
		 Md->msd[0][  0]=0x8000|( 1<<8)| 1;	// W-Bit + SF-Code
  StrCpy((char*)&Md->msd[0][  4],"S1F1"		,56);	// bZ[W
  DispS1F1(0,1);					// bZ[W\
  Md->hsb[0][  0]=1;					// PLC-->PC Mv
}


static void
SendS1F2()
{
  static int	rev=0;
  char		wc[128];

  memset(	 Md->msd[0],'\0',sizeof(Md->msd[0]));	// PLC-->PC ̈NA
		 Md->msd[0][  0]=0x0000|( 1<<8)| 2;	// W-Bit + SF-Code
			// QbZ[W̏ꍇADeviceIDASourceIDATransaction
			// ID ́AMPbZ[Ŵ̂Rs[B
		 Md->msd[0][  1]=Md->msd[1][  1];	// Device ID
		 Md->msd[0][  2]=Md->msd[1][  2];	// Source ID
		 Md->msd[0][  3]=Md->msd[1][  3];	// Transaction ID
  StrCpy((char*)&Md->msd[0][  4],"S1F2_E"	,56);	// bZ[W

  StrCpy(	&Md->ssd[0x0020],"pSEUDO"	, 6);	// MDLN
  sprintf(wc	,"01.%03d"	,(rev++)%1000);
  StrCpy(	&Md->ssd[0x0023],wc		, 6);	// SOFTREV
  DispS1F1(0,2);					// bZ[W\
  Md->hsb[0][  0]=1;					// PLC-->PC Mv
}


// -----------------------------------------------------------------------------
// S1F13, S1F14 ----------------------------------------------------------------

static void
SendS1F13()
{
  static int	rev=0;
  char		wc[128];

  memset(	 Md->msd[0],'\0',sizeof(Md->msd[0]));
		 Md->msd[0][  0]=0x8000|( 1<<8)|13;
  StrCpy((char*)&Md->msd[0][  4],"S1F13_E"	,56);

  StrCpy(	&Md->ssd[0x0020],"Pseude"	, 6);		// MDLN
  sprintf(wc	,"01.%03d"	,(rev++)%1000);
  StrCpy(	&Md->ssd[0x0023],wc		, 6);		// SOFTREV
  DispS1F13(0,13);
  Md->hsb[0][  0]=1;
}


static void
SendS1F14()
{
  static int	rev=0;
  char		wc[128];

  memset(	 Md->msd[0],'\0',sizeof(Md->msd[0]));
		 Md->msd[0][  0]	=0x0000|( 1<<8)|14;
		 Md->msd[0][  1]	=Md->msd[1][  1];
		 Md->msd[0][  2]	=Md->msd[1][  2];
		 Md->msd[0][  3]	=Md->msd[1][  3];
  StrCpy((char*)&Md->msd[0][  4]	,"S1F14_E"	,56);

		 Md->ssd[0x0028]	=(0x01<<0);		// COMMACK
  StrCpy(	&Md->ssd[0x0020]	,"Pseude"	, 6);	// MDLN
  sprintf(wc	,"01.%03d"	,(rev++)%1000);
  StrCpy(	&Md->ssd[0x0023]	,wc		, 6);	// SOFTREV
  DispS1F13(0,14);
  Md->hsb[0][  0]	=1;
}


// -----------------------------------------------------------------------------
// S1F21, S1F22 ----------------------------------------------------------------

static void
SendS1F21(
int		fcd)		// i  : F-Code (21 or 22)
{
  static int	rev=0;
  static int	vb0=0,vb1=-1,vt0=0,vt1=1;
  static int	vi10=200,vi11=-200,vi20=300,vi21=-300;
  static int	vi40=400,vi41=-400,vi80=500,vi81=-500,au8=10;
  static int	com=1;
  static float	vf40=(float)7.89012345e-12 ,vf41=(float)-4.321098765e31;
  static double	vf80=5.6473829101928374e189,vf81=-3.2109876543210987654e-179;
  AllType	*at;
  char		wc[128];
  int		i;

  memset(		 Md->msd[0],'\0',sizeof(Md->msd[0]));
  if(fcd==21){
			 Md->msd[0][  0]=0x8000|( 1<<8)|21;
    StrCpy((char*)	&Md->msd[0][  4],"S1F21"	,56);
  }else{
			 Md->msd[0][  0]=0x0000|( 1<<8)|22;
			 Md->msd[0][  1]=Md->msd[1][  1];
			 Md->msd[0][  2]=Md->msd[1][  2];
			 Md->msd[0][  3]=Md->msd[1][  3];
    StrCpy((char*)	&Md->msd[0][  4],"S1F22"	,56);
  }

  at=(AllType*)		&Md->ssd[0x0029];
  at->uc[0]=(unsigned char)		((vb0++)&0xff);		// VB
  at->uc[1]=(unsigned char)		((vb1--)&0xff);
  at=(AllType*)		&Md->ssd[0x002a];
  at->uc[0]=(unsigned char)		((vt0++)&0x01);		// VT
  at->uc[1]=(unsigned char)		((vt1--)&0x01);

  StrCpy(		&Md->ssd[0x0020],"PsEuDe"	, 6);	// MDLN
  sprintf(wc	,"01.%03d"		,(rev++)%1000);
  StrCpy(		&Md->ssd[0x0100],wc		, 6);	// SOFTREV
  sprintf(wc	,"This is #%04d comment",com++);
  StrCpy(		&Md->ssd[0x0110],wc		,80);	// COMMENT

  at=(AllType*)		&Md->ssd[0x013c];
  at->sc[0]=(char)			((vi10++)&0xff);	// VI1
  at->sc[1]=(char)			((vi11--)&0xff);
  at=(AllType*)		&Md->ssd[0x013e];
  at->ss[0]=(short)			(vi20++);		// VI2
  at->ss[1]=(short)			(vi21--);
  at=(AllType*)		&Md->ssd[0x0140];
  at->si[0]=				(vi40++);		// VI4
  at->si[1]=				(vi41--);
  at=(AllType*)		&Md->ssd[0x0144];
  at->sl[0]=				(vi80++);		// VI8
  at->sl[1]=				(vi81--);

  at=(AllType*)		&Md->ssd[0x014c];
  at->uc[0]=(unsigned char)		((vi10++)&0xff);	// VU1
  at->uc[1]=(unsigned char)		((vi11--)&0xff);	// VU1
  at=(AllType*)		&Md->ssd[0x014e];
  at->us[0]=(unsigned short)		(vi20++);		// VU2
  at->us[1]=(unsigned short)		(vi21--);
  at=(AllType*)		&Md->ssd[0x0150];
  at->ui[0]=				(vi40++);		// VU4
  at->ui[1]=				(vi41--);
  at=(AllType*)		&Md->ssd[0x0154];
  at->ul[0]=				(vi80++);		// VU8
  at->ul[1]=				(vi81--);

  at=(AllType*)		&Md->ssd[0x015c];
  for(i=0;i< 8;i++)	at->ul[i]=	(au8++);		// AU8

  at=(AllType*)		&Md->ssd[0x0184];
  at->fs[0]=				vf40=(float)(vf40*1.23);// VF4
  at->fs[1]=				vf41=(float)(vf41/2.34);
  at=(AllType*)		&Md->ssd[0x0188];
  at->fl[0]=				vf80*=1.234;		// VF8
  at->fl[1]=				vf81/=1.234;

  DispS1F21(0,fcd);
  Md->hsb[0][  0]=1;
}


// -----------------------------------------------------------------------------
// S2F50 -----------------------------------------------------------------------

static void
SendS2F50()
{
  static int	hcack=0;

  memset(		 Md->msd[0],'\0',sizeof(Md->msd[0]));
			 Md->msd[0][  0]=0x0000|( 2<<8)|50;
			 Md->msd[0][  1]= Md->msd[1][  1];
			 Md->msd[0][  2]= Md->msd[1][  2];
			 Md->msd[0][  3]= Md->msd[1][  3];
  StrCpy((char*)	&Md->msd[0][  4],"S2F50"	 ,56);
			 Md->ssd[0x01a0]=(((hcack++)&0xff)<0);	// HCACK
  StrCpy(		&Md->ssd[0x01a1],&Md->ssd[0x11ad],20);	// LOTID
			// LOTID ́AOɎM S2F49 Ŏw肳ꂽ LOTID 
			// Rs[B
  DispS2F50(0);
  Md->hsb[0][  0]=1;
}


// -----------------------------------------------------------------------------
// S5F1 ------------------------------------------------------------------------

static void
SendS5F1(
int		type)		// i  : 0: S5F1_E1
				//	1: S5F1_E2
{
  static char	*sfname[2]={"S5F1_E1","S5F1_E2"};
  static int	alid=0x01,alno=1;
  AllType	at;
  char		wc[128];

  memset  (		 Md->msd[0],'\0',sizeof(Md->msd[0]));
			 Md->msd[0][  0]=0x8000|( 5<<8)| 1;
  StrCpy  ((char*)	&Md->msd[0][  4],sfname[type]	,56);
			 Md->ssd[0x0200]=0x81;			// ALCD
  at.si[0]=alid++;	 Md->ssd[0x0201]= at.us[0];		// ALID
  sprintf(wc	,"Alarm message #%03d"	,(alno++)%1000);
  StrCpy ((char*)	&Md->ssd[0x0202],wc		,40);	// ALTX
  if(type==1){
    sprintf(wc	,"ALARM MESSAGE #%03d"	,(alno++)%1000);
    StrCpy ((char*)	&Md->ssd[0x0216],wc		,40);	// ALTY
    sprintf(wc	,"#%03d Alarm Test"	,(alno++)%1000);
    StrCpy ((char*)	&Md->ssd[0x022c],wc		,40);	// ALTZ
  }
  DispS5F1(0,type);
  Md->hsb[0][  0]=1;
}


// -----------------------------------------------------------------------------
// S6F11 -----------------------------------------------------------------------

static void
SendS6F11(
int		type)		// i  : 0: S6F11
				//	1: S6F11_T1
				//	2: S6F11_T2
{
  static char		*sfname[]={"S6F11","S6F11_T1","S6F11_T2"};
  static unsigned short	ceid   []={8,9,10};
  static int		dataid=0,dt1=0,dt2=10;
  static int		stid=0,mtkd=0,carid=0;
  AllType		at;
  struct tm		*lt;
  time_t		tm;
  char			wc[128];

  memset(		 Md->msd[0],'\0',sizeof(Md->msd[0]));
			 Md->msd[0][  0]=0x8000|( 6<<8)|11;
  StrCpy((char*)	&Md->msd[0][  4],sfname[type]	,56);
  at.si[0]=dataid++;	 Md->ssd[0x0300]= at.us[0];		// DATAID
			 Md->ssd[0x0301]=ceid  [type];		// CEID
  if      (type==0){
    sprintf(wc	,"Data1 #%03d"		,(dt1++)%1000);
    StrCpy ((char*)	&Md->ssd[0x0310],wc		,16);	// DATA1
    sprintf(wc	,"Data2 #%03d"		,(dt2++)%1000);
    StrCpy((char*)	&Md->ssd[0x0318],wc		,16);	// DATA2
    tm=time(0);		lt=localtime(&tm);
    sprintf(wc	,"%04d%02d%02d%02d%02d%02d"
	,lt->tm_year+1900,lt->tm_mon+1,lt->tm_mday
	,lt->tm_hour	 ,lt->tm_min  ,lt->tm_sec);
    StrCpy (		&Md->ssd[0x0320],wc		,14);	// @TIME
  }else if(type==1){
			 Md->ssd[0x0328]=(((stid++)&0xff)<<0);	// STID1
    sprintf(wc	,"CAR%06d"		, (carid++)%1000000);
    StrCpy ((char*)	&Md->ssd[0x0329],wc		,14);	// CARRIER1
			 Md->ssd[0x0330]=(((stid++)&0xff)<<0);	// STID2
    sprintf(wc	,"CAR%06d"		, (carid++)%1000000);
    StrCpy ((char*)	&Md->ssd[0x0331],wc		,14);	// CARRIER2
  }else if(type==2){
			 Md->ssd[0x0340]=(((stid++)&0xff)<<0);	// STID
			 Md->ssd[0x0341]=(((mtkd++)&0xff)<<0);	// MTKD
    sprintf(wc	,"P%04d"		, (carid++)%10000);
    StrCpy (		&Md->ssd[0x0343],wc		, 5);	// PODID
    sprintf(wc	,"C%04d"		, (carid++)%10000);
    StrCpy (		&Md->ssd[0x0346],wc		, 5);	// CASID
    sprintf(wc	,"LOT%06d"		, (carid++)%1000000);
    StrCpy ((char*)	&Md->ssd[0x0349],wc		,20);	// LOTID
			 Md->ssd[0x0342]=(((stid++)%  26)<<0);	// NOWAF
  }

  DispS6F11(0,type);
  Md->hsb[0][  0]=1;
}



// =============================================================================
// bZ[W --------------------------------------------------------------
// zXgM SECS Message ́i{Tvł́ASECS Message ڒl
// \j

// -----------------------------------------------------------------------------
// S1F1, S1F2 ------------------------------------------------------------------

static void
RecvS1F1(
int		fcd)		// i  : F-Code (1 or 2)
{
  DispS1F1(1,fcd);
}


// -----------------------------------------------------------------------------
// S1F13, S1F14 ----------------------------------------------------------------

static void
RecvS1F13(
int		fcd)		// i  : F-Code (13 or 14)
{
  DispS1F13(1,fcd);
}


// -----------------------------------------------------------------------------
// S1F21, S1F22 ----------------------------------------------------------------

static void
RecvS1F21(
int		fcd)		// i  : F-Code (21 or 22)
{
  DispS1F21(1,fcd);
}


// -----------------------------------------------------------------------------
// S2F49 -----------------------------------------------------------------------

static void
RecvS2F49(
int		type)		// i  : 0: S2F49_01
				//	1: S2F49_02
{
  DispS2F49(1,type);
}


// -----------------------------------------------------------------------------
// S5F2 ------------------------------------------------------------------------

static void
RecvS5F2()
{
  DispS5F2(1);
}


// -----------------------------------------------------------------------------
// S6F12 -----------------------------------------------------------------------

static void
RecvS6F12()
{
  DispS6F12(1);
}


// -----------------------------------------------------------------------------
// S9Fx ------------------------------------------------------------------------

static void
RecvS9Fx(
int		fcd)		// i  : Function code (1,3,5,7,9,11,13)
{
  DispS9Fx(1,fcd);
}



// =============================================================================
// Main  -------------------------------------------------------------------
// E L̊t
// E XbhiLĎAPbZ[Woj̋N
// E JniPLC NjLɐݒ
// E IwiPbZ[WoXbhł Break!=0 ݒj҂
// E IiPLC ~jLɐݒ
// E LJďI

int
main(
int			argc,
char			*argv[])
{
  HANDLE		sd;
  int			ok0=0;

  signal(SIGINT,CBSignal);
							// Lt
  if(  (sd=  OpenFileMapping(FILE_MAP_ALL_ACCESS,0,SMKEY))	==0){	ok0=1;
    if((sd=CreateFileMapping(INVALID_HANDLE_VALUE,0
			,PAGE_READWRITE,0,SMSIZE,SMKEY))	==0){
      PE,"LtG[\n");					exit(1);
  } }
  Md=(DevPseudo*)MapViewOfFile(sd,FILE_MAP_ALL_ACCESS,0,0,SMSIZE);
  if(ok0!=0)	memset(Md,'\0',SMSIZE);			// Create Ȃ珉

  _beginthread(ObserveMemory,0,0);			// ĎXbh
  _beginthread(InterProcess ,0,0);			// PbZ[WM

  Md->ssb[0]=1;						// PLC N
  for(Break=0;Break==0;)	Sleep(500);		// Iw܂Ń[v
  Sleep(500);						// `bg҂
  Md->ssb[0]=0;						// PLC ~

  UnmapViewOfFile(Md);					// LJ
  CloseHandle    (sd);

  exit(0);
}



// =============================================================================
// LĎXbh ------------------------------------------------------
// E IwiBreak!=0j܂Ŗ[v
// E ŏs
// E L̃tÖihsb[][]jĎ
//   E bZ[WM
//   E bZ[WM
//   E bZ[WM
//     E MbZ[WɊւ鏈
//     E MbZ[WԐMKvȂPbZ[W̏ꍇQbZ|WM

static void
ObserveMemory(
void		*par)
{
  char		*mname;

  for(;Break==0;){					// Iw܂Ń[v
    Sleep(INTER0);					// Ď
  //if(	 Md->ssb[1]	==0)	continue;		// PC ғ

    if(	 Md->hsb[0][0]	!=0){				// PC ֑M
      if(Md->hsb[0][1]	!=0)	Md->hsb[0][0]	= 0;	// PC MȂI
    }

    if(	 Md->hsb[1][1]	==0){				// PC  Mw
      if(Md->hsb[1][0]	!=0)	Md->hsb[1][0]	= 0;	// PLC M

    }else{						// PC  Mw
      if(Md->hsb[1][0]	==0){				// PLC Ȃ
	mname=(char*)(&Md->msd[1][4]);			// SECS Message 
	// bZ[W`t@CɋK肷AuMΏۃbZ[W̑SĂ
	// ȉɂďBԐMKvȂPbZ[W̏ꍇ́AM
	// ΉQbZ[W𑗐MB
	if      (strcmp(mname,"S1F1"    )==0){	RecvS1F1 ( 1);	SendS1F2 ();
	}else if(strcmp(mname,"S1F2_H"  )==0){	RecvS1F1 ( 2);
	}else if(strcmp(mname,"S1F13_H" )==0){	RecvS1F13(13);	SendS1F14();
	}else if(strcmp(mname,"S1F14_H" )==0){	RecvS1F13(14);
	}else if(strcmp(mname,"S1F21"   )==0){	RecvS1F21(21);	SendS1F21(22);
	}else if(strcmp(mname,"S1F22"   )==0){	RecvS1F21(22);
	}else if(strcmp(mname,"S2F49_01")==0){	RecvS2F49( 0);	SendS2F50();
	}else if(strcmp(mname,"S2F49_02")==0){	RecvS2F49( 1);	SendS2F50();
	}else if(strcmp(mname,"S5F2"    )==0){	RecvS5F2 ();
	}else if(strcmp(mname,"S5F2_E2" )==0){	RecvS5F2 ();
	}else if(strcmp(mname,"S6F12"   )==0){	RecvS6F12();
	}else if(strcmp(mname,"S9F1"    )==0){	RecvS9Fx ( 1);
	}else if(strcmp(mname,"S9F3"    )==0){	RecvS9Fx ( 3);
	}else if(strcmp(mname,"S9F5"    )==0){	RecvS9Fx ( 5);
	}else if(strcmp(mname,"S9F7"    )==0){	RecvS9Fx ( 7);
	}else if(strcmp(mname,"S9F9"    )==0){	RecvS9Fx ( 9);
	}else if(strcmp(mname,"S9F11"   )==0){	RecvS9Fx (11);
	}else if(strcmp(mname,"S9F13_0" )==0){	RecvS9Fx (13);
	}else if(strcmp(mname,"S9F13_1" )==0){	RecvS9Fx (13);
	}else if(strcmp(mname,"S9F13_2" )==0){	RecvS9Fx (13);
	}else if(strcmp(mname,"S9F13_3" )==0){	RecvS9Fx (13);
	}else{
	  PE,"Illegal SECS message received [S%dF%d:%s]\n"
		,(Md->msd[1][0]&0x7f)>>8,(Md->msd[1][0]&0xff),mname);
	}
	// ŁAM񍐂BQbZ[W̕ԐMKvȏꍇAQ
	// bZ[W̍\zɁAPbZ[W TransactionID KvƂȂ
	// ŁAQbZ[W̍\z SendSxFx() ōsłȂƁAM
	// 񍐂Ă͂ȂB]āAM RecvSxFx() ōsƂ
	// łȂB
				Md->hsb[1][0]	= 1;	// PLC M
  } } }
}



// =============================================================================
// PbZ[WMwXbh ----------------------------------------------
// o\ȂPbZ[Wꗗ\AoPbZ[WIB
// IbZ[W SendSxFx() ֐ɂ苤Lɏݒ肷邱Ƃ
//  tdlSPLC.exe ďʃzXgɑMB
// ̑Aȉ̏sB
//  0 : {Tv`ȍIw
// 97 : {Tv̉ғԁissb[0]jݒ
// 98 : L̃NA
// 99 : Le̕\

static void
InterProcess(
void		*par)
{
  unsigned char	ssb[ 2];
  char		str[32];
  int		req;

  for(;Break==0;){
    PE,"\rMPbZ[WIĂ\n");
    PE,"  0: Exit   97: Toggle Status 98: All clear   99: Display\n");
    PE,"  1: S1F1    2: S1F13          3: S1F21\n");
    PE,"  4: S5F1_E1 5: S5F1_E2\n");
    PE,"  6: S6F11   7: S6F11_T1       8: S6F11_T2\n");
    PE,"MPbZ[W : ");
    fgets(str,sizeof(str)-1,stdin);
    req=(-1);	sscanf(str,"%d",&req);
    if(0<req && req<90){	// ݑM\ۂ`FbN
      if	(Md->ssb[0]   ==0){
	PE,"PLC ͎gp\ԂłȂ߁AMł܂\n");	       continue;
      }else if	(Md->ssb[1]   ==0){
	PE,"PC ͎gp\ԂłȂ߁AMł܂\n");	       continue;
      }else if	(Md->hsb[0][0]!=0 || Md->hsb[0][1]!=0){
	PE," SECS Message M̂߁AMł܂\n");	       continue;
      }else if	(Md->hsb[1][0]!=0 || Md->hsb[1][1]!=0){
	PE," SECS Message M̂߁AMł܂\n");	       continue;
    } }

    switch(req){
      case  0:	Break	= 1;						  break;
      case  1:	SendS1F1 ();						  break;
      case  2:	SendS1F13();						  break;
      case  3:	SendS1F21(21);						  break;
      case  4:	SendS5F1 (0);						  break;
      case  5:	SendS5F1 (1);						  break;
      case  6:	SendS6F11(0);						  break;
      case  7:	SendS6F11(1);						  break;
      case  8:	SendS6F11(2);						  break;
      case 97:	Md->ssb[0]=1-Md->ssb[0];				  break;
      case 98:	ssb[0]=Md->ssb[0];	 ssb[1]=Md->ssb[1];	// ssb ͕ۑ
		memset(Md,'\0',SMSIZE);				// S̈NA
		Md->ssb[0]=ssb[0];	 Md->ssb[1]=ssb[1];		  break;
      case 99:	PO,"ssb  = %d, %d\n"	,Md->ssb[0]	, Md->ssb[1]);
		PO,"hsb.0= %d, %d\n"	,Md->hsb[0][0]	, Md->hsb[0][1]);
		PO,"hsb.1= %d, %d\n"	,Md->hsb[1][0]	, Md->hsb[1][1]);
		PO,"msd.0= 0x%04x,0x%04x:0x%04x,0x%04x:%s\n"
			,Md->msd[0][0]	,Md->msd[0][1]
			,Md->msd[0][2]	,Md->msd[0][3]	,&Md->msd[0][4]);
		PO,"msd.1= 0x%04x,0x%04x:0x%04x,0x%04x:%s\n"
			,Md->msd[1][0]	,Md->msd[1][1]
			,Md->msd[1][2]	,Md->msd[1][3]	,&Md->msd[1][4]); break;
  } }
}
