
// =============================================================================
// Stream#1 : Equipment status

// -----------------------------------------------------------------------------
// Abort transaction
//
S1F0



// -----------------------------------------------------------------------------
// Are you there
//
S1F1		W


S1F2_E		E
  <L[2]
    <A[6]MDLN           "EQUIP1">
    <A[6]SOFTREV        "01.000">
  >

S1F2_H		H
  <L[0]
  >



// -----------------------------------------------------------------------------
// Selected equipment status
//

S1F3		HW
  <L[N]NOI1
    <U1[1]SVID>
  >


S1F4		E
  <L[N]NOI1
    <U1[1]SV>
  >



// -----------------------------------------------------------------------------
// Formatted status request
//
S1F5		HW
  <B[1]SFCD>


S1F6		E
  <L[N]NOI1
    <U1[1]SV>
  >



// -----------------------------------------------------------------------------
// Fixed form request
//
S1F7		HW
  <B[1]SFCD>


S1F8		E
  <L[N]NOI1
    <L[2]
      <A [6]NM          "SV    ">
      <U1[1]SV>
    >
  >



// -----------------------------------------------------------------------------
// Material transfer status
//
S1F9		HW

S1F10		E
  <L[2]
    <B[0..10]TSIP>
    <B[0..10]TSOP>
  >



// -----------------------------------------------------------------------------
// Status variable name list request
//
S1F11		HW
  <L[N]NOI1
    <U1[1]SVID>
  >


S1F12		E
  <L[N]NOI1
    <L[3]
      <U1[1]SVID>
      <A [6]SVNAME>
      <A [6]UNITS>
    >
  >



// -----------------------------------------------------------------------------
// Establish communication request
//
S1F13_H		HW
  <L[0]
  >

S1F14_E		E
  <L[2]
    <B[1]COMMACK>
    <L[2]
      <A[6]MDLN         "EQUIP1">
      <A[6]SOFTREV      "01.000">
    >
  >


S1F13_E		EW
  <L[2]
    <A[6]MDLN           "EQUIP1">
    <A[6]SOFTREV        "01.000">
  >

S1F14_H		H
  <L[0]
  >



// -----------------------------------------------------------------------------
// Request Offline
//
S1F15		HW

S1F16		E
  <B[1]OFLACK>



// -----------------------------------------------------------------------------
// Request Online
//
S1F17		HW

S1F18		E
  <B[1]ONLACK>



// -----------------------------------------------------------------------------
// Get attribute request
//
S1F19		W
  <L[3]
    <A[6]OBJTYPE>
    <L[N]NOI1
      <A[8]OBJID>
    >
    <L[N]NOI2
      <A[6]ATTRID>
    >
  >


S1F20
  <L[2]
    <L[N]NOI1
      <L[N]NOI2
	<A[20]ATTRDATA>
      >
    >
    <L[N]NOI3
      <L[2]
	<U1[1]ERRCODE>
	<A[80]ERRTEXT>
      >
    >
  >



// =============================================================================
// Stream#2 : Equipment control and diagnostic

// -----------------------------------------------------------------------------
// Abort transaction
//
S2F0



// -----------------------------------------------------------------------------
// Service program load inquire
//
S2F1		W
  <L[2]
    <A [6]SPID>
    <U4[1]LENGTH>
  >


S2F2
  <B[1]GRANT>



// -----------------------------------------------------------------------------
// Service program send
//
S2F3		W
  <B[0..16777215]SPD>


S2F4
  <B[1]SPAACK>



// -----------------------------------------------------------------------------
// Service program load
//
S2F5		W
  <A[6]SPID>


S2F6
  <B[0..16777215]SPD>



// -----------------------------------------------------------------------------
// Service program run
//
S2F7		HW
  <A[6]SPID>


S2F8		E
  <B[1]CSAACK>



// -----------------------------------------------------------------------------
// Service program result
//
S2F9		HW
  <A[6]SPID>


S2F10		E
  <I2[1]SPR>



// -----------------------------------------------------------------------------
// Service program directory request
//
S2F11		W


S2F12
  <L[N]NOI1
    <A[6]SPID>
  >



// -----------------------------------------------------------------------------
// Equipment constant request
//
S2F13		HW
  <L[N]NOI1
    <U1[1]ECID>
  >


S2F14		E
  <L[N]NOI1
    <I4[1]ECV>
  >



// -----------------------------------------------------------------------------
// New equipment constant send
//
S2F15		HW
  <L[1..255]NOI1
    <L[2]
      <U1[1]ECID>
      <I4[1]ECV>
    >
  >


S2F16		E
  <B[1]EAC>



// -----------------------------------------------------------------------------
// Date and time request
//
S2F17		W

S2F18
  <A[0..12]@TIME "YYMMDDhhmmss">



// -----------------------------------------------------------------------------
// Reset/Initialize send
//
S2F19		HW
  <U1[1]RIC>

S2F20		E
  <U1[1]RAC>



// -----------------------------------------------------------------------------
// Remort command send
//
S2F21		HW
  <U1[1]RCMD>

S2F22		E
  <U1[1]CMDA>



// -----------------------------------------------------------------------------
// Trace initialize send
//
S2F23		HW
  <L[5]
    <A [6]TRID>
    <A [6]DSPER>
    <U4[1]TOTSMP>
    <U2[1]REPGSZ>
    <L [N]NOI1
      <U1[1]SVID>
    >
  >

S2F24		E
  <B[1]TIAACK>



// -----------------------------------------------------------------------------
// Loopback diagnostic request
//
S2F25		W
  <B[0..16777215]ABS>

S2F26
  <B[0..16777215]ABS>



// -----------------------------------------------------------------------------
// Initiate processing request
//
S2F27		HW
  <L[3]
    <B[ 1]LOC>
    <A[16]PPID>
    <L[N ]NOI1
      <A[16]MID>
    >
  >


S2F28		E
  <U1[1]CMDA>



// -----------------------------------------------------------------------------
// Equipment constant name list request
//
S2F29		HW
  <L[N]NOI1
    <U1[1]ECID>
  >


S2F30		E
  <L[N]NOI1
    <L[6]
      <U1[ 1]ECID>
      <A [20]ECNAME>
      <U2[ 1]ECMIN>
      <U2[ 1]ECMAX>
      <I4[ 1]ECDEF>
      <A [ 6]UNIT>
    >
  >



// -----------------------------------------------------------------------------
// Date and time set
//
S2F31		HW
  <A[12]@TIME "YYMMDDhhmmss">


S2F32		E
  <B[1]TIACK>



// -----------------------------------------------------------------------------
// Define report
//
S2F33		HW
  <L[2]
    <U2[1]DATAID>
    <L [N]NOI1
      <L[2]
        <U1[1]RPTID>
        <L [N]NOI2
	  <U2[1]VID>
        >
      > 
    >
  >


S2F34		E
  <B[1]DRACK>



// -----------------------------------------------------------------------------
// Link event report
//
S2F35		HW
  <L[2]
    <U2[1]DATAID>
    <L [N]NOI1
      <L[2]
	<U1[1]CEID>
	<L [N]NOI2
	  <U1[1]RPTID>
	>
      >
    >
  >


S2F36		E
  <B[1]LRACK>



// -----------------------------------------------------------------------------
// Enable/Disable event report
//
S2F37		HW
  <L[2]
    <T[1]CEED>
    <L[N]NOI1
      <U1[1]CEID>
    >
  >


S2F38		E
  <B[1]ERACK>



// -----------------------------------------------------------------------------
// Multi-block inquire
//
S2F39		HW
  <L[2]
    <U2[1]DATAID>
    <U4[1]DATALENGTH>
  >


S2F40		E
  <B[1]GRANT>



// -----------------------------------------------------------------------------
// Host command send
//
S2F41		HW
  <L[2]
    <U1[1]RCMD>
    <L [N]NOI1
      <L[2]
	<A[12]CPNAME>
	<A[24]CPVAL>
      >
    >
  >


S2F42		E
  <L[2]
    <B[1]HCACK>
    <L[N]NOI1
      <L[2]
	<A[12]CPNAME>
	<B[1]CPACK>
      >
    >
  >



// -----------------------------------------------------------------------------
// Reset spooling streams and functions
//
S2F43		HW
  <L[N]NOI1
    <L[2]
      <U1[1]STRID>
      <L [N]NOI2
	<U1[1]FCNID>
      >
    >
  >


S2F44		E
  <L[2]
    <B[1]RSPACK>
    <L[N]NOI1
      <L[3]
	<U1[1]STRID>
	<B [1]STRACK>
	<L [N]NOI2
	  <U1[1]FCNID>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Define variable limit attributes
//
S2F45		HW
  <L[2]
    <U2[1]DATAID>
    <L [N]NOI1
      <L[2]
	<U2[1]VID>
	<L [N]NOI2
	  <L[2]
	    <B[1]LIMITID>
	    <L[0|2]NOI3
	      <I4[1]UPPERDB>
	      <I4[1]LOWERDB>
	    >
	  >
	>
      >
    >
  >


S2F46		E
  <L[2]
    <B[1]VLAACK>
    <L[N]NOI1
      <L[3]
	<U2[1]VID>
	<B [1]LVACK>
	<L [0|2]NOI3
	  <B[1]LIMITID1>
	  <B[1]LIMITACK>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Variable limit attribute request
//
S2F47		HW
  <L[N]NOI1
    <U2[1]VID>
  >


S2F48		E
  <L[N]NOI1
    <L[2]
      <U2[1]VID>
      <L [0|4]NOI2
	<A [6]UNITS>
	<I4[1]LIMITMIN>
	<I4[1]LIMITMAX>
	<L [N]NOI3
	  <L[3]
	    <B [1]LIMITID>
	    <I4[1]UPPERDB>
	    <I4[1]LOWERDB>
	  >
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Enhanced remote command
//
S2F49		HW
  <L[4]
    <U2[1]DATAID>
    <A [8]OBJSPEC>
    <U1[1]RCMD>
    <L [N]NOI1
      <L[2]
	<A[12]CPNAME>
	<A[24]CEPVAL>
      >
    >
  >


S2F50		E
  <L[2]
    <B[1]HCACK>
    <L[N]NOI1
      <L[2]
	<A [12]CPNAME>
	<U1[ 1]CEPACK>
      >
    >
  >



// =============================================================================
// Stream#3 : Material status

// -----------------------------------------------------------------------------
// Abort transaction
//
S3F0



// -----------------------------------------------------------------------------
// Material status request
//
S3F1		HW

S3F2		E
  <L[2]
    <B[1]MF>
    <L[N]NOI1
      <L[3]
	<B[ 1]LOC>
	<B[ 1]QUA>
	<A[16]MID>
      >
    >
  >



// -----------------------------------------------------------------------------
// Time to completion request
//
S3F3		HW

S3F4		E
  <L[2]
    <B[1]MF>
    <L[N]NOI1
      <L[3]
	<U4[ 1]TTC>
	<B [ 1]QUA>
	<A [16]MID>
      >
    >
  >



// -----------------------------------------------------------------------------
// Material found send
//
S3F5		EW
  <L[2]
    <B[1]MF>
    <B[1]QUA>
  >

S3F6		H
  <B[1]ACKC3>



// -----------------------------------------------------------------------------
// Material lost send
//
S3F7		EW
  <L[3]
    <B[ 1]MF>
    <B[ 1]QUA>
    <A[16]MID>
  >

S3F8		H
  <B[1]ACKC3>



// -----------------------------------------------------------------------------
// Material ID equate send
//
S3F9		EW
  <L[2]
    <A[16]MID>
    <A[16]EMID>
  >

S3F10		H
  <B[1]ACKC3>



// -----------------------------------------------------------------------------
// Material ID request
//
S3F11		EW
  <B[1]PTN>

S3F12		H
  <L[3]
    <B[ 1]PTN>
    <B[ 1]MIDRA>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Material ID send
//
S3F13		HW
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >

S3F14		E
  <B[1]MIDAC>



// -----------------------------------------------------------------------------
// Material Multi-block inquire
//
S3F15		HW
  <L[2]
    <U2[1]DATAID>
    <U4[1]DATALENGTH>
  >


S3F16		E
  <B[1]GRANT>



// -----------------------------------------------------------------------------
// Carrier function request
//
S3F17		HW
  <L[5]
    <U2[1]DATAID>
    <A [8]CARRIERACTION>
    <A [8]CARRIERSPEC>
    <B [1]PTN>
    <L [N]NOI1
      <L[2]
	<A[ 6]CATTRID>
	<A[20]CATTRDATA>
      >
    >
  >


S3F18		E
  <L[2]
    <U1[1]CAACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Cancel carrier out
//
S3F19		HW

S3F20		E
  <L[2]
    <U1[1]CAACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Port group define request
//
S3F21		HW
  <L[3]
    <A[ 8]PORTGRPNAME>
    <A[16]PORTACCESS>
    <L[N ]NOI1
      <B[1]PTN>
    >
  >


S3F22		E
  <L[2]
    <U1[1]CAACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Port group action request
//
S3F23		HW
  <L[3]
    <A[16]PGRPACTION>
    <A[ 8]PORTGROUPNAME>
    <L[N ]NOI1
      <L[2]
	<A [8]PARAMNAME>
	<I4[1]PARAMVAL>
    >
  >


S3F24		E
  <L[2]
    <U1[1]CAACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Port action request
//
S3F25		HW
  <L[3]
    <A[16]PORTACTION>
    <B[ 1]PTN>
    <L[N ]NOI1
      <L[2]
	<A [8]PARAMNAME>
	<I4[1]PARAMVAL>
    >
  >


S3F26		E
  <L[2]
    <U1[1]CAACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// =============================================================================
// Stream#4 : Material control

// -----------------------------------------------------------------------------
// Abort transaction
//
S4F0



// -----------------------------------------------------------------------------
// Ready to send materials
//
S4F1		W
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >


S4F2
  <B[1]RSACK>



// -----------------------------------------------------------------------------
// Send material
//
S4F3
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Handshake complete
//
S4F5
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Not ready to send
//
S4F7
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Stuck in sender
//
S4F9		E
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Stuck in receiver
//
S4F11		E
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Send incomplete timeout
//
S4F13		E
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Material received
//
S4F15		E
  <L[2]
    <B[ 1]PTN>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// Request to receive
//
S4F17		W
  <L[2]
    <B[1]PTN>
    <A[0..16]MID>
  >


S4F18
  <B[1]RRACK>



// -----------------------------------------------------------------------------
// Transfer job create
//
S4F19		HW
  <L[2]
    <U2[1]DATAID>
    <L [2]
      <A[8]TRJOBNAME>
      <L[N]NOI1
	<L[12]
	  <U2[ 1]TRLINK>
	  <U1[ 1]TRPORT>
	  <A [16]TROBJNAME>
	  <U1[ 1]TROBJTYPE>
	  <U1[ 1]TRROLE>
	  <A [80]TRRCP>
	  <A [16]TRPTNR>
	  <U1[ 1]TRPTPORT>
	  <U1[ 1]TRDIR>
	  <U1[ 1]TRTYPE>
	  <U1[ 1]TRLOCATION>
	  <T [ 1]TRAUTOSTART>
	>
      >
    >
  >


S4F20		E
  <L[3]
    <B[1]TRJOBID>
    <L[2]
      <U2[1]TRATOMICID1>
      <U2[1]TRATOMICID2>
    <L[2]
      <T[1]TRACK>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Transfer job command
//
S4F21		HW
  <L[3]
    <B[ 1]TRJOBID>
    <A[16]TRCMDNAME>
    <L[N ]NOI1
      <L[2]
	<A[12]CPNAME>
	<A[24]CPVAL>
      >
    >
  >


S4F22		E
  <L[2]
    <T[1]TRACK>
    <L[N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Transfer job alert
//
S4F23		EW
  <L[4]
    <B [1]TRJOBID>
    <A [8]TRJOBNAME>
    <U1[1]TRJOBMS>
    <L [2]
      <T[1]TRACK>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >


S4F24		H



// -----------------------------------------------------------------------------
// Material trasnfer multi-block inquire
//
S4F25		HW
  <L[2]
    <U2[1]DATAID>
    <U4[1]DATALENGTH>
  >


S4F26		E
  <B[1]GRANT>



// -----------------------------------------------------------------------------
// Handoff ready
//
S4F27
  <L[2]
    <A[20]EQNAME>
    <L[10]
      <U2[ 1]TRLINK>
      <U1[ 1]TRPORT>
      <A [16]TROBJNAME>
      <U1[ 1]TROBJTYPE>
      <U1[ 1]TRROLE>
      <A [16]TRPTNR>
      <U1[ 1]TRPTPORT>
      <U1[ 1]TRDIR>
      <U1[ 1]TRTYPE>
      <U1[ 1]TRLOCATION>
    >
  >



// -----------------------------------------------------------------------------
// Handoff command
//
S4F29
  <L[4]
    <U2[ 1]TRLINK>
    <U2[ 1]MCINDEX>
    <A [16]HOCMDNAME>
    <L [N ]NOI1
      <L[2]
	<A[12]CPNAME>
	<A[24]CPVAL>
      >
    >
  >



// -----------------------------------------------------------------------------
// Handoff command complete
//
S4F31
  <L[3]
    <U2[1]TRLINK>
    <U2[1]MCINDEX>
    <L [2]
      <T[1]HOACK>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Handoff verified
//
S4F33
  <L[2]
    <U2[1]TRLINK>
    <L [2]
      <T[1]HOACK>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Handoff cancel ready
//
S4F35
  <U2[1]TRLINK>



// -----------------------------------------------------------------------------
// Handoff cancel ready acknoowledge
//
S4F37
  <L[2]
    <U2[1]TRLINK>
    <T [1]HOCANCELACK>
  >



// -----------------------------------------------------------------------------
// Handoff halt
//
S4F39
  <U2[1]TRLINK>



// -----------------------------------------------------------------------------
// Handoff halt acknoowledge
//
S4F41
  <L[2]
    <U2[1]TRLINK>
    <T [1]HOCANCELACK>
  >



// =============================================================================
// Stream#5 : Exception report

// -----------------------------------------------------------------------------
// Abort transaction
//
S5F0



// -----------------------------------------------------------------------------
// Alarm report send
//
S5F1		EW
  <L[3]
    <B [    1]ALCD>
    <U2[    1]ALID>
    <A [0..40]ALTX>
  >


S5F2		H
  <B[1]ACKC5>



// -----------------------------------------------------------------------------
// Enable/Disable alarm send
//
S5F3		HW
  <L[2]
    <B[1]ALED>
    <B[1]ALCD>
  >


S5F4		E
  <B[1]ACKC5>



// -----------------------------------------------------------------------------
// List alarm request
//
S5F5		HW
  <U2[0..256]ALID>


S5F6		E
  <L[N]NOI1
    <L[3]
      <B [    1]ALCD>
      <U2[    1]ALID>
      <A [0..40]ALTX>
    >
  >



// -----------------------------------------------------------------------------
// List enabled alarm request
//
S5F7		HW


S5F8_E		E
  <L[N]NOI1
    <L[3]
      <B [    1]ALCD>
      <U2[    1]ALID>
      <A [0..40]ALTX>
    >
  >



// -----------------------------------------------------------------------------
// Exception post notify
//
S5F9		EW
  <L[5]
    <A[16]TIMESTAMP     "YYYYMMDDhhmmsscc">
    <A[20]EXID>
    <A[ 8]EXTYPE>
    <A[40]EXMESSAGE>
    <L[N ]NOI1
      <A[40]EXRECVRA>
    >
  >


S5F10		H



// -----------------------------------------------------------------------------
// Exception clear notify
//
S5F11		EW
  <L[4]
    <A[16]TIMESTAMP     "YYYYMMDDhhmmsscc">
    <A[20]EXID>
    <A[ 8]EXTYPE>
    <A[40]EXMESSAGE>
  >

S5F12		H



// -----------------------------------------------------------------------------
// Exception recover request
//
S5F13		EW
  <L[2]
    <A[20]EXID>
    <A[40]EXRECVRA>
  >


S5F14		H
  <L[2]
    <A[20]EXID>
    <L[ 2]
      <T[  1]ACKA>
      <L[0|2]NOI1
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Exception recover conplete notify
//
S5F15		EW
  <L[3]
    <A[16]TIMESTAMP "YYYYMMDDhhmmsscc">
    <A[20]EXID>
    <L[ 2]
      <T[  1]ACKA>
      <L[0|2]NOI1
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >


S5F16		H



// -----------------------------------------------------------------------------
// Exception recover abort request
//
S5F17		HW
  <A[20]EXID>


S5F18		E
  <L[2]
    <A[20]EXID>
    <L[ 2]
      <T[  1]ACKA>
      <L[0|2]NOI1
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// =============================================================================
// Stream#6 : Data collection

// -----------------------------------------------------------------------------
// Abort transaction
//
S6F0



// -----------------------------------------------------------------------------
// Trace data send
//
S6F1		EW
  <L[4]
    <A [6     ]TRID>
    <U2[1     ]SMPLN>
    <A [12..16]STIME>
    <L [N     ]NOI1
      <U1[1]SV>
    >
  >


S6F2		H
  <B[1]ACKC6>



// -----------------------------------------------------------------------------
// Discrete variable data send
//
S6F3		EW
  <L[3]
    <U2[1]DATAID>
    <U1[1]CEID>
    <L [N]NOI1
      <L[2]
	<U2[1]DSID>
	<L [N]NOI2
	  <L[2]
	    <A[ 6]DVNAME>
	    <A[16]DVVAL>
	  >
	>
      >
    >
  >


S6F4		H
  <B[1]ACKC6>



// -----------------------------------------------------------------------------
// Material Multi-block inquire
//
S6F5		HW
  <L[2]
    <U2[1]DATAID>
    <U4[1]DATALENGTH>
  >


S6F6		E
  <B[1]GRANT6>



// -----------------------------------------------------------------------------
// Data transfer request
//
S6F7		HW
  <U2[1]DATAID>


S6F8		E
  <L[3]
    <U2[1]DATAID>
    <U1[1]CEID>
    <L [N]NOI1
      <L[2]
	<U2[1]DSID>
	<L [N]NOI2
	  <L[2]
	    <A[ 6]DVNAME>
	    <A[16]DVVAL>
	  >
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Formatted variable send
//
S6F9		EW
  <L[4]
    <B[ 1]PFCD>
    <U2[1]DATAID>
    <U1[1]CEID>
    <L [N]NOI1
      <L[2]
	<U2[1]DSID>
	<L [N]NOI2
	  <L[2]
	    <A[ 6]DVNAME>
	    <A[16]DVVAL>
	  >
	>
      >
    >
  >


S6F10		H
  <B[1]ACKC6>



// -----------------------------------------------------------------------------
// Event report send
//
S6F11		EW
  <L[3]
    <U2[1]DATAID>
    <U1[1]CEID>
    <L [N]NOI1
      <L[2]
	<U1[1]RPTID>
	<L [N]NOI2
	  <A[16]V>
	>
      >
    >
  >


S6F12		H
  <B[1]ACKC6>



// -----------------------------------------------------------------------------
// Annotated event report send
//
S6F13		EW
  <L[3]
    <U2[1]DATAID>
    <U1[1]CEID>
    <L [N]NOI1
      <L[2]
	<U1[1]RPTID>
	<L [N]NOI2
	  <L[2]
	    <U2[ 1]VID>
	    <A [16]V>
	  >
	>
      >
    >
  >


S6F14		H
  <B[1]ACKC6>



// -----------------------------------------------------------------------------
// Event report request
//
S6F15		HW
  <U1[1]CEID>


S6F16		E
  <L[3]
    <U2[1]DATAID>
    <U1[1]CEID>
    <L [N]NOI1
      <L[2]
	<U1[1]RPTID>
	<L [N]NOI2
	  <A[16]V>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Annotated event report request
//
S6F17		HW
  <U1[1]CEID>


S6F18		E
  <L[3]
    <U2[1]DATAID>
    <U1[1]CEID>
    <L [N]NOI1
      <L[2]
	<U1[1]RPTID>
	<L [N]NOI2
	  <L[2]
	    <U2[ 1]VID>
	    <A [16]V>
	  >
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Indivisual report request
//
S6F19		HW
  <U1[1]RPTID>


S6F20		E
  <L[N]NOI1
    <A[16]V>
  >



// -----------------------------------------------------------------------------
// Annotated indivisual report request
//
S6F21		HW
  <U1[1]RPTID>


S6F22		E
  <L[N]NOI1
    <L[2]
      <U2[ 1]VID>
      <A [16]V>
    >
  >



// -----------------------------------------------------------------------------
// Request spooled data
//
S6F23		HW
  <U1[1]RSDC>


S6F24		E
  <B[1]RSDA>



// -----------------------------------------------------------------------------
// Notification request send
//
S6F25		W
  <L[7]
    <U2[   1]DATAID>
    <U2[0..1]OPID>
    <U4[0..1]LINKID>
    <A [  16]RCPSPEC>
    <U1[   1]RMCHGSTAT>
    <L [N   ]NOI1
      <L[2]
	<A[ 6]RCPATTRID>
	<A[20]RCPATTRDATA>
      >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI2
        <L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
        >
      >
    >
  >
    

S6F26
  <B[1]ACKC6>



// -----------------------------------------------------------------------------
// Trace report send
//
S6F27		EW
  <L[3]
    <U2[1]DATAID>
    <A [6]TRID>
    <L [N]NOI1
      <L[N]NOI2
	<L[2]
	  <U1[1]RPTID>
	  <L [N]NOI3
	    <A[16]V>
	  >
	>
      >
    >
  >


S6F28		H
  <A[6]TRID>



// -----------------------------------------------------------------------------
// Trace report request
//
S6F29		HW
  <A[6]TRID>


S6F30		E
  <L[3]
    <A[6]TRID>
    <L[N]NOI1
      <L[2]
	<U1[1]RPTID>
	<L [N]NOI2
	  <A[16]V>
	>
      >
    >
    <U2[1]ERRCODE>
  >



// =============================================================================
// Stream#7 : Process program management

// -----------------------------------------------------------------------------
// Abort transaction
//
S7F0



// -----------------------------------------------------------------------------
// Process program load inqure
//
S7F1		W
  <L[2]
    <A [16]PPID>
    <U4[ 1]LENGTH>
  >


S7F2
  <B[1]PPGNT>



// -----------------------------------------------------------------------------
// Process program send
//
S7F3		W
  <L[2]
    <A[         16]PPID>
    <B[0..16777215]PPBODY>
  >


S7F4
  <B[1]ACKC7>



// -----------------------------------------------------------------------------
// Process program request
//
S7F5		W
  <A[16]PPID>


S7F6
  <L[2]
    <A[         16]PPID>
    <B[0..16777215]PPBODY>
  >



// -----------------------------------------------------------------------------
// Process program ID request
//
S7F7		EW
  <A[16]MID>


S7F8		H
  <L[2]NOI1
    <A[16]PPID>
    <A[16]MID>
  >



// -----------------------------------------------------------------------------
// M/PM request
//
S7F9		W


S7F10
  <L[N]NOI1
    <L[2]
      <A[16]PPID>
      <L[N ]NOI2
	<A[16]MID>
      >
    >
  >



// -----------------------------------------------------------------------------
// M/PM update send
//
S7F11		HW
  <L[N]NOI1
    <L[2]
      <A[16]PPID>
      <L[N ]NOI2
	<A[16]MID>
      >
    >
  >


S7F12		E
  <B[1]ACKC7>



// -----------------------------------------------------------------------------
// Delete M/PM entry send
//
S7F13		HW
  <L[N]NOI1
    <L[2]
      <A[16]PPID>
      <L[N ]NOI2
	<A[16]MID>
      >
    >
  >


S7F14		E
  <B[1]ACKC7>



// -----------------------------------------------------------------------------
// Matrix mode select send
//
S7F15		HW
  <B[1]MMODE>


S7F16		E
  <B[1]ACKC7>



// -----------------------------------------------------------------------------
// Delete process program send
//
S7F17		HW
  <L[N]NOI1
    <A[16]PPID>
  >


S7F18		E
  <B[1]ACKC7>



// -----------------------------------------------------------------------------
// Current EPPD request
//
S7F19		HW


S7F20		E
  <L[N]NOI1
    <A[16]PPID>
  >



// -----------------------------------------------------------------------------
// Equipment process capabilities request
//
S7F21		HW


S7F22		E
  <L[5]
    <A [6]MDLN "EQUIP1">
    <A [6]SOFTREV "01.000">
    <U2[1]CMDMAX>
    <U4[1]BYTMAX>
    <L [N]NOI1
      <L[11]
	<U2[ 1]CCODE>
	<A [16]CNAME>
	<T [ 1]RQCMD>
	<U1[16]BLKDEF>
	<U2[16]BCDS>
	<U2[16]IBCDS>
	<U2[16]NBCDS>
	<U2[16]ACDS>
	<U2[16]IACDS>
	<U2[16]NACDS>
	<L[3]
	  <L[9]
	    <A [16]PNAME1>
	    <T [ 1]RQPAR1>
	    <I4[ 1]PDFLT1>
	    <I4[ 1]PMAX1>
	    <I4[ 1]LLIM>
	    <I4[ 1]ULIM>
	    <A [ 6]UNITS>
	    <I1[ 1]RESC>
	    <I4[ 1]RESV>
	  >
	  <L[5]
	    <A [16]PNAME2>
	    <T [ 1]RQPAR2>
	    <A [ 1]PDFLT2>
	    <A [ 1]PMAX2>
	    <L [ N]NOI2
	      <A[16]STEMP>
	    >
	  >
	  <L[4]
	    <A [16]PNAME3>
	    <T [ 1]RQPAR3>
	    <A [ 1]PDFLT3>
	    <A [ 1]PMAX3>
          >
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Formatted process program send
//
S7F23		W
  <L[4]
    <A[16]PPID>
    <A[ 6]MDLN "EQUIP1">
    <A[ 6]SOFTREV "01.000">
    <L[N ]NOI1
      <L[2]
	<U2[ 1]CCODE>
	<L [N ]NOI2
	  <A[16]PPARM>
	>
      >
    >
  >


S7F24
  <B[1]ACKC7>



// -----------------------------------------------------------------------------
// Formatted process program request
//
S7F25		W
  <A[16]PPID>


S7F26
  <L[4]
    <A[16]PPID>
    <A[ 6]MDLN "EQUIP1">
    <A[ 6]SOFTREV "01.000">
    <L[N ]NOI1
      <L[2]
	<U2[1]CCODE>
	<L[3]
	  <L[9]
	    <A [16]PNAME1>
	    <T [ 1]RQPAR1>
	    <I4[ 1]PDFLT1>
	    <I4[ 1]PMAX1>
	    <I4[ 1]LLIM>
	    <I4[ 1]ULIM>
	    <A [ 6]UNITS>
	    <I1[ 1]RESC>
	    <I4[ 1]RESV>
	  >
	  <L[5]
	    <A [16]PNAME2>
	    <T [ 1]RQPAR2>
	    <A [ 1]PDFLT2>
	    <A [ 1]PMAX2>
	    <L [N ]NOI2
	      <A[16]STEMP>
	    >
	  >
	  <L[4]
	    <A [16]PNAME3>
	    <T [ 1]RQPAR3>
	    <A [ 1]PDFLT3>
	    <A [ 1]PMAX3>
          >
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process program verification send
//
S7F27		EW
  <L[2]
    <A[16]PPID>
    <L[N ]NOI1
      <L[3]
	<U1[ 1]ACKC7A>
	<U2[ 1]SEQNUM>
	<A [80]ERRW7>
      >
    >
  >


S7F28		H



// -----------------------------------------------------------------------------
// Process program verification send
//
S7F29		EW
  <U4[1]LENGTH>


S7F30		H
  <B[1]PPGNT>



// -----------------------------------------------------------------------------
// Verification request send
//
S7F31		HW
  <L[4]
    <A[16]PPID>
    <A[ 6]MDLN "EQUIP1">
    <A[ 6]SOFTREV "01.000">
    <L[N ]NOI1
      <L[2]
	<U2[1]CCODE>
	<L [3]
	  <L[9]
	    <A [16]PNAME1>
	    <T [ 1]RQPAR1>
	    <I4[ 1]PDFLT1>
	    <I4[ 1]PMAX1>
	    <I4[ 1]LLIM>
	    <I4[ 1]ULIM>
	    <A [ 6]UNITS>
	    <I1[ 1]RESC>
	    <I4[ 1]RESV>
	  >
	  <L[5]
	    <A [16]PNAME2>
	    <T [ 1]RQPAR2>
	    <A [ 1]PDFLT2>
	    <A [ 1]PMAX2>
	    <L [N ]NOI2
	      <A[16]STEMP>
	    >
	  >
	  <L[4]
	    <A [16]PNAME3>
	    <T [ 1]RQPAR3>
	    <A [ 1]PDFLT3>
	    <A [ 1]PMAX3>
          >
	>
      >
    >
  >


S7F32		E
  <B[1]ACKC7>



// -----------------------------------------------------------------------------
// Process program available request
//
S7F33		W
  <A[16]PPID>


S7F34
  <L[4]
    <A [16]PPID>
    <U4[ 1]UNFLEN>
    <U4[ 1]FRMLEN>
  >



// -----------------------------------------------------------------------------
// Process program for MID request
//
S7F35		W
  <A[16]MID>


S7F36
  <L[3]
    <A[         16]MID>
    <A[         16]PPID>
    <B[0..16777215]PPBODY>
  >



// =============================================================================
// Stream#8 : Transfer control program

// -----------------------------------------------------------------------------
// Abort transaction
//
S8F0



// -----------------------------------------------------------------------------
// Boot program request
//
S8F1		W

S8F2
  <B[0..16777215]BPD>



// -----------------------------------------------------------------------------
// Execute program request
//
S8F3		W

S8F4
  <B[0..16777215]EPD>



// =============================================================================
// Stream#9 : System error

S9F0			// Abort transaction

S9F1			// Unrecognized device id
  <B[10]MHEAD>

S9F3			// Unricognized stream type
  <B[10]MHEAD>

S9F5			// Unricognized fanction type
  <B[10]MHEAD>

S9F7			// Illegal data
  <B[10]MHEAD>

S9F9			// Transaction timer timeout
  <B[10]SHEAD>

S9F11			// Data too long
  <B[10]MHEAD>

S9F13_0			// Conversation timeout (S2F3)
  <L[2]
    <A[ 6]MEXP>		// S2F3
    <A[ 6]EDID>		// SPID
  >
S9F13_1			// Conversation timeout (S3F13)
  <L[2]
    <A[ 6]MEXP>		// S3F13
    <B[ 1]EDID>		// PTN
  >
S9F13_2			// Conversation timeout (S7F3)
  <L[2]
    <A[ 6]MEXP>		// S7F13
    <A[16]EDID>		// PPID
  >
S9F13_3			// Conversation timeout (S7F3)
  <L[2]
    <A[ 6]MEXP>		// S7F13
    <B[16]EDID>		// PPID
  >



// =============================================================================
// Stream#10 : Terminal service

// -----------------------------------------------------------------------------
// Abort transaction
//
S10F0



// -----------------------------------------------------------------------------
// Terminal request
//
S10F1		EW
  <L[2]
    <B[ 1]TID>
    <A[80]TEXT>
  >

S10F2		H		
  <B[1]ACKC10>



// -----------------------------------------------------------------------------
// Terminal display single
//
S10F3		HW
  <L[2]
    <B[ 1]TID>
    <A[80]TEXT>
  >

S10F4		E
  <B[1]ACKC10>



// -----------------------------------------------------------------------------
// Terminal display multi-block
//
S10F5		HW
  <L[2]
    <B[ 1]TID>
    <L[N ]NOI1
      <A[80]TEXT>
    >
  >

S10F4		E
  <B[1]ACKC10>



// -----------------------------------------------------------------------------
// Multi-block not allowed
//
S10F7		H
  <B[1]TID>



// -----------------------------------------------------------------------------
// Broadcast
//
S10F9		HW
  <A[80]TEXT>

S10F10		E
  <B[1]ACKC10>



// =============================================================================
// Stream#11 : Host file service  ... deleted



// =============================================================================
// Stream#12 : Wafer mapping

// -----------------------------------------------------------------------------
// Abort transaction
//
S12F0



// -----------------------------------------------------------------------------
// Map setup data send
//
S12F1		EW
  <L[15]
    <A [  16]MID>
    <B [   1]IDTYP>
    <U2[   1]FNLOC>
    <U2[   1]FFROT>
    <B [   1]ORLOC>
    <U1[   1]RPSEL>
    <L [N   ]NOI1
      <I4[ 2]REFP>
    >
    <A [   6]DUTMS>
    <U4[   1]XDIES>
    <U4[   1]YDIES>
    <U4[0..1]ROWCT>
    <U2[   1]COLCT>
    <U1[   1]NULBC>
    <U4[0..1]PRDCT>
    <B [   1]PRAXI>
  >


S12F2		H
  <B[1]SDACK>



// -----------------------------------------------------------------------------
// Map setup data request
//
S12F3		EW
  <L[9]
    <A [16]MID>
    <B [ 1]IDTYP>
    <B [ 1]MAPFT>
    <U2[ 1]FNLOC>
    <U2[ 1]FFROT>
    <B [ 1]ORLOC>
    <B [ 1]PRAXI>
    <U1[ 1]BCEQU>
    <U1[ 1]NULBC>
  >


S12F4		H
  <L[15]
    <A [  16]MID>
    <B [   1]IDTYP>
    <U2[   1]FNLOC>
    <B [   1]ORLOC>
    <U1[   1]RPSEL>
    <L [   N]NOI1
      <I4[2]REFP>
    >
    <A [   6]DUTMS>
    <U4[   1]XDIES>
    <U4[   1]YDIES>
    <U4[0..1]ROWCT>
    <U2[   1]COLCT>
    <U4[0..1]PRDCT>
    <U1[   1]BCEQU>
    <U1[   1]NULBC>
    <U2[   1]MLCL>
  >



// -----------------------------------------------------------------------------
// Map transmit inquire
//
S12F5		EW
  <L[4]
    <A [16]MID>
    <B [ 1]IDTYP>
    <B [ 1]MAPFT>
    <U2[ 1]MLCL>
  >


S12F6		H
  <B[1]GRNT1>



// -----------------------------------------------------------------------------
// Map data send type 1
//
S12F7		EW
  <L[3]
    <A[16]MID>
    <B[ 1]IDTYP>
    <L[N ]NOI1
      <L[2]
	<I4[1]RSINF>
	<U1[1]BINLT>
      >
    >
  >


S12F8		H
  <B[1]MDACK>



// -----------------------------------------------------------------------------
// Map data send type 2
//
S12F9		EW
  <L[4]
    <A [16]MID>
    <B [ 1]IDTYP>
    <I4[ 2]STRP>
    <U1[ 1]BINLT>
  >


S12F10		H
  <B[1]MDACK>



// -----------------------------------------------------------------------------
// Map data send type 3
//
S12F11		EW
  <L[3]
    <A[16]MID>
    <B[ 1]IDTYP>
    <L[N ]NOI1
      <L[2]
	<I4[2]XYPOS>
	<U1[1]BINLT>
      >
    >
  >


S12F12		H
  <B[1]MDACK>



// -----------------------------------------------------------------------------
// Map data request type 1
//
S12F13		EW
  <L[2]
    <A[16]MID>
    <B[ 1]IDTYP>
  >


S12F14		H
  <L[3]
    <A[16]MID>
    <B[ 1]IDTYP>
    <L[N ]NOI1
      <L[2]
	<I4[3]RSINF>
	<U1[1]BINLT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Map data request type 2
//
S12F15		EW
  <L[2]
    <A [16]MID>
    <B [ 1]IDTYP>
  >


S12F16		H
  <L[4]
    <A [16]MID>
    <B [ 1]IDTYP>
    <I4[ 2]STRP>
    <U1[ 1]BINLT>
  >



// -----------------------------------------------------------------------------
// Map data request type 3
//
S12F17		EW
  <L[3]
    <A [16]MID>
    <B [ 1]IDTYP>
    <B [ 1]SDBIN>
  >


S12F18		H
  <L[3]
    <A [16]MID>
    <B [ 1]IDTYP>
    <L [N ]NOI1
      <L[2]
	<I4[2]XYPOS>
	<U1[1]BINLT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Map error request send
//
S12F19
  <L[2]
    <B [1]MAPER>
    <U1[1]DATLC>
  >



// =============================================================================
// Stream#13 : Data set transfer

// -----------------------------------------------------------------------------
// Abort transaction
//
S13F0



// -----------------------------------------------------------------------------
// Send data set
//
S13F1		W
  <L[1]
    <A[0..50]DSNAME>
  >


S13F2
  <L[2]
    <A[0..50]DSNAME>
    <B[    1]ACKC13>
  >



// -----------------------------------------------------------------------------
// Open data set
//
S13F3		W
  <L[3]
    <U2[    1]HANDLE>
    <A [0..50]DSNAME>
    <U4[    1]CKPNT>
  >


S13F4
  <L[5]
    <U2[    1]HANDLE>
    <A [0..50]DSNAME>
    <B [    1]ACKC13>
    <U1[    1]RTYPE>
    <U2[    1]RECLEN>
  >



// -----------------------------------------------------------------------------
// Read data set
//
S13F5		W
  <L[2]
    <U2[1]HANDLE>
    <U4[1]READLN>
  >


S13F6
  <L[4]
    <U2[1]HANDLE>
    <B [1]ACKC13>
    <U4[1]CKPNT>
    <L [N]NOI1
      <B[0..256]FILDAT>
    >
  >



// -----------------------------------------------------------------------------
// Close data set
//
S13F7		W
  <L[1]
    <U2[1]HANDLE>
  >


S13F8
  <L[2]
    <U2[1]HANDLE>
    <B [1]ACKC13>
  >



// -----------------------------------------------------------------------------
// Reset data set
//
S13F9		W

S13F10



// -----------------------------------------------------------------------------
// Data set object multi-block inqure
//
S13F11		W
  <L[3]
    <U2[ 1]DATAID>
    <A [ 8]OBJSPEC>
    <U4[ 1]DATALENGTH>
  >


S13F12
  <B[1]GRANT>



// -----------------------------------------------------------------------------
// Table data send
//
S13F13		W
  <L[8]
    <U2[ 1]DATAID>
    <A [ 8]OBJSPEC>
    <A [ 8]TBLTYP>
    <A [ 8]TBLID>
    <U1[ 1]TBLCMD>
    <L [N ]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
    <L [N ]NOI2
      <A[20]COLHDR>
    >
    <L [N ]NOI3
      <L[N]NOI4
	<A[20]TBLELT>
      >
    >
  >


S13F14
  <L[2]
    <U1[1]TBLACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >




// -----------------------------------------------------------------------------
// Table data request
//
S13F15		W
  <L[7]
    <U2[1]DATAID>
    <A [8]OBJSPEC>
    <A [8]TBLTYP>
    <A [8]TBLID>
    <U1[1]TBLCMD>
    <L [N]NOI1
      <A[20]COLHDR>
    >
    <L [N]NOI2
      <A[20]TBLELT>
    >
  >


S13F16
  <L[6]
    <A [8]TBLTYP>
    <A [8]TBLID>
    <L [N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
    <L [N]NOI2
      <A[20]COLHDR>
    >
    <L [N]NOI3
      <L[N]NOI4
	<A[20]TBLELT>
      >
    >
    <L[2]
      <U1[1]TBLACK>
      <L [N]NOI5
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// =============================================================================
// Stream#14 : Object service

// -----------------------------------------------------------------------------
// Abort transaction
//
S14F0



// -----------------------------------------------------------------------------
// Get attribute data
//
S14F1		W
  <L[5]
    <A[8]OBJSPEC>
    <A[8]OBJTYPE>
    <L[N]NOI1
      <A[8]OBJID>
    >
    <L[N]NOI2
      <L[3]
	<A [ 6]ATTRID>
	<A [20]ATTRDATA>
	<U1[ 1]ATTRRELN>
      >
    >
    <L[N]NOI3
      <A[6]ATTRID>
    >
  >


S14F2
  <L[2]
    <L[N]NOI1
      <L[2]
	<A[8]OBJID>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]ATTRID>
	    <A[20]ATTRDATA>
	  >
	>
      >
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI3
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Set attribute data
//
S14F3		W
  <L[4]
    <A[8]OBJSPEC>
    <A[8]OBJTYPE>
    <L[N]NOI1
      <A[8]OBJID>
    >
    <L[N]NOI2
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
  >


S14F4
  <L[2]
    <L[N]NOI1
      <L[2]
	<A[8]OBJID>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]ATTRID>
	    <A[20]ATTRDATA>
	  >
	>
      >
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI3
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Get type data
//
S14F5		W
  <A[8]OBJSPEC>


S14F6
  <L[2]
    <L[N]NOI1
      <A[8]OBJTYPE>
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Get attribute name
//
S14F7		W
  <L[2]
    <A[8]OBJSPEC>
    <L[N]NOI1
      <A[8]OBJTYPE>
    >
  >



S14F8
  <L[2]
    <L[N]NOI1
      <A[8]OBJTYPE>
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Create object
//
S14F9		W
  <L[3]
    <A[8]OBJSPEC>
    <A[8]OBJTYPE>
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
  >



S14F10
  <L[3]
    <A[8]OBJSPEC>
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Delete object
//
S14F11		W
  <L[2]
    <A[8]OBJSPEC>
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
  >



S14F12
  <L[2]
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Object attach
//
S14F13		W
  <L[2]
    <A[8]OBJSPEC>
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
  >



S14F14
  <L[3]
    <U4[1]OBJTOKEN>
    <L [N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Attach object action
//
S14F15		W
  <L[4]
    <A [8]OBJSPEC>
    <U1[1]OBJCMD>
    <U4[1]OBJTOKEN>
    <L [N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
  >



S14F16
  <L[2]
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Supervised object action
//
S14F17		W
  <L[4]
    <A [ 8]OBJSPEC>
    <U1[ 1]OBJCMD>
    <A [ 8]TARGETSPEC>
    <L [N ]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
  >



S14F18
  <L[2]
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[20]ATTRDATA>
      >
    >
    <L[2]
      <B[1]OBJACK>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// =============================================================================
// Stream#15 : Recipe management

// -----------------------------------------------------------------------------
// Abort transaction
//
S15F0



// -----------------------------------------------------------------------------
// Recipe management multi-block inqure
//
S15F1		W
  <L[3]
    <U2[ 1]DATAID>
    <A [16]RCPSPEC>
    <U4[ 1]RMDATASIZE>
  >


S15F2
  <B[1]RMGRNT>



// -----------------------------------------------------------------------------
// Recipe namespace action
//
S15F3		W
  <L[2]
    <A [ 8]RMNSSPEC>
    <U1[ 1]RMNSCMD>
  >


S15F4
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe namespace rename
//
S15F5		W
  <L[2]
    <A[8]RMNSSPEC>
    <A[8]RMNEWNS>
  >


S15F6
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe space data
//
S15F7		W
  <A[8]OBJSPEC>


S15F8
  <L[2]
    <U4[1]RMSPACE>
    <L [2]
      <U1[1]RMACK>
      <L [N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe status
//
S15F9		W
  <A[8]OBJSPEC>


S15F10
  <L[3]
    <U1[1]RCPSTAT>
    <A [6]RCPVERS>
    <L [2]
      <U1[1]RMACK>
      <L [N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe version request
//
S15F11		W
  <L[4]
    <A[    8]RMNSPEC>
    <A[0..16]RCPCLASS>
    <A[0..16]RCPNAME>
    <A[0..16]AGENT>
  >


S15F12
  <L[3]
    <A[0..16]AGENT>
    <A[0..16]RCPVERS>
    <L[    2]
      <U1[1]RMACK>
      <L [N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe create request
//
S15F13		W
  <L[5]
    <U2[ 1]DATAID>
    <T [ 1]RCPUPDT>
    <A [16]RCPSPEC>
    <L [N ]NOI1
      <L[2]
	<A[ 6]RCPATTRID>
	<A[20]RCPATTRDATA>
      >
    >
    <B[0..32768]RCPBODY>
  >


S15F14
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe store request
//
S15F15_1	W
  <L[4]
    <U2[ 1]DATAID>
    <A [16]RCPSPEC>
    <B [ 1]RCPSECCODE>
    <L [ 1]
      <L[0|2]NOI1
	<A[6]RCPSECNM>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]RCPATTRID>
	    <A[20]RCPATTRDATA>
	  >
	>
      >
    >
  >

S15F15_2	W
  <L[4]
    <U2[ 1]DATAID>
    <A [16]RCPSPEC>
    <B [ 1]RCPSECCODE>
    <L [ 2]
      <L[0|2]NOI1
	<A[6]RCPSECNM>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]RCPATTRID>
	    <A[20]RCPATTRDATA>
	  >
	>
      >
      <B[0..32768]RCPBODY>
    >
  >

S15F15_3	W
  <L[4]
    <U2[ 1]DATAID>
    <A [16]RCPSPEC>
    <B [ 1]RCPSECCODE>
    <L [ 3]
      <L[0|2]NOI1
	<A[6]RCPSECNM>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]RCPATTRID>
	    <A[20]RCPATTRDATA>
	  >
	>
      >
      <B[0..32768]RCPBODY>
      <L[N]NOI3
	<L[2]
	  <A[6]RCPSECNM>
	  <L[N]NOI4
	    <L[2]
	      <A[ 6]RCPATTRID>
	      <A[20]RCPATTRDATA>
	    >
	  >
	>
      >
    >
  >


S15F16
  <L[2]
    <B[1]RCPSECCODE>
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe retreive request
//
S15F17		W
  <L[2]
    <A[16]RCPSPEC>
    <B[ 1]RCPSECCODE>
  >


S15F18_1
  <L[2]
    <L[1]
      <L[0|2]NOI1
	<A[6]RCPSECNM>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]RCPATTRID>
	    <A[20]RCPATTRDATA>
	  >
	>
      >
    >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI5
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >

S15F18_2
  <L[2]
    <L[2]
      <L[0|2]NOI1
	<A[6]RCPSECNM>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]RCPATTRID>
	    <A[20]RCPATTRDATA>
	  >
	>
      >
      <B[0..32768]RCPBODY>
    >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI5
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >
      
S15F18_3
  <L[2]
    <L[3]
      <L[0|2]NOI1
	<A[6]RCPSECNM>
	<L[N]NOI2
	  <L[2]
	    <A[ 6]RCPATTRID>
	    <A[20]RCPATTRDATA>
	  >
	>
      >
      <B[0..32768]RCPBODY>
      <L[N]NOI3
	<L[2]
	  <A[6]RCPSECNM>
	  <L[N]NOI4
	    <L[2]
	      <A[ 6]RCPATTRID>
	      <A[20]RCPATTRDATA>
	    >
	  >
	>
      >
    >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI5
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe rename request
//
S15F19		W
  <L[3]
    <A[16]RCPSPEC>
    <T[ 1]RCPRENAME>
    <A[16]RCPNEWID>
  >


S15F20
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe action request
//
S15F21		W
  <L[6]
    <U2[ 1]DATAID>
    <U1[ 1]RCPCMD>
    <A [ 8]RMNSSPEC>
    <U2[ 1]OPID>
    <A [16]AGENT>
    <L [N ]NOI1
      <A[16]RCPID>
    >
  >


S15F22
  <L[4]
    <A [16]AGENT>
    <U4[ 1]LINKID>
    <U1[ 1]RCPCMD>
    <L [ 2]
      <U1[1]RMACK>
      <L [N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe descriptor request
//
S15F23		W
  <L[3]
    <U2[1]DATAID>
    <A [8]OBJSPEC>
    <L [N]NOI1
      <A[16]RCPID>
    >
  >


S15F24
  <L[2]
    <L[N]NOI1
      <L[0|3]NOI2
	<A [16]RCPDESCNM>
	<A [16]RCPDESCTIME>
	<U4[ 1]RCPDESCLTH>
      >
    >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI3
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >


// -----------------------------------------------------------------------------
// Recipe parameter update request
//
S15F25		W
  <L[4]
    <U2[ 1]DATAID>
    <A [ 8]RMNSSPEC>
    <A [16]AGENT>
    <L [N ]NOI1
      <L[3]
	<A[40]RCPPARNM>
	<A[80]RCPPARVAL>
	<A[40]RCPPARRULE>
      >
    >
  >


S15F26
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe download request
//
S15F27		HW
  <L[5]
    <U2[ 1]DATAID>
    <T [ 1]RCPOWCODE>
    <A [16]RCPSPEC>
    <L [N ]NOI1
      <L[2]
	<A[ 6]RCPATTRID>
	<A[20]RCPATTRDATA>
      >
    >
    <B[0..32768]RCPBODY>
  >


S15F28		E
  <L[3]
    <A[16]RCPID>
    <L[N ]NOI1
      <L[2]
	<A[ 6]RCPATTRID>
	<A[20]RCPATTRDATA>
      >
    >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe verify request
//
S15F29		HW
  <L[4]
    <U2[ 1]DATAID>
    <U2[ 1]OPID>
    <A [16]RESPEC>
    <L [N ]NOI1
      <A[16]RCPID>
    >
  >


S15F30		E
  <L[5]
    <U2[ 1]OPID>
    <U4[ 1]LINKID>
    <A [16]RCPID>
    <L [N ]NOI1
      <L[2]
	<A[ 6]RCPATTRID>
	<A[20]RCPATTRDATA>
      >
    >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe unload request
//
S15F31		HW
  <A[16]RCPSPEC>


S15F32		E
  <L[4]
    <A[16]RCPSPEC>
    <L[N ]NOI1
      <L[2]
	<A[ 6]RCPATTRID>
	<A[20]RCPATTRDATA>
      >
    >
    <B[0..32768]RCPBODY>
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe select request
//
S15F33		HW
  <L[3]
    <U2[ 1]DATAID>
    <A [16]RESPEC>
    < L[N ]NOI1
      <L[2]
	<A[16]RCPID>
	<L[N ]NOI2
	  <L[2]
	    <A[40]RCPPARNM>
	    <A[80]RCPPARVAL>
	  >
	>
      >
    >
  >


S15F34		E
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Recipe delete request
//
S15F35		HW
  <L[4]
    <U2[ 1]DATAID>
    <A [16]RESPEC>
    <U1[ 1]RCPDEL>
    <L [N ]NOI1
      <A[16]RCPID>
    >
  >


S15F36		E
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// DRNS segment approve action request
//
S15F37		W
  <L[6]
    <A [16]RMSEGSPEC>
    <U4[ 1]OBJTOKEN>
    <B [ 1]RMGRMT>
    <U2[ 1]OPID>
    <A [16]RCPID>
    <U1[ 1]RMCHGTYPE>
    >
  >


S15F38
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// DRNS recorder segment request
//
S15F39		W
  <L[5]
    <U2[ 1]DATAID>
    <U1[ 1]RMNSCMD>
    <A [ 8]RMNSSPEC>
    <A [16]RMSEGSPEC>
    <U4[ 1]OBJTOKEN>
  >


S15F40
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// DRNS recorder modify request
//
S15F41_1	W
  <L[5]
    <U2[ 1]DATAID>
    <A [16]RMRECSPEC>
    <U4[ 1]OBJTOKEN>
    <U1[ 1]RMNSCMD>
    <L [ 1]
      <A[16]RCPID>
    >
  >

S15F41_7	W
  <L[5]
    <U2[ 1]DATAID>
    <A [16]RMRECSPEC>
    <U4[ 1]OBJTOKEN>
    <U1[ 1]RMNSCMD>
    <L [ 7]
      <A [16]RCPID>
      <A [16]RCPNEWID>
      <A [16]RMSEGSPEC>
      <U1[ 1]RMCHGTYPE>
      <U2[ 1]OPID>
      <A [14]@TIME "YYYYMMDDhhmmss">
      <T [ 1]RMREQUESTOR>
    >
  >


S15F42
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// DRNS get change request
//
S15F43		W
  <L[3]
    <U2[   1]DATAID>
    <A [   8]OBJSPEC>
    <A [0..8]TARGETSPEC>
  >


S15F44
  <L[2]
    <L[N]NOI1
      <L[7]
	<A [16]RCPID>
	<A [16]RCPNEWID>
	<A [16]RMSEGSPEC>
	<U1[ 1]RMCHGTYPE>
	<U2[ 1]OPID>
	<A [14]@TIME "YYYYMMDDhhmmss">
	<T [ 1]RMREQUESTOR>
      >
    >
    <L[2]
      <U1[1]RMACK>
      <L [N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// DRNS manager segment change approval
//
S15F45		W
  <L[4]
    <U2[    1]DATAID>
    <A [   16]RCPSPEC>
    <A [0..16]RCPNEWID>
    <U1[    1]RMCHGTYPE>
  >


S15F46
  <L[3]
    <U1[    1]RMCHGTYPE>
    <B [    1]RMGRNT>
    <U2[    1]OPID>
  >



// -----------------------------------------------------------------------------
// DRNS manager rebuild request
//
S15F47		W
  <L[5]
    <U2[    1]DATAID>
    <A [    8]OBJSPEC>
    <A [    8]RMNSSPEC>
    <A [0..16]RMRECSPEC>
    <L [N    ]NOI1
      <A[16]RMSEGSPEC>
    >
  >


S15F48
  <L[2]
    <U1[1]RMACK>
    <L [N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// =============================================================================
// Stream#16 : Process management

// -----------------------------------------------------------------------------
// Abort transaction
//
S16F0



// -----------------------------------------------------------------------------
// Multi-block process job data inqure
//
S16F1		HW
  <L[2]
    <U2[1]DATAID>
    <U4[1]DATALENGTH>
  >


S16F2		E
  <B[1]GRANT>



// -----------------------------------------------------------------------------
// Process job create request
//
S16F3		HW
  <L[5]
    <U2[1]DATAID>
    <B [1]MF>
    <L [N]NOI1
      <A[16]MID>
    >
    <L[3]
      <A[16]PRRECIPEMETHOD>
      <A[16]RCPSPEC>
      <L[N ]NOI2
	<L[2]
	  <A[40]RCPPARNM>
	  <A[80]RCPPARVAL>
	>
      >
    >
    <T[1]PRPROCESSSTART>
  >


S16F4		E
  <L[2]
    <A[16]PRJOBID>
    <L[ 2]
      <T[1]ACKA>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process job command request
//
S16F5		HW
  <L[4]
    <U2[ 1]DATAID>
    <A [16]PRJOBID>
    <A [16]PRCMDNAME>
    <L [N ]NOI1
      <L[2]
	<A[12]CPNAME>
	<A[24]CPVAL>
      >
    >
  >


S16F6		E
  <L[2]
    <A[16]PRJOBID>
    <L[ 2]
      <T[1]ACKA>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process job alart notify
//
S16F7		EW
  <L[4]
    <A [14]@TIME "YYYYMMDDhhmmss">
    <A [16]PRJOBID>
    <U1[ 1]PRJOBMILESTONE>
    <L[2]
      <T[1]ACKA>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >


S16F8		H



// -----------------------------------------------------------------------------
// Process job event notify
//
S16F9		EW
  <L[4]
    <U1[ 1]PREVENTID>
    <A [14]@TIME "YYYYMMDDhhmmss">
    <A [16]PRJOBID>
    <L [N ]NOI1
      <L[2]
	<U2[ 1]VID>
	<A [16]V>
      >
    >
  >


S16F10		H



// -----------------------------------------------------------------------------
// Process job create enh
//
S16F11_A	HW
  <L[7]
    <U2[ 1]DATAID>
    <A [16]PRJOBID>
    <B [ 1]MF>
    <L [N ]NOI1
      <L[2]
	<A[8]CARRIERID>
	<L[N]NOI2
	  <U1[1]SLOTID>
	>
      >
    >
    <L[3]
      <A[16]PRRECIPEMETHOD>
      <A[16]RCPSPEC>
      <L[N ]NOI3
	<L[2]
	  <A[40]RCPPARNM>
	  <A[80]RCPPARVAL>
	>
      >
    >
    <T[1]PRPROCESSSTART>
    <L[N]NOI4>
      <U4[1]PRPAUSEEVENT>
    >
  >

S16F11_B	HW
  <L[7]
    <U2[ 1]DATAID>
    <A [16]PRJOBID>
    <B [ 1]MF>
    <L [N ]NOI1
      <A[16]MID>
    >
    <L[3]
      <A[16]PRRECIPEMETHOD>
      <A[16]RCPSPEC>
      <L[N ]NOI2
	<L[2]
	  <A[40]RCPPARNM>
	  <A[80]RCPPARVAL>
	>
      >
    >
    <T[1]PRPROCESSSTART>
    <L[N]NOI3>
      <U4[1]PRPAUSEEVENT>
    >
  >


S16F12		E
  <L[2]
    <A[16]PRJOBID>
    <L[ 2]
      <T[1]ACKA>
      <L[N]NOI1
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process job duplicate create
//
S16F13_A	HW
  <L[5]
    <U2[1]DATAID>
    <L [N]NOI1
      <L[3]
	<A[16]PRJOBID>
	<B[ 1]MF>
	<L[N ]NOI2
	  <L[2]
	    <A[8]CARRIERID>
	    <L[N]NOI3
	      <U1[1]SLOTID>
	    >
	  >
	>
      >
    >
    <L[3]
      <A[16]PRRECIPEMETHOD>
      <A[16]RCPSPEC>
      <L[N ]NOI4
	<L[2]
	  <A[40]RCPPARNM>
	  <A[80]RCPPARVAL>
	>
      >
    >
    <T[1]PRPROCESSSTART>
    <L[N]NOI5>
      <U4[1]PRPAUSEEVENT>
    >
  >

S16F13_B	HW
  <L[5]
    <U2[1]DATAID>
    <L[N]NOI1
      <L[3]
	<A[16]PRJOBID>
	<B[ 1]MF>
	<L[N ]NOI2
	  <A[16]MID>
	>
      >
    >
    <L[3]
      <A[16]PRRECIPEMETHOD>
      <A[16]RCPSPEC>
      <L[N]NOI3
	<L[2]
	  <A[40]RCPPARNM>
	  <A[80]RCPPARVAL>
	>
      >
    >
    <T[1]PRPROCESSSTART>
    <L[N]NOI4>
      <U4[1]PRPAUSEEVENT>
    >
  >


S16F14		E
  <L[2]
    <L[N]NOI1
      <A[16]PRJOBID>
    >
    <L[2]
      <T[1]ACKA>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process job multi create
//
S16F15_A	W
  <L[2]
    <U2[1]DATAID>
    <L [N]NOI1
      <L[6]
	<A[16]PRJOBID>
	<B[ 1]MF>
	<L[N ]NOI2
	  <L[2]
	    <A[8]CARRIERID>
	    <L[N]NOI3
	      <U1[1]SLOTID>
	    >
	  >
	>
	<L[3]
	  <A[16]PRRECIPEMETHOD>
	  <A[16]RCPSPEC>
	  <L[N]NOI4
	    <L[2]
	      <A[40]RCPPARNM>
	      <A[80]RCPPARVAL>
	    >
	  >
	>
	<T[1]PRPROCESSSTART>
	<L[N]NOI5>
	  <U4[1]PRPAUSEEVENT>
	>
      >
    >
  >

S16F15_B	HW
  <L[2]
    <U2[1]DATAID>
    <L [N]NOI1
      <L[6]
	<A[16]PRJOBID>
	<B[ 1]MF>
	<L[ N]NOI2
	  <A[16]MID>
	>
	<L[3]
	  <A[16]PRRECIPEMETHOD>
	  <A[16]RCPSPEC>
	  <L[N ]NOI3
	    <L[2]
	      <A[40]RCPPARNM>
	      <A[80]RCPPARVAL>
	    >
	  >
	>
	<T[1]PRPROCESSSTART>
	<L[N]NOI4>
	  <U4[1]PRPAUSEEVENT>
	>
      >
    >
  >


S16F16		
  <L[2]
    <L[N]NOI1
      <A[16]PRJOBID>
    >
    <L[2]
      <T[1]ACKA>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process job dequeue
//
S16F17		HW
  <L[N]NOI1
    <A[16]PRJOBID>
  >


S16F18		E
  <L[2]
    <L[N]NOI1
      <A[16]PRJOBID>
    >
    <L[2]
      <T[1]ACKA>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process get all job
//
S16F19		HW


S16F20		E
  <L[N]NOI1
    <L[2]
      <A [16]PRJOBID>
      <U1[ 1]PRSTATE>
    >
  >



// -----------------------------------------------------------------------------
// Process get space
//
S16F21		HW


S16F22		E
  <U2[1]PRJOBSPACE>



// -----------------------------------------------------------------------------
// Process job set resipe variable
//
S16F23		HW
  <L[2]
    <A[16]PRJOBID>
    <L[N ]NOI1
      <L[2]
	<A[40]RCPPARNM>
	<A[80]RCPPARVAL>
      >
    >
  >


S16F24		E
  <L[2]
    <T[1]ACKA>
    <L[N]NOI1
      <L[2]
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Process job start method
//
S16F25		HW
  <L[2]
    <L[N]NOI1
      <A[16]PRJOBID>
    >
    <T[1]PRPROCESSSTART>
  >


S16F26		E
  <L[2]
    <L[N]NOI1
      <A[16]PRJOBID>
    >
    <L[2]
      <T[1]ACKA>
      <L[N]NOI2
	<L[2]
	  <U2[ 1]ERRCODE>
	  <A [80]ERRTEXT>
	>
      >
    >
  >



// -----------------------------------------------------------------------------
// Control job command request
//
S16F27		HW
  <L[3]
    <A [16]CTLJOBID>
    <U1[ 1]CTLJOBCMD>
    <L[2]
      <A[12]CPNAME>
      <A[24]CPVAL>
    >
  >


S16F28		E
  <L[2]
    <T[1]ACKA>
    <L[2]
      <U2[ 1]ERRCODE>
      <A [80]ERRTEXT>
    >
  >



// =============================================================================
// Stream#17 : Equipment control and diagnostics

// -----------------------------------------------------------------------------
// Abort transaction
//
S17F0



// -----------------------------------------------------------------------------
// Data report create request
//
S17F1		HW
  <L[4]
    <U2[0..1]DATAID>
    <U1[0..1]RPTID>
    <A [  16]DATASRC>
    <L [N   ]NOI1
      <U2[1]VID>
    >
  >


S16F2		E
  <L[2]
    <U1[0..1]RPTID>
    <U2[0..1]ERRCODE>
  >



// -----------------------------------------------------------------------------
// Data report delete request
//
S17F3		HW
  <L[N]NOI1
    <U1[1]RPTID>
  >


S17F4		E
  <L[2]
    <T[1]ACKA>
    <L[N]NOI1
      <L[3]
	<U1[ 1]RPTID>
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Trace create request
//
S17F5		HW
  <L[6]
    <U2[  1]DATAID>
    <A [  6]TRID>
    <T [  1]CEED>
    <L [N  ]NOI1
      <U1[1]RPTID>
    >
    <F4[1  ]TRSPER>
    <L [0|8]NOI2
      <U4[0.. 1]TOTSMP>
      <U2[0.. 1]REPGSZ>
      <A [0..16]EVNTSRC1>
      <U1[0.. 1]CEID1>
      <A [0..16]EVNTSRC2>
      <U1[0.. 1]CEID2>
      <T [0.. 1]TRAUTOD>
      <T [0.. 1]RPTOC>
    >
  >

S17F6		E
  <L[2]
    <A [   6]TRID>
    <U2[0..1]ERRCODE>
  >



// -----------------------------------------------------------------------------
// Trace delete request
//
S17F7		HW
  <L[N]NOI1
    <A[6]TRID>
  >


S17F8		E
  <L[2]
    <T[1]ACKA>
    <L[N]NOI1
      <L[3]
	<A [   6]TRID>
	<U2[0..1]ERRCODE>
	<A [  80]ERRTEXT>
      >
    >
  >



// -----------------------------------------------------------------------------
// Collection event link request
//
S17F9		HW
  <L[4]
    <U2[ 1]DATAID>
    <A [16]EVNTSRC>
    <U1[ 1]CEID>
    <L [N ]NOI1
      <U1[1]RPTID>
    >
  >


S17F10		E
  <L[3]
    <A [16]EVNTSRC>
    <U1[ 1]CEID>
    <U2[ 1]ERRCODE>
  >



// -----------------------------------------------------------------------------
// Collection event unlink request
//
S17F11		HW
  <L[3]
    <A [0..16]EVNTSRC>
    <U1[    1]CEID>
    <U1[    1]RPTID>
  >


S17F12		E
  <L[4]
    <A [0..16]EVNTSRC>
    <U1[    1]CEID>
    <U1[    1]RPTID>
    <U2[0.. 1]ERRCODE>
  >



// -----------------------------------------------------------------------------
// Trace reset request
//
S17F13		HW
  <L[N]NOI1
    <A[6]TRID>
  >


S17F14		E
  <L[2]
    <T[1]ACKA>
    <L[N]NOI1
      <L[3]
	<A [ 6]TRID>
	<U2[ 1]ERRCODE>
	<A [80]ERRTEXT>
      >
    >
  >



// =============================================================================
// Stream#18 : Subsystem control

// -----------------------------------------------------------------------------
// Abort transaction
//
S18F0



// -----------------------------------------------------------------------------
// Read attribute request
//
S18F1		HW
  <L[2]
    <A[6]TARGETID>
    <L[N]NOI1
      <A[6]ATTRID>
    >
  >


S18F2		E
  <L[4]
    <A[6]TARGETID>
    <A[2]SSACK>
    <L[N]NOI1
      <A[16]ATTRVAL>
    >
    <L[N]NOI2
      <A[16]STATUS>
    >
  >



// -----------------------------------------------------------------------------
// Write attribute request
//
S18F3		HW
  <L[2]
    <A[6]TARGETID>
    <L[N]NOI1
      <L[2]
	<A[ 6]ATTRID>
	<A[16]ATTRVAL>
      >
    >
  >


S18F4		E
  <L[3]
    <A[6]TARGETID>
    <A[2]SSACK>
    <L[N]NOI1
      <A[16]STATUS>
    >
  >



// -----------------------------------------------------------------------------
// Read data request
//
S18F5		HW
  <L[3]
    <A [    6]TARGETID>
    <A [0..16]DATASEG>
    <U4[0.. 1]DATALENGTH>
  >


S18F6		E
  <L[3]
    <A[       6]TARGETID>
    <A[       2]SSACK>
    <A[0..32768]DATA>
  >



// -----------------------------------------------------------------------------
// Write data request
//
S18F7		HW
  <L[4]
    <A [       6]TARGETID>
    <A [0..   16]DATASEG>
    <U4[0..    1]DATALENGTH>
    <A [0..32768]DATA>
  >


S18F8		E
  <L[3]
    <A[6]TARGETID>
    <A[2]SSACK>
    <L[N]NOI1
      <A[16]STATUS>
    >
  >



// -----------------------------------------------------------------------------
// Read id request
//
S18F9		HW
  <A[6]TARGETID>


S18F10		E
  <L[4]
    <A[ 6]TARGETID>
    <A[ 2]SSACK>
    <A[16]MID>
    <L[N ]NOI1
      <A[16]STATUS>
    >
  >



// -----------------------------------------------------------------------------
// Write id request
//
S18F11		HW
  <L[2]
    <A[ 6]TARGETID>
    <A[16]MID>
  >


S18F12		E
  <L[3]
    <A[ 6]TARGETID>
    <A[ 2]SSACK>
    <L[N ]NOI1
      <A[16]STATUS>
    >
  >



// -----------------------------------------------------------------------------
// Subsystem command request
//
S18F13		HW
  <L[3]
    <A[ 6]TARGETID>
    <A[16]SSCMD>
    <L[N ]NOI1
      <A[24]CPVAL>
    >
  >


S18F14		E
  <L[3]
    <A[ 6]TARGETID>
    <A[ 2]SSACK>
    <L[N ]NOI1
      <A[16]STATUS>
    >
  >



// =============================================================================
