
// ============================================================================
// SML format message definition file sample (TDS, tdlSSimE)
//
// Please refer to Chapter A of the Programmer's Manual (TDSE.pdf) included in
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// our product "Trust Design Simple SECS/HSMS Communication Library (TDS)" for
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// the configuration of this file.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// Download the product (TDS) from our website (http://www.trust-design.co.jp/).
//

// ============================================================================
// SML format SECS message definition sample
//
// The following briefly describes the method.
//
// Be sure to check the details in the corresponding chapter of TDSE.pdf shown
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// at the beginning.
// ~~~~~~~~~~~~~~~~~
//
// + The message name is composed of "SxFy_ZZZZ".
//   (Multiple messages of the same SF-Code can be defined by the difference in
//   structure)
//   x    : Stream code
//   y    : Function code
//   ZZZZ : Any name (don't care)
//
// + Specify a combination of characters specifying message attributes after
//   the message name.
//   H    : Host  side outgoing message
//   E    : Equip side outgoing message
//   W    : Primary message waiting to receive secondary message
//   D    : Default secondary message
//
// + List definition line
//   <L[n]   or   <L[N]name   or   <L[m..x]name   or   <L[0|x]name
//   n    : Number of list items         (fixed number of items)
//   N    : Keyword 'N' indicating that the number of list items is undefined
//   m    : Minimum number of list items (number of items undefined)
//   x    : Maximum number of list items (number of items undefined)
//   name : Name used to determine the number of items in the indeterminate
//           list
//
// + Item definition line
//   <X[n]name    "v0[,v1[,...]]" ["c00[,c01[,...]]" [... ["c30[,c31[,...]]"]]]>
//   or  
//   <X[m..x]name "v0[,v1[,...]]" ["c00[,c01[,...]]" [... ["c30[,c31[,...]]"]]]>
//
//   X      : Item type
//            B:1B Binary          I1:1B Signed integer   U1:1B Unsigned integer
//            T:1B Logical         I2:2B Signed integer   U2:2B Unsigned integer
//            A:1B Ascii Chara.    I4:4B Signed integer   U4:4B Unsigned integer
//            J:1B JIS-8 Chara.    I8:8B Signed integer   U8:8B Unsigned integer
//            K:2B Japanese Chara. F4:4B IEEE Floating    F8:8B IEEE Floating
//   n      : Number of items         (fixed number of items)
//   m      : Minimum number of items (number of items undefined)
//   x      : Maximum number of items (number of items undefined)
//   name   : Item name
//   v0 ..  : Default field value to use when sending
//            In the case of multiple items, the whole is enclosed by '"' and
//            the elements are separated by ','. In the case of character items,
//            it is specified as a character string.
//   c00 .. : In the case of multiple field values (up to 4 (4 groups can be
//            specified)) to be used for checking upon reception, specify in the
//            same format as v0.
//"



// ============================================================================

S1F1		W
S1F2_H		H
  <L[0]
  >
S1F2_E		E
  <L[2]
    <A[6]MDLN	 "EQUIP1">
    <A[6]SOFTREV "20.090">
  >


// ----------------------------------------------------------------------------

S1F13_H		HW
  <L[0]
  >

S1F14_E		E
  <L[2]
    <B[1]COMMACK   "0">
    <L[2]
      <A[6]MDLN	   "EQUIP1">
      <A[6]SOFTREV "20.090">
    >
  >


S1F13_E		EW
  <L[2]
    <A[6]MDLN	 "EQUIP1">
    <A[6]SOFTREV "20.090">
  >

S1F14_H		H
  <L[0]
  >


// ----------------------------------------------------------------------------
// Confirmation message for all data types

S1F21		HEW
  <L[4]
    <L[2]
      <B[2]VB	"1,0xff">
      <T[2]VT	"F,T">
    >
    <L[3]
      <A[6]MDLN		"MSG21">
      <J[0..8]SOFTREV	"Soft 01">
      <K[0..80]COMMENT	"This is Primary comment">
    >
    <L[9]
      <I1[2]VI1		"2,-128">
      <I2[2]VI2		"32767,-32767">
      <I4[2]VI4		"0x7ffffffe,0xfffffffe">
      <I8[2]VI8		"0x7fffffffffffffff,0x800080008000800b">
      <U1[2]VU1		"0x7f,0xff">
      <U2[2]VU2		"0x7ffe,0xfffe">
      <U4[2]VU4		"0x7ffffffd,0xfffffffd">
      <U8[2]VU8		"0x7fffffffffffffff,0x800080008000800b">
      <U8[1..10]AU8	"7,-6,5,-4,3,-2,1">
    >
    <L[2]
      <F4[2]VF4		"9.87654321e-21,-8.642097531e13">
      <F8[2]VF8		"-1.9283746574839201e123,9.1827364546372819208e-213">
    >
  >

S1F22   	HE
  <L[4]
    <L[2]
      <B[2]VB		"2,0xfe">
      <T[2]VT		"T,F">
    >
    <L[3]
      <A[6]MDLN		"MSG22">
      <J[0..8]SOFTREV	"Revision">
      <K[0..80]COMMENT	"This is primary comment">
    >
    <L[9]
      <I1[2]VI1		"127,-2">
      <I2[2]VI2		"32766,-32768">
      <I4[2]VI4		"2147483646,-2147483648">
      <I8[2]VI8		"0x8000000000000000,0x7ffffffffffffffe">
      <U1[2]VU1		"254,0xff">
      <U2[2]VU2		"65534,0xffff">
      <U4[2]VU4		"4294967294,0xffffffff">
      <U8[2]VU8		"18446744073709551614,0xffffffffffffffff">
      <U8[1..10]AU8	"-1,2,-3,4,-5,6,-7">
    >
    <L[2]
      <F4[2]VF4		"7.89012345e-12,-4.321098765e31">
      <F8[2]VF8		"5.6473829101928374e189,-3.2109876543210987654e-179">
    >
  >


// ----------------------------------------------------------------------------

S2F49		HW
  <L[3]
    <B[1]DATAIDB	"0x00">
    <A[1..10]RCMD	"LOAD">
    <L[4]
      <B[1]STID		"0x01">
      <B[1]MTKD		"0x00">
      <A[20]LOTID	"LOTID (9999)">
      <L[N]NOI1
	<L[N]NOI2
	  <L[2]
	    <A[20]WAFERID	"">
	    <A[16]PPID		"PPID">
	  >
	>
      >
    >
  >

S2F50		E
  <L[2]
    <B[1]HCACK		"0x00">
    <L[2]
      <A[16]PPID	"PPID">
      <A[20]LOTID	"LOTID (9999)">
    >
  >


// ----------------------------------------------------------------------------
// Defining 'D' as an attribute of the secondary message will be the default
// secondary message for all corresponding primary messages (S5F1 in the
// example below)

S5F2            HD
  <B[1]ACKC5 "0x00">


// ----------------------------------------------------------------------------
// S6F11_0 is used for SendS6F11() of each sample in this folder
// S6F11_1 is a sample of an indefinite number list in L[N] style
// S6F11_2 is a sample of an indefinite number list in L[n..x] style
// S6F11_3 is a sample of an indefinite number list in L[0|x] style
// S6F11_4 is a sample that discriminates messages based on data values with
//         the same structure

S6F11_0		EW
  <L[3]
    <U2[1]DATAID	"0x00">
    <U2[1]CEID		"8">
    <L[3]
      <A[16]DATA1	"This is DATA1">
      <A[16]DATA2	"This is DATA2">
      <A[14]@TIME	"YYYYMMDDhhmmss">
    >
  >

S6F11_1		EW
  <L[N]NOI0
    <U2[1]REPDATA	"0x00">
  >

S6F11_2		EW
  <L[3]
    <U2[1]DATAID	"0x00">
    <U2[1]CEID		"8">
    <L[0..2]NOI1
      <L[3]
        <A[16]DATA1	"This is DATA1">
        <A[16]DATA2	"This is DATA2">
        <A[14]@TIME	"YYYYMMDDhhmmss">
      >
    >
  >

S6F11_3		EW
  <L[3]                         // If NOI1=0, the result is the same as S6F11_2
    <U2[1]DATAID	"0x00"> // If NOI1=3, the result is the same as S6F11_0
    <U2[1]CEID		"8">
    <L[0|3]NOI1
      <A[16]DATA1	"This is DATA1">
      <A[16]DATA2	"This is DATA2">
      <A[14]@TIME	"YYYYMMDDhhmmss">
    >
  >


S6F12		HD
  <B[1]ACKC6		"0x00">


// ----------------------------------------------------------------------------

S6F11_4_101	EW      // Matches when RPTID=101,102 in S6F11_4 data structure
  <L[4]
    <U2[1]DATAID	"0x00">
    <U2[1]CEID		"123">
    <U2[1]RPTID		"101" "101" "102">
    <L[2]
      <A[0..80]MSSG1	"This is messgae for REPID=101,102">
      <A[0..80]MSSG2	"Report message contents">
    >
  >

S6F12_4_101	H       // Used as a reply to S6F11_4_101
  <I1[1]ACKC6		"101">


S6F11_4_202	EW      // Matches when RPTID=202,203 in S6F11_4 data structure
  <L[4]
    <U2[1]DATAID	"0x00">
    <U2[1]CEID		"123">
    <U2[1]RPTID		"202" "202" "203">
    <L[2]
      <A[0..80]MSSG1	"This is messgae for REPID=202,203">
      <A[0..80]MSSG2	"Report message contents">
    >
  >

S6F12_4_202 	H       // Used as a reply to S6F11_4_202
  <U1[1]ACKC6		"202">


S6F11_4_999 	EW      // Matches in S6F11_4 data structures regardless of
  <L[4]                 // RPTID value
    <U2[1]DATAID	"0x00">
    <U2[1]CEID		"123">
    <U2[1]RPTID		"999">
    <L[2]
      <A[0..80]MSSG1	"This is messgae for ETC">
      <A[0..80]MSSG2	"Report message contents">
    >
  >

S6F12_4_999	H               // Reply for S6F12_4 structures other than
  <U2[1]ACKC62		"999">  // RPTID=101,102,202,203



// ----------------------------------------------------------------------------
// System Error Message definition

S9F1				// Undefined DeviceID
  <B[10]MHEAD>

S9F3				// Undefined Stream Type
  <B[10]MHEAD>

S9F5				// Undefined Function Type
  <B[10]MHEAD>

S9F7				// Illegal Data
  <B[10]MHEAD>

S9F9				// Trunsaction Timer Timeout
  <B[10]MHEAD>

S9F11				// Data too large
  <B[10]MHEAD>



// ----------------------------------------------------------------------------
// Defining a Conversation Timeout Message for a Specific Message
// The following is an example message from SemiStandard

S9F13_0				// Conversation timeout (S2F3)
  <L[2]
    <A[ 6]MEXP "S2F3"  "S2F3">	// S2F3
    <B[0..16777215]SPD>	        // SPD
  >

S9F13_1				// Conversation timeout (S3F13)
  <L[2]
    <A[ 6]MEXP "S3F13" "S3F13">	// S3F13
    <B[ 1]PTN>			// PTN
  >

S9F13_2				// Conversation timeout (S7F3)
  <L[2]
    <A[ 6]MEXP "S7F3"  "S7F3">	// S7F3
    <A[16]PPID>			// PPID
  >

S9F13_3				// Conversation timeout (S7F13)
  <L[2]
    <A[ 6]MEXP "S7F13" "S7F13">	// S7F13
    <A[16]PPID>			// PPID
  >

